<?php

/*
  lee los archivos .json de la carpeta "notificaciones" y actualiza los datos necesarios
 *  */
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once dirname(__FILE__) . '/../lib/Autoload.php';

if( !(PHP_SAPI === 'cli' || PHP_SAPI === 'cgi-fcgi') && (!isset($_REQUEST['param']) || $_REQUEST['param'] !== 'yes' ) )
{
    echo('not allowed');
    exit;
}

/*if( !(PHP_SAPI === 'cli' || PHP_SAPI === 'cgi-fcgi') && !current_user_can('edit_posts') )
{
    echo('user not allowed!!');
    exit;
}*/


/* if( Funciones::is_enabled_integ_inventario() != true )
  {
  echo('not enabled');
  exit;
  } */

read_avisos();

//leo archivos .json y los envío a la integración. 
//Luego, los muevo a carpeta "procesados" para que se sepa que se han procesado
function read_avisos()
{
    $dir = dirname(__FILE__) . '/notificaciones/';

    // Open a directory, and read its contents
    if( !is_dir($dir) )
    {
        Funciones::print_r_html("function read_avisos(), '$dir' no es un folder");
        return false;
    }
    $dh = opendir($dir);

    if( $dh === false )
    {
        Funciones::print_r_html("function read_avisos(), '$dir' opendir no pudo abrirlo");
        return false;
    }

    $i = 0; //solo lee de a tres file spor pasada

    while( ($file = readdir($dh)) !== false )
    {
        if( $file === '.' || $file === '..' )
        {
            continue;
        }
        //solo archivos .json
        if( !has_file_extension($file, 'json') )
        {
            //Funciones::print_r_html("function read_avisos(), '$file' no es json");
            continue;
        }
        //solo archivos .json
        Funciones::print_r_html("read_avisos(), procesando filename: '" . $dir . $file . "' ...");
        procesar_aviso($dir, $file);


        $i++;
        //solo de a tres notif por minuto
        if( $i >= 200 )
        {
            return true;
        }
    }

    //sync all pack con prefijo
    if( $i > 0 )
    {
        $prefijo_skus = defined('PACKS_SKU_PREFIJO') && !empty(PACKS_SKU_PREFIJO) ? explode(',', trim(PACKS_SKU_PREFIJO)) : null;

        if( is_array($prefijo_skus) && count($prefijo_skus) > 0 )
        {
            Funciones::print_r_html($prefijo_skus, "sku prefijo");
           
            $prod = new ProductWP();
            $product_ids = $prod->get_all_products_ids();

            foreach( $product_ids as $product_id )
            {
                $result = WpBsale::product_sync_from_bsale($product_id, $prefijo_skus);
            }
        }
    }


    closedir($dh);
   
    $utils = new Utils();
    //borro logs antiguos
    $utils->delete_old_logs();
}

/**
 * abre archivo, lee el json, lo envia al aintegracion y guarda el json
 * en la carpeta procesados
 * @param type $file
 */
function procesar_aviso($dir, $file)
{
    $post_vars = file_get_contents($dir . $file);
    $post_vars = trim($post_vars);

    if( defined('MULTIVENDOR') && MULTIVENDOR === true )
    {
        //extraigo nro cliente del nombre de archivo
        $client_id = 0;
    }
    else
    {
        $client_id = 0;
    }


    //dokan: get $client_id from filename y así sé de quién son los prods a updatear
    //paso a json
    $post_vars_array = json_decode($post_vars, true);

    //es un recurso?
    if( !isset($post_vars_array['topic']) )
    {
        Funciones::print_r_html("no vienen datos de orden o json está mal formado. Recibido: '$post_vars' en archivo $dir/$file");
        //muevo archivo a carpeta de procesados
        $folder_procesados = dirname(__FILE__) . '/procesados/';
        $res = rename("{$dir}{$file}", "{$folder_procesados}{$file}");
        return false;
    }

    //agrego cliente id
    $post_vars_array['client_id'] = $client_id;

    //detecto el tipo de recurso 
    $topic = $post_vars_array['topic'];

    //variable global con nombre de archivo en proceso
    global $global_file_update_product;
    $global_file_update_product = $file;

    $bsale = new Bsale();

    //el do solo es por los transients
    //solo he ocnseguido refrescar la cahe de get_variable_prices cambiando 
    //los datos de precio y stock dos veces para cada producto. Por ahora, disabled
    $i = 0;
    do
    {

        switch( $topic )
        {
            case 'document':
                $result = $bsale->do_document($post_vars_array, true, true);
                break;
            case 'product':
                $result = $bsale->do_product($post_vars_array, true, true, true);
                break;
            case 'variant':
                $result = $bsale->do_variant($post_vars_array, true, true);
                break;
            case 'price':
                $result = $bsale->do_variant($post_vars_array, true, true);
                //$bsale->do_price($post_vars_array, true, true);
                break;
            case 'stock':
                $result = $bsale->do_variant($post_vars_array, true, true);
                //$bsale->do_stock($post_vars_array, true, true);
                break;
        }
        $i++;
        // sleep(1);
    }
    while( $i <= 0 ); //dejar en  $i <= 1 si se desea que el aviso se envie dos veces y descomentar sleep()
    //Solo Linio. true or false, para saber si mover el file a procesados o no
    if( isset($result['result']) )
    {
        if( $result['result'] !== true )
        {
            Funciones::print_r_html("procesar_aviso rename('{$dir}{$file}', error. Se mantiene en carpeta de notificaciones");
            return;
        }
        else
        {
            //muevo archivo a carpeta de procesados
            $folder_procesados = dirname(__FILE__) . '/procesados/';
            $res = rename("{$dir}{$file}", "{$folder_procesados}{$file}");
        }
    }
    else
    {
        //muevo archivo a carpeta de procesados
        $folder_procesados = dirname(__FILE__) . '/procesados/';
        $res = rename("{$dir}{$file}", "{$folder_procesados}{$file}");
    }


    $global_file_update_product = null;

    Funciones::print_r_html("procesar_aviso rename('{$dir}{$file}', '{$folder_procesados}{$file}'), respuesta: $res");
}

// check if  string ends with specific sub-string
function has_file_extension($filename, $ext)
{
    $length = strlen($ext);
    if( $length == 0 )
    {
        return true;
    }

    return (substr($filename, -$length) === $ext);
}
