<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once dirname(__FILE__) . '/../lib/Autoload.php';

//otros archivos a los que se deben copiar los mensajes de Bsale
global $FOLDERS_WEBHOOK_ARR;

//sin trailing /
$FOLDERS_WEBHOOK_ARR = array();

if( Funciones::is_resend_avisos_bsale() )
{
    $FOLDERS_WEBHOOK_ARR[] = dirname(__FILE__) . '/resend';
    
    //Funciones::print_r_html("resend avisos bsale on"); 
}

$post_vars = file_get_contents("php://input"); //$_POST;

if( isset($_GET['rid']) )
{
    $resource = isset($_GET['test']) ? $_GET['test'] : 'variant';
    $resourceId = isset($_GET['rid']) ? (int) $_GET['rid'] : 0;

    if( $resourceId <= 0 )
    {
        die('faltan datos para el resource');
    }

    switch( $resource )
    {
        case 'doc':
            $post_vars = '{"cpnId":10615,"resource":"/v2/products/' . $resourceId . '.json","resourceId":"' . $resourceId . '","topic":"product","action":"post","send":1552959459}';
            break;
        case 'product':
            $post_vars = '{"cpnId":10615,"resource":"/v2/products/' . $resourceId . '.json","resourceId":"' . $resourceId . '","topic":"product","action":"post","send":1552959459}';
            break;

        case 'variant':
            $post_vars = '{"cpnId":10615,"resource":"/v2/variants/' . $resourceId . '.json","resourceId":"' . $resourceId . '","topic":"variant","action":"put","send":1553289004}';
            break;

        case 'price':
            $post_vars = '{"cpnId":10615,"resource":"/v2/price_lists/18/details.json?variant=' . $resourceId . '","resourceId":"' . $resourceId . '","topic":"price","action":"put","priceListId":"18","send":1553289073}';
            break;

        case 'stock':
            $post_vars = '{"cpnId":10615,"resource":"/v2/stocks.json?variant=' . $resourceId . '\u0026office=5","resourceId":"' . $resourceId . '","topic":"stock","action":"put","officeId":"5","send":1552920885}';
            break;
    }
}//solo test, por ahora
else
{
    // exit(0);
}

//dokan: client id debe venir en al url
$client_id = isset($_GET['client_id']) ? $_GET['client_id'] : 0;

$post_vars_array = json_decode($post_vars, true);

$hoy = date('Y-m-d');
$fichero = dirname(__FILE__) . "/logs/bsale_product_webhook-$hoy.log";


$txt = date('d-m-Y H:i:s') . "\n" . $post_vars . "\n----------------\n";
file_put_contents($fichero, $txt, FILE_APPEND | LOCK_EX);

//es un recurso?
if( !isset($post_vars_array['topic']) )
{
    echo( json_encode("no vienen datos de orden o json está mal formado. Recibido: '$post_vars'", JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) );
    exit(0);
}
log_avisos($post_vars, $post_vars_array);

echo(json_encode('ok'));
exit(0);

function log_avisos($post_vars, $post_vars_array, $client_id = 0)
{
    $topic = $post_vars_array['topic'];
    $resourceId = $post_vars_array['resourceId'];
    $post_vars = trim($post_vars);

    $hoy = date('Y-m-d');
    //dokan archivos deben llevar: {client_id}_{$hoy}_{$topic}_{$resourceId}
    $fichero = dirname(__FILE__) . "/notificaciones/{$hoy}_{$topic}_{$resourceId}.json";

    if( $client_id > 0 )
    {
        $fichero = dirname(__FILE__) . "/notificaciones/{$client_id}_{$hoy}_{$topic}_{$resourceId}.json";
    }
    //guardo json
    file_put_contents($fichero, $post_vars);

    //guardo en otros archivos, de ser necesario
    global $FOLDERS_WEBHOOK_ARR;

    if( !is_array($FOLDERS_WEBHOOK_ARR) || count($FOLDERS_WEBHOOK_ARR) <= 0 )
    {
        return;
    }

    //por cada carpeta, envio mensaje
    foreach( $FOLDERS_WEBHOOK_ARR as $folder )
    {
        $fichero_new = $fichero;
        //reeemplazo path
        $fichero_new = str_replace(dirname(__FILE__), $folder, $fichero_new);
        $fichero_new = str_replace('notificaciones/', '', $fichero_new);

        //Funciones::print_r_html("copio aviso de Bsale a '$fichero_new'");
        file_put_contents($fichero_new, $post_vars);
    }
}
