<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
require_once dirname(__FILE__) . '/../Autoload.php';

/**
 * Description of WpUtils
 *
 * @author Lex
 */
class WpUtils
{

    function __construct()
    {
        
    }

    public function setup()
    {
        
    }

    public function get_cart_items()
    {
        
    }

    public static function bsale_orders_filter($post_type)
    {
        // Check this is the products screen
        if( $post_type !== 'shop_order' )
        {
            return;
        }

        $selected = isset($_GET['bsale_order_filter']) ? $_GET['bsale_order_filter'] : '';


        $arr = array(
            'b' => 'Ver pedidos con boleta emitida',
            'f' => 'Ver pedidos con factura emitida',
            'nv' => 'Ver pedidos con nota de venta emitida',
            'nc' => 'Ver pedidos con nota de crédito emitida',
        );

        $html = '<select name="bsale_order_filter" id="bsale_order_filter" style="border: 2px solid #ff5c1a;">';
        $html .= '<option value>Filtro Bsale para pedidos</option>';

        foreach( $arr as $key => $value )
        {
            $sel = selected($selected, $key, false);
            $html .= "<option value='$key' $sel title='$value'>$value</option>";
        }
        $html .= "</select>";

        echo $html;
    }

    public static function apply_my_custom_orders_filters($query)
    {

        global $pagenow;

// Ensure it is an edit.php admin page, the filter exists and has a value, and that it's the products page
        if( $query->is_admin && $pagenow == 'edit.php' && isset($_GET['bsale_order_filter']) &&
                $_GET['bsale_order_filter'] !== '' && $_GET['post_type'] === 'shop_order' )
        {

            $selected = $_GET['bsale_order_filter'];

            //segun el docto, es el campo meta a consultar
            $meta_key = '';

            switch( $selected )
            {
                case 'b':
                    $meta_key = 'bsale_docto_folio_boleta';
                    break;
                case 'f':
                    $meta_key = 'bsale_docto_folio_factura';
                    break;
                case 'nv':
                    $meta_key = 'bsale_docto_folio_nv';
                    break;
                case 'nc':
                    $meta_key = 'bsale_docto_folio_nc';
                    break;

                default:
                    break;
            }

            // Create meta query array and add to WP_Query
            $meta_key_query = array(
                array(
                    'key' => $meta_key,
                    'value' => array( '' ),
                    'compare' => 'NOT IN',
                )
            );
            $query->set('meta_query', $meta_key_query);
        }
    }

    /**
     * agrega en el admin de productos un filtro de prods que no están en bsale
     */
    public static function bsale_product_exists_filter($post_type)
    {
        // Check this is the products screen
        if( $post_type !== 'product' )
        {
            return;
        }

        $value1 = '';
// Check if filter has been applied already so we can adjust the input element accordingly

        if( isset($_GET['bsale_prod_filter']) )
        {
            switch( $_GET['bsale_prod_filter'] )
            {

                // We will add the "selected" attribute to the appropriate <option> if the filter has already been applied
                case 1:
                    $value1 = ' selected';
                    break;

                default:
                    break;
            }
        }

        // Add your filter input here. Make sure the input name matches the $_GET value you are checking above.
        echo '<select name="bsale_prod_filter" id="bsale_prod_filter" style="border: 2px solid #ff5c1a;">';
        echo '<option value>Filtro productos Bsale</option>';
        echo '<option value="1"' . $value1 . ' title="Muestra los productos de woocommerce cuyo sku no pertenece a ningún producto de Bsale">Ver productos no creados en Bsale</option>';
        echo '</select>';
    }

    public static function apply_my_custom_product_filters($query)
    {

        global $pagenow;

// Ensure it is an edit.php admin page, the filter exists and has a value, and that it's the products page
        if( $query->is_admin && $pagenow == 'edit.php' && isset($_GET['bsale_prod_filter']) &&
                $_GET['bsale_prod_filter'] !== '' && $_GET['post_type'] === 'product' )
        {

            // Create meta query array and add to WP_Query
            $meta_key_query = array(
                array(
                    'key' => 'bsale_missed',
                    'value' => esc_attr($_GET['bsale_prod_filter']),
                )
            );
            $query->set('meta_query', $meta_key_query);
        }
    }

    /**
     * agrego metabox para editr datos de fact in order edit
     */
    public static function edit_campos_facturacion_custom_box()
    {
        $me = new WpUtils();

        add_meta_box(
                'bsale_edit_fact_id', // Unique ID
                'Bsale: Facturación', // Box title
                // 'bsale_edit_fact_custom_box_html',
                array( $me, 'bsale_edit_fact_custom_box_html' ), // Content callback, must be of type callable
                'shop_order', // Post type
                'side', //al lado
                'high'
        );
    }

    /**
     * html del metabox de self::edit_campos_facturacion_custom_box()
     */
    public function bsale_edit_fact_custom_box_html($post)
    {
        //die('edit_fact_custom_box_html');
        //datos de fact de este pedido
        $order_id = $post->ID;

        if( empty($order_id) )
        {
            return;
        }

        $is_add_campos_checkout_boleta = Funciones::is_add_campos_checkout_boleta();
        $is_add_campos_checkout_factura = Funciones::is_add_campos_checkout_factura();

        //datos meta de facturacion
        $billing_tipo_documento = get_post_meta($order_id, '_billing_tipo_documento', true);
        // $billing_tipo_documento = empty($billing_tipo_documento) ? get_post_meta($order_id, 'billing_tipo_documento', true) : $billing_tipo_documento;

        $billing_rut = get_post_meta($order_id, '_billing_rut', true);
        //$billing_rut = empty($billing_rut) ? get_post_meta($order_id, 'billing_rut', true) : $billing_rut;

        $billing_company = get_post_meta($order_id, '_billing_company', true);
        //  $billing_company = empty($billing_company) ? get_post_meta($order_id, 'billing_company', true) : $billing_company;
        //peru
        $billing_ruc = get_post_meta($order_id, '_billing_ruc', true);
        //$billing_ruc = empty($billing_ruc) ? get_post_meta($order_id, 'billing_ruc', true) : $billing_ruc;

        $billing_giro = get_post_meta($order_id, '_billing_giro', true);
        //  $billing_giro = empty($billing_giro) ? get_post_meta($order_id, 'billing_giro', true) : $billing_giro;

        $billing_direccion_fiscal = get_post_meta($order_id, '_billing_direccion_fiscal', true);
        //$billing_direccion_fiscal = empty($billing_direccion_fiscal) ? get_post_meta($order_id, 'billing_direccion_fiscal', true) : $billing_direccion_fiscal;


        if( Funciones::get_pais() === 'CL' )
        {
            if( $is_add_campos_checkout_factura )
            {
                ?>
                <p>Puede cambiar los datos de facturación para este pedido. Debe hacerlo antes de que el pedido cambie al estado
                    en que se emite la boleta o factura.</p>
                <ul class="bsale_edit_datos_fact" style="color: #d74f04;text-transform: uppercase;">
                    <li>
                        <label for="billing_tipo_documento"><strong>¿Boleta o factura?</strong></label>
                        <select name="billing_tipo_documento" id="billing_tipo_documento" class="postbox" style="margin-bottom: 0;">
                            <option value="">--seleccione--</option>
                            <option value="boleta" <?php selected($billing_tipo_documento, 'boleta'); ?>>Boleta</option>
                            <option value="factura" <?php selected($billing_tipo_documento, 'factura'); ?>>Factura</option>
                        </select>
                    </li>
                    <li>
                        <label for="billing_rut"><strong>Rut para boleta/factura</strong></label>
                        <input type="text" name="billing_rut" id="billing_rut" class="postbox"  style="margin-bottom: 0;" value="<?php echo $billing_rut; ?>" />
                    </li>
                    <li>
                        <label for="billing_company"><strong>Nombre de la empresa (solo factura)</strong></label>
                        <input type="text" name="billing_company" id="billing_company" class="postbox"  style="margin-bottom: 0;" value="<?php echo $billing_company; ?>" />
                    </li>
                    <li>
                        <label for="billing_giro"><strong>Giro de la empresa (solo factura)</strong></label>
                        <input type="text" name="billing_giro" id="billing_giro" class="postbox"  style="margin-bottom: 0;" value="<?php echo $billing_giro; ?>" />
                    </li>
                </ul>

                <?php
            }
            elseif( $is_add_campos_checkout_boleta )
            {
                ?>
                <p>
                    <label for="billing_rut"><strong>Rut para boleta</strong></label>
                    <input type="text" name="billing_rut" id="billing_rut" class="postbox" value="<?php echo $billing_rut; ?>" />
                </p>
                <?php
            }
        }
        elseif( Funciones::get_pais() === 'PE' )
        {
            if( $is_add_campos_checkout_factura )
            {
                ?>
                <p>
                    <label for="billing_tipo_documento">'¿Boleta o factura?</label>
                    <select name="billing_tipo_documento" id="billing_tipo_documento" class="postbox">
                        <option value="">--seleccione--</option>
                        <option value="boleta" <?php selected($billing_tipo_documento, 'boleta'); ?>>Boleta</option>
                        <option value="factura" <?php selected($billing_tipo_documento, 'factura'); ?>>Factura</option>
                    </select>
                </p>
                <p>
                    <label for="billing_rut">DNI/CE (ingrese solo cifras)</label>
                    <input type="text" name="billing_rut" id="billing_rut" class="postbox"  value="<?php echo $billing_rut; ?>" />
                </p>

                <p>
                    <label for="billing_ruc">RUC de la empresa</label>
                    <input type="text" name="billing_ruc" id="billing_ruc" class="postbox"  value="<?php echo $billing_ruc; ?>" />
                </p>
                <p>
                    <label for="billing_company">Razón social</label>
                    <input type="text" name="billing_company" id="billing_company" class="postbox" value="<?php echo $billing_company; ?>" />
                </p>
                <p>
                    <label for="billing_direccion_fiscal">Dirección fiscal</label>
                    <input type="text" name="billing_direccion_fiscal" id="billing_direccion_fiscal" class="postbox" value="<?php echo $billing_direccion_fiscal; ?>" />
                </p>
                <p>
                    <label for="billing_giro">Giro de la empresa</label>
                    <input type="text" name="billing_giro" id="billing_giro" class="postbox" value="<?php echo $billing_giro; ?>" />
                </p>

                <?php
            }
            elseif( $is_add_campos_checkout_boleta )
            {
                ?>
                <p>
                    <label for="billing_rut">DNI/CE (ingrese solo cifras)</label>
                    <input type="text" name="billing_rut" id="billing_rut" class="postbox"  value="<?php echo $billing_rut; ?>" />
                </p>
                <?php
            }
        }
    }

    public static function edit_campos_facturacion_save_data($post_id)
    {
        $arr = array( 'billing_tipo_documento', 'billing_rut', 'billing_company',
            'billing_giro', 'billing_ruc', 'billing_direccion_fiscal' );

        foreach( $arr as $key )
        {
            if( array_key_exists($key, $_POST) )
            {
                $value = sanitize_text_field($_POST[$key]);

                update_post_meta($post_id, "_{$key}", $value);
            }
        }
    }

    /**
     * después de presionar el botón "finalizar compra" del checkout, reviso si hay stock en la
     * suc bsale asociada al medio de despacho elegido
     * @param type $fields
     * @param type $errors
     */
    public static function validar_stock_checkout_sucursales($fields, $errors)
    {
        $utils = new Utils();

        //solo si está habilitado el filtro
        if( !Funciones::is_enabled_shipping_filter_stock() )
        {
            return;
        }
        //debug: si es mi email, se ejecuta esta función
        $current_user = wp_get_current_user();
        $user_mail = $current_user->user_email;

        if( $user_mail === 'rmartinez@newclick.cl' || $user_mail === 'dang.clp@gmail.com' )
        {
            //continua el debug
        }
        else
        {
            return;
        }

        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html($fields, "user $user_mail, validar_stock_checkout_sucursales(), fields:");
        }

        global $woocommerce;
        $chosen_methods = WC()->session->get('chosen_shipping_methods');
        $chosen_shipping = $chosen_methods[0];

        $tienda_retiro = null;
        $tienda_retiro_orig = '';
        $shipings_arr = null;
        $shipings_to_display_arr = null;

        //si es pickup store (retiro en tienda)
        if( $chosen_shipping === 'wc_pickup_store' )
        {
            $tienda_retiro = isset($_REQUEST['shipping_pickup_stores']) ? $_REQUEST['shipping_pickup_stores'] : '';
            $tienda_retiro_orig = $tienda_retiro;

            //si no hay tienda retiro selected, no valido nada
            if( empty($tienda_retiro) )
            {
                return;
            }
        }
        else
        {
            $tienda_retiro = $chosen_shipping;
        }
        //formateo nombre
        $tienda_retiro = trim($tienda_retiro);
        $tienda_retiro = $utils->filter_chars($tienda_retiro);
        $tienda_retiro = strtolower($tienda_retiro);

        //busco sucuarsal id bsale asociada a este medio de envio
        //arreglo: titulo medio envio wc=>id sucursal bsale
        $shipings_arr = $utils->get_array_medios_envio($tienda_retiro);

        //prods del carro
        $cart = $woocommerce->cart->get_cart();

        //arreglo con productos del carro: sku=>cantidad
        $prods_arr = array();
        $prods_names_arr = array();

        // Loop over $cart items
        foreach( $cart as $cart_item_key => $cart_item )
        {
            $product = $cart_item['data'];
            $product_id = $cart_item['product_id'];
            $quantity = $cart_item['quantity'];
            $sku = $product->get_sku();
            $item_name = $product->get_title();
            $link = $product->get_permalink($cart_item);

            //si ya está este sku, sumo la cantidad. Else, la agrego
            if( isset($prods_arr[$sku]) )
            {
                $prods_arr[$sku] += $quantity;
            }
            else
            {
                $prods_arr[$sku] = $quantity;
            }
            $prods_names_arr[$sku] = array( 'name' => $item_name, 'link' => $link );
        }

        //si no hay prods en el carro, retorno
        if( count($prods_arr) <= 0 )
        {
            return;
        }

        //busco prods con stock en las sucursales de Bsale:
        //las sucursales e Bsale tienen stock para todos los productos del carro?
        $wpbsale = new WpBsale();
        $shipings_to_display_arr = $wpbsale->get_shipping_sucursal_stock2($shipings_arr, $prods_arr);


        //debug
        /* $errors->add('validation', "Medio de envio: '$chosen_shipping', tienda retiro: '$tienda_retiro'");
          $errors->add('validation', "shippings en los que buscar stock: " . print_r($shipings_arr, true));
          $errors->add('validation', "prods del carro: " . print_r($prods_arr, true));
          $errors->add('validation', "prods y links: " . print_r($prods_names_arr, true));
          $errors->add('validation', "shippings a mostrar: " . print_r($shipings_to_display_arr, true)); */

        //si state es true, todos los prods del carro tienen stock
        if( $shipings_to_display_arr['state'] == true )
        {
            return;
        }

        //mensaje real, de falta de stock
        $prods_sin_stock = current($shipings_to_display_arr)['prods_sin_stock'];

        $errors->add('validation', "prods sin stock: " . print_r($prods_sin_stock, true));

        $arraux = array();

        foreach( $prods_sin_stock as $p )
        {
            $sku = $p['sku'];

            $prod_data = isset($prods_names_arr[$sku]) ? $prods_names_arr[$sku] : null;

            if( $prod_data == null )
            {
                continue;
            }

            $name = $prod_data['name'];
            $link = $prod_data['link'];

            //obtengo nombre y link del prod con este sku
            $arraux[] = "<li><a href='$link' target='_blank' title='$name'>$name</a></li>";
        }

        //nada que mostrar
        if( count($arraux) <= 0 )
        {
            return;
        }
        $cart_url = wc_get_cart_url();

        $list = '<ul class="prods_sin_stock_bsale">' . implode("\n", $arraux) . '</ul>';
        $msj = "<div class='bsale_stock_error'>"
                . "<p class='titulo'>Los siguientes productos no tienen stock en '$tienda_retiro_orig'.<br/>"
                . "Debe sacarlos del carro para poder terminar la compra:</p>\n"
                . $list
                . "<p class='cart_link'><a href='$cart_url'>Ir al carro</a></p>";



        //mensaje real
        $errors->add('validation', $msj);
    }

    /**
     * guarda datos de billing para facturación
     * en sesion de wc, para pre llenarlos después
     */
    public static function save_billing_data($order_id)
    {
        if( !$order_id )
        {
            return;
        }
        // Getting an instance of the order object
        $order = wc_get_order($order_id);

        if( $order->is_paid() )
        {
            $paid = 'yes';
        }
        else
        {
            $paid = 'no';
        }

        $billing_tipo_documento = get_post_meta($order_id, '_billing_tipo_documento', true);
        $billing_tipo_documento = strtolower($tipo_documento);
        $billing_tipo_documento = empty($tipo_documento) ? strtolower(get_post_meta($order_id, 'billing_tipo_documento', true)) : $tipo_documento;

        $billing_rut = get_post_meta($order_id, 'billing_rut', true);
        $billing_rut = empty($billing_rut) ? strtolower(get_post_meta($order_id, '_billing_rut', true)) : $billing_rut;


        //giro, en  caso de factura
        $billing_giro = get_post_meta($order_id, 'billing_giro', true);
        $billing_giro = empty($billing_giro) ? strtolower(get_post_meta($order_id, '_billing_giro', true)) : $billing_giro;

        /* Funciones::print_r_html($_GET, "save_billing_data,rut=$billing_rut,  get:");
          Funciones::print_r_html($_POST, "save_billing_data, post:");
          die("save_billing_data"); */



        // Set the session data
        WC()->session->set('custom_data_bsale', array(
            'billing_tipo_documento' => $billing_tipo_documento,
            'billing_rut' => $billing_rut,
            'billing_giro' => $billing_giro ));


        if( isset($_REQUEST['param']) )
        {
            $data = WC()->session->get('custom_data_bsale');
            Funciones::print_r_html($data, "prefill_billing_fields,  WC()->session->get('custom_data_bsale') contiene:");
            //Funciones::print_r_html($address_fields, "prefill_billing_fields,  campos billing que vienen desde WC");
        }
    }

    /** carga en el checkout de woocommerce los datos prefilled del checkout */
    public static function prefill_billing_fields($address_fields)
    {
        if( WC()->session == null )
        {
            if( isset($_REQUEST['param']) )
            {
                //Funciones::print_r_html($address_fields, "prefill_billing_fields, WC()->session is null");
            }
            return $address_fields;
        }
        // Get the session data
        $data = WC()->session->get('custom_data_bsale');

        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html($data, "prefill_billing_fields,  WC()->session->get('custom_data_bsale') contiene:");
            //Funciones::print_r_html($address_fields, "prefill_billing_fields,  campos billing que vienen desde WC");
        }
        // First Name
        if( isset($data['billing_tipo_documento']) && !empty($data['billing_tipo_documento']) )
        {
            $address_fields['billing_tipo_documento']['default'] = $data['billing_tipo_documento'];
        }
        if( isset($data['billing_rut']) && !empty($data['billing_rut']) )
        {
            $address_fields['billing_rut']['default'] = $data['billing_rut'];
        }
        if( isset($data['billing_giro']) && !empty($data['billing_giro']) )
        {
            $address_fields['billing_giro']['default'] = $data['billing_giro'];
        }

        return $address_fields;
    }

    /**
     * AGREGA METABOX CON STOCK POR SUCURSALES AL EDITR DE PRODUCTOS
     */
    public static function stock_sucursales_product_edit()
    {
        $screens = array( 'product' );

        foreach( $screens as $screen )
        {
            add_meta_box(
                    'bsalestock-notice', 'Stock disponible en Bsale', 'bsale_stock_sucursales_product_html_back', $screen, 'side', //Where on the page the meta box should be shown. The available options are normal, advanced, and side
                    'high'         // Priority
            );
        }
    }

    public static function wc_bsale_stock_por_sucursal()
    {
        global $post;
        $post_id = $post->ID;
        $product_id = $post_id;

        $product = wc_get_product($product_id);

        //es prod válido?
        if( !$product )
        {
            return;
        }

        //si es producto variable, agrego el stock de todas sus variaciones
        $variations = $product->get_children();

        $style = is_array($variations) && count($variations) > 0 ? 'display:none' : 'display: block';
        $html = "<div id='producto_{$product_id}' style='$style'>" . get_post_meta($post_id, 'stock_por_sucursal_html', true) . '</div>';

        if( is_array($variations) )
        {
            $html .= '<div class="bsale_stock_variaciones"><p><strong>Variaciones</strong></p>';
            foreach( $variations as $variacion_id )
            {
                $sku = get_post_meta($variacion_id, '_sku', true);
                $product_variation = new WC_Product_Variation($variacion_id);

                if( $product_variation )
                {
                    // $variation_name = current($product_variation->get_variation_attributes());
                    $variation_attributes = $product_variation->get_variation_attributes();
                    $variation_name = '';
                    foreach( $variation_attributes as $key => $value )
                    {
                        $variation_name .= $value . ' ';
                    }
                    $stock = $product_variation->get_stock_quantity();
                    //$skuvar = $product_variation->get_sku();
                }
                else
                {
                    $variation_name = '';
                    $stock = '';
                }

                $html_variacion = get_post_meta($variacion_id, 'stock_por_sucursal_html', true);

                if( !empty($html_variacion) )
                {
                    $html .= "<div id='variacion_{$variacion_id}' class='bsale_variacion {$variation_name} sku_{$sku}' title='$stock'>" . $html_variacion . '</div>';
                }
            }
            $html .= '</div>';
        }

        if( function_exists('bsale_filter_sucursal_html') )
        {
            $html = bsale_filter_sucursal_html($html);
        }

        echo $html;
    }

    /**
     * coloca dentro del editor de pedido una sección con la información 
     * de facturación de Bsale
     * @param type $order
     * @return type
     */
    public static function order_meta_add_info($order)
    {
        $order_id = $order->get_id();

        $folio = get_post_meta($order_id, 'bsale_docto_folio', true);
        $bsale_docto_error = get_post_meta($order_id, 'bsale_docto_error', true);

        //url de dtes
        $bsale_docto_id_nv_url = get_post_meta($order_id, 'bsale_docto_id_nv_url', true);
        $bsale_docto_id_factura_url = get_post_meta($order_id, 'bsale_docto_id_factura_url', true);
        $bsale_docto_id_boleta_url = get_post_meta($order_id, 'bsale_docto_id_boleta_url', true);
        $bsale_docto_id_nc_url = get_post_meta($order_id, 'bsale_docto_id_nc_url', true);

        //folios de dtes
        $bsale_docto_folio_nv = get_post_meta($order_id, 'bsale_docto_folio_nv', true);
        $bsale_docto_folio_boleta = get_post_meta($order_id, 'bsale_docto_folio_boleta', true);
        $bsale_docto_folio_factura = get_post_meta($order_id, 'bsale_docto_folio_factura', true);
        $bsale_docto_folio_nc = get_post_meta($order_id, 'bsale_docto_folio_nc', true);

        $html = '<div class="dtes_bsale" style="padding-left: 20px !important;">';
        $empty = true;

        //datos de facturacion
        $billing_tipo_documento = get_post_meta($order_id, '_billing_tipo_documento', true);
        //$billing_tipo_documento = empty($billing_tipo_documento) ? get_post_meta($order_id, '_billing_tipo_documento', true) : $billing_tipo_documento;

        $billing_rut = get_post_meta($order_id, '_billing_rut', true);
        // $billing_rut = empty($billing_rut) ? get_post_meta($order_id, '_billing_rut', true) : $billing_rut;

        $billing_company = get_post_meta($order_id, '_billing_company', true);
        // $billing_company = empty($billing_company) ? get_post_meta($order_id, '_billing_company', true) : $billing_company;

        $billing_ruc = get_post_meta($order_id, '_billing_ruc', true);
        // $billing_ruc = empty($billing_ruc) ? get_post_meta($order_id, '_billing_ruc', true) : $billing_ruc;

        $billing_giro = get_post_meta($order_id, '_billing_giro', true);
        // $billing_giro = empty($billing_giro) ? get_post_meta($order_id, '_billing_giro', true) : $billing_giro;

        $billing_direccion_fiscal = get_post_meta($order_id, '_billing_direccion_fiscal', true);

        if( Funciones::get_pais() === 'CL' )
        {
            $html .= '<ul class="bsale_list_datos_fact">';
            $html .= '<li class="bsale_fact_field rut" style="font-size: 1.2em;"><strong>' . __('RUT comprador') . ': ' . $billing_rut . '</strong></li>';

            $html .= '<li class="bsale_fact_field selector">' . __('¿Boleta o Factura?') . ': <strong>' . $billing_tipo_documento . '</strong></li>';
            $html .= '<li class="bsale_fact_field empresa">' . __('Empresa') . ': <strong>' . $billing_company . '</strong></li>';
            $html .= '<li class="bsale_fact_field giro">' . __('Giro empresa') . ': <strong>' . $billing_giro . '</strong></li>';
            $html .= '</ul>';
        }
        elseif( Funciones::get_pais() === 'PE' )
        {
            $html .= '<ul class="bsale_list_datos_fact">';
            $html .= '<li class="bsale_fact_field selector">' . __('¿Boleta o Factura?') . ': <strong>' . $billing_tipo_documento . '</strong></li>';
            $html .= '<li class="bsale_fact_field rut">' . __('DNI/CE') . ': <strong>' . $billing_rut . '</strong></li>';
            $html .= '<li class="bsale_fact_field empresa">' . __('Empresa') . ': <strong> ' . $billing_company . '</strong></li>';
            $html .= '<li class="bsale_fact_field ruc">' . __('RUC') . ': <strong> ' . $billing_ruc . '</strong></li>';
            $html .= '<li class="bsale_fact_field giro">' . __('Giro empresa') . ': <strong> ' . $billing_giro . '</strong></li>';
            $html .= '<li class="bsale_fact_field df">' . __('Dirección fiscal') . ': <strong> ' . $billing_direccion_fiscal . '</strong></li>';
            $html .= '</ul>';
        }

        $html .= '<ul class="bsale_dtes_list">';
        if( !empty($bsale_docto_id_nc_url) )
        {
            $html .= "<li><a href='$bsale_docto_id_nc_url' target='_blank' title='Nota de cr&eacute;dito #$bsale_docto_folio_nc'>Nota de cr&eacute;dito #$bsale_docto_folio_nc</a></li>";
            $empty = false;
        }
        if( !empty($bsale_docto_id_factura_url) )
        {
            $html .= "<li><a href='$bsale_docto_id_factura_url' target='_blank' title='Factura #$bsale_docto_folio_factura'>Factura #$bsale_docto_folio_factura</a></li>";
            $empty = false;
        }
        if( !empty($bsale_docto_id_boleta_url) )
        {
            $html .= "<li><a href='$bsale_docto_id_boleta_url' target='_blank' title='Boleta #$bsale_docto_folio_boleta'>Boleta #$bsale_docto_folio_boleta</a></li>";
            $empty = false;
        }

        if( !empty($bsale_docto_id_nv_url) )
        {
            $html .= "<li><a href='$bsale_docto_id_nv_url' target='_blank' title='Nota de venta #$bsale_docto_folio_nv'>Nota de venta #$bsale_docto_folio_nv</a></li>";
            $empty = false;
        }


        //backwARD compatibility
        if( $empty )
        {
            $bsale_docto_url = get_post_meta($order_id, 'bsale_docto_url', true);
            $bsale_docto_tipo = get_post_meta($order_id, 'bsale_docto_tipo', true);
            $bsale_docto_folio = get_post_meta($order_id, 'bsale_docto_folio', true);

            if( !empty($bsale_docto_url) && !empty(($bsale_docto_tipo)) )
            {
                $html .= "<li><a href='$bsale_docto_url' target='_blank'>$bsale_docto_tipo #$bsale_docto_folio </a><li/>";
                $empty = false;
            }
        }
        $html .= '</ul>';

        if( !empty($bsale_docto_error) )
        {
            $html .= "<p><span class='bsale_det_error' style='color: #930202;'>Error: $bsale_docto_error</span><p/>";
            $empty = false;
        }

        $html .= '</div>';

        if( $empty )
        {
            return;
        }
        ?>
        <div class="bsale_wrapper" style="clear: both;display: block;padding: 0 0 20px 0;border-radius: 5px;border: 1px solid #ff5b00;display: block;margin-top: 40px;float: left;width: 100%;">           
            <h4 style="margin: 0;background-color: #ff5b00;line-height: 1.2em; color: #fff;padding: 5px 5px 5px 20px;">Facturaci&oacute;n Bsale</h4>

            <?php if( !$empty ): ?>
                <?php echo $html ?>
            <?php endif; ?>        
        </div>
        <?php
    }

    /**
     * agrega billing_rut al checkout
     */
    public static function add_campos_boleta($fields)
    {
        $fields['billing_rut'] = array(
            'label' => __('RUT', 'woocommerce'), // Add custom field label
            'placeholder' => _x('Ingrese RUT sin puntos', 'placeholder', 'woocommerce'), // Add custom field placeholder
            'required' => true, // if field is required or not
            'clear' => false, // add clear or not
            'type' => 'text', // add field type
            'class' => array( 'billing_rut_bsale' )    // add class name
        );

        return $fields;
    }

    /**
     * agrega campos factura al checkout
     * billing_rut 	text 	RUT obligatorio
      billing_tipo_documento 	select 	Documento obligatorio  boleta boleta/factura factura
      billing_company 	text 	Nombre de la empresa obligatorio
      billing_giro 	text 	Giro de la empresa 	obligatorio

     */
    public static function add_campos_factura($fields)
    {
        if( Funciones::get_pais() === 'CL' )
        {
            $fields['billing_tipo_documento'] = array(
                'label' => __('¿Boleta o factura?', 'woocommerce'), // Add custom field label
                'placeholder' => _x('¿Boleta o factura?', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'select', // add field type
                'class' => array( 'billing_tipo_documento_bsale' ),
                'options' => array(
                    '' => __('-seleccione-', 'woocommerce'),
                    'boleta' => __('Boleta', 'woocommerce'),
                    'factura' => __('Factura', 'woocommerce'),
                ),
            );

            $fields['billing_rut'] = array(
                'label' => __('RUT', 'woocommerce'), // Add custom field label
                'placeholder' => _x('Ingrese RUT sin puntos', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'text', // add field type
                'class' => array( 'billing_rut_bsale' )    // add class name
            );

            $fields['billing_company'] = array(
                'label' => __('Empresa', 'woocommerce'), // Add custom field label
                'placeholder' => _x('Nombre de la empresa', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'text', // add field type
                'class' => array( 'billing_company_bsale' )    // add class name
            );

            $fields['billing_giro'] = array(
                'label' => __('Giro de la empresa', 'woocommerce'), // Add custom field label
                'placeholder' => _x('Giro de la empresa', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'text', // add field type
                'class' => array( 'billing_giro_bsale' )    // add class name
            );
        }
        elseif( Funciones::get_pais() === 'PE' )
        {
            $fields['billing_tipo_documento'] = array(
                'label' => __('¿Boleta o factura?', 'woocommerce'), // Add custom field label
                'placeholder' => _x('¿Boleta o factura?', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'select', // add field type
                'class' => array( 'billing_tipo_documento_bsale' ),
                'options' => array(
                    '' => __('-seleccione-', 'woocommerce'),
                    'boleta' => __('Boleta', 'woocommerce'),
                    'factura' => __('Factura', 'woocommerce'),
                ),
            );

            $fields['billing_rut'] = array(
                'label' => __('DNI/CE', 'woocommerce'), // Add custom field label
                'placeholder' => _x('DNI/CE, ingrese solo cifras', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'text', // add field type
                'class' => array( 'billing_rut_bsale' )    // add class name
            );

            $fields['billing_ruc'] = array(
                'label' => __('RUC', 'woocommerce'), // Add custom field label
                'placeholder' => _x('Ingrese RUC', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'text', // add field type
                'class' => array( 'billing_rut_bsale' )    // add class name
            );

            $fields['billing_company'] = array(
                'label' => __('Razón social', 'woocommerce'), // Add custom field label
                'placeholder' => _x('Razón social', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'text', // add field type
                'class' => array( 'billing_company_bsale' )    // add class name
            );

            $fields['billing_giro'] = array(
                'label' => __('Giro de la empresa', 'woocommerce'), // Add custom field label
                'placeholder' => _x('Giro de la empresa', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'text', // add field type
                'class' => array( 'billing_giro_bsale' )    // add class name
            );
            $fields['billing_direccion_fiscal'] = array(
                'label' => __('Dirección fiscal de la empresa', 'woocommerce'), // Add custom field label
                'placeholder' => _x('Dirección fiscal de la empresa', 'placeholder', 'woocommerce'), // Add custom field placeholder
                'required' => true, // if field is required or not
                'clear' => false, // add clear or not
                'type' => 'text', // add field type
                'class' => array( 'billing_direccion_fiscal' )    // add class name
            );
        }


        return $fields;
    }

    public static function bsale_add_factura_number_column($columns)
    {

// put the column after the Status column
        $new_columns = array_slice($columns, 0, 2, true) +
                array( 'factura_columna' => 'Docto Bsale' ) +
                array_slice($columns, 2, count($columns) - 1, true);
        return $new_columns;
    }

    /**
     * valida campos checkout
     */
    public static function validate_checkout_fields($fields, $errors)
    {
        global $woocommerce;

        $billing_tipo_documento = 'boleta'; //default, boleta
        $billing_giro = null;

        // Check if set, if its not set add an error. This one is only requite for companies
        if( isset($fields['billing_rut']) && !empty($fields['billing_rut']) && Funciones::get_pais() === 'CL' )
        {
            // $rut = sanitize_text_field($fields['billing_rut']);
            $rut = $fields['billing_rut'];
            $utils = new Utils();
            $res = $utils->valida_rut($rut);

            if( !$res )
            {
                $errors->add('validation', "El rut '$rut' no es correcto. Ingrese el rut nuevamente.");
            }
        }

        if( isset($fields['billing_tipo_documento']) )
        {
            $billing_tipo_documento = sanitize_text_field($_POST['billing_tipo_documento']);
        }

        if( isset($fields['billing_giro']) )
        {
            $billing_giro = sanitize_text_field($_POST['billing_giro']);
        }

        if( $billing_tipo_documento === 'factura' && empty($billing_giro) )
        {
            $errors->add('validation', "Debe ingresar el giro de la empresa.");
        }
    }

    public static function save_campos_checkout_in_order($order_id)
    {
        $fields = $_POST;

        if( isset($fields['billing_rut']) )
        {
            $rut = sanitize_text_field($_POST['billing_rut']);
            update_post_meta($order_id, 'billing_rut', $rut);
            update_post_meta($order_id, '_billing_rut', $rut);
        }

        if( isset($fields['billing_tipo_documento']) )
        {
            $billing_tipo_documento = sanitize_text_field($_POST['billing_tipo_documento']);
            update_post_meta($order_id, 'billing_tipo_documento', $billing_tipo_documento);
            update_post_meta($order_id, '_billing_tipo_documento', $billing_tipo_documento);
        }

        if( isset($fields['billing_giro']) )
        {
            $billing_giro = sanitize_text_field($_POST['billing_giro']);
            update_post_meta($order_id, 'billing_giro', $billing_giro);
            update_post_meta($order_id, '_billing_giro', $billing_giro);
        }
        if( isset($fields['billing_direccion_fiscal']) )
        {
            $billing_giro = sanitize_text_field($_POST['billing_direccion_fiscal']);
            update_post_meta($order_id, 'billing_direccion_fiscal', $billing_giro);
            update_post_meta($order_id, '_billing_direccion_fiscal', $billing_giro);
        }
    }

    public static function display_campos_checkout_in_order($order)
    {
        return;
        $order_id = $order->get_id();

        $billing_tipo_documento = get_post_meta($order_id, '_billing_tipo_documento', true);
        //$billing_tipo_documento = empty($billing_tipo_documento) ? get_post_meta($order_id, '_billing_tipo_documento', true) : $billing_tipo_documento;

        $billing_rut = get_post_meta($order_id, '_billing_rut', true);
        // $billing_rut = empty($billing_rut) ? get_post_meta($order_id, '_billing_rut', true) : $billing_rut;

        $billing_company = get_post_meta($order_id, '_billing_company', true);
        // $billing_company = empty($billing_company) ? get_post_meta($order_id, '_billing_company', true) : $billing_company;

        $billing_ruc = get_post_meta($order_id, '_billing_ruc', true);
        // $billing_ruc = empty($billing_ruc) ? get_post_meta($order_id, '_billing_ruc', true) : $billing_ruc;

        $billing_giro = get_post_meta($order_id, '_billing_giro', true);
        // $billing_giro = empty($billing_giro) ? get_post_meta($order_id, '_billing_giro', true) : $billing_giro;

        $billing_direccion_fiscal = get_post_meta($order_id, '_billing_direccion_fiscal', true);

        if( Funciones::get_pais() === 'CL' )
        {
            echo '<div class="bsale_fact_section"><p class="bsale_fact_field selector"><strong>' . __('¿Boleta o Factura?') . ':</strong> ' . $billing_tipo_documento . '</p>';
            echo '<p class="bsale_fact_field rut"><strong>' . __('RUT comprador') . ':</strong> ' . $billing_rut . '</p>';
            echo '<p class="bsale_fact_field empresa"><strong>' . __('Empresa') . ':</strong> ' . $billing_company . '</p>';
            echo '<p class="bsale_fact_field giro"><strong>' . __('Giro empresa') . ':</strong> ' . $billing_giro . '</p></div>';
        }
        elseif( Funciones::get_pais() === 'PE' )
        {
            echo '<div class="bsale_fact_section"><p class="bsale_fact_field selector"><strong>' . __('¿Boleta o Factura?') . ':</strong> ' . $billing_tipo_documento . '</p>';
            echo '<p class="bsale_fact_field rut"><strong>' . __('DNI/CE') . ':</strong> ' . $billing_rut . '</p>';
            echo '<p class="bsale_fact_field empresa"><strong>' . __('Empresa') . ':</strong> ' . $billing_company . '</p>';
            echo '<p class="bsale_fact_field ruc"><strong>' . __('RUC') . ':</strong> ' . $billing_ruc . '</p>';
            echo '<p class="bsale_fact_field giro"><strong>' . __('Giro empresa') . ':</strong> ' . $billing_giro . '</p>';
            echo '<p class="bsale_fact_field df"><strong>' . __('Dirección fiscal') . ':</strong> ' . $billing_direccion_fiscal . '</p></div>';
        }
    }

    //* Add selection field value to emails
    public static function display_campos_checkout_in_email($keys)
    {

        $keys['¿Boleta o Factura?:'] = 'billing_tipo_documento';
        $keys['RUT cliente:'] = 'billing_rut';
        $keys['Empresa:'] = 'billing_company';
        $keys['Giro empresa:'] = 'billing_giro';


        /* if( Funciones::get_send_email() > 0 )
          {

          } */

        //agrego boleta o factura si es que existe
        $keys['Boleta:'] = 'bsale_docto_id_boleta_url';
        $keys['Factura:'] = 'bsale_docto_id_factura_url';

        return $keys;
    }

    public static function bsale_add_factura_number_column_data($column)
    {
        global $post, $the_order, $wpo_wcpdf;

        if( $column == 'factura_columna' )
        {
            if( empty($the_order) || $the_order->get_id() != $post->ID )
            {
                /* $order_id = $post->ID;
                  $folio = get_post_meta( $order_id, 'bsale_docto_folio' );
                  $url = get_post_meta( $order_id, 'bsale_docto_url' );
                  $order = new WC_Order( $post->ID );
                  echo '<a href="$url" target="_blank">#' . $order_id . $folio . '</a>'; */
                do_action('wcpdf_invoice_number_column_end', $post);
            }
            else
            {

//id de la orden
                $order_id = $post->ID;

                //si se han borrado los datos de bsale
                $deleted_data = false;

//hay que borrar factura? solo si el id a borrar es el de esta columna
                if( !isset($_GET['bulk_action']) && //no se esta cambiado los pedidos en bulk
                        !isset($_GET['ids']) && //no se esta cambiado los pedidos en bulk   
                        isset($_GET['borrar_factura']) &&
                        ((int) $_GET['borrar_factura']) == $order_id && wp_verify_nonce($_GET['nonce'], 'borrar_factura') )
                {
                    $order_id_ref = (int) $_REQUEST['borrar_factura'];

                    //este doc ha sido borrado justo antes de ahora?
                    $bsale_docto_deleted = get_post_meta($order_id, 'bsale_docto_deleted', true);

                    //si no ha sido borrado justo ahora
                    if( empty($bsale_docto_deleted) )
                    {
                        delete_post_meta($order_id_ref, 'bsale_docto_folio');
                        delete_post_meta($order_id_ref, 'bsale_docto_url');
                        delete_post_meta($order_id_ref, 'bsale_docto_tipo');

                        //url
                        delete_post_meta($order_id_ref, 'bsale_docto_id_nv_url');
                        delete_post_meta($order_id_ref, 'bsale_docto_id_factura_url');
                        delete_post_meta($order_id_ref, 'bsale_docto_id_boleta_url');
                        delete_post_meta($order_id_ref, 'bsale_docto_id_nc_url');

                        //ids
                        delete_post_meta($order_id_ref, "bsale_docto_id_nv");
                        delete_post_meta($order_id_ref, "bsale_docto_id_boleta");
                        delete_post_meta($order_id_ref, "bsale_docto_id_factura");
                        delete_post_meta($order_id_ref, "bsale_docto_id_gd");
                        delete_post_meta($order_id_ref, "bsale_docto_id_nc");
                        delete_post_meta($order_id_ref, "bsale_docto_id_nd");

                        //folio
                        delete_post_meta($order_id_ref, "bsale_docto_folio_nv");
                        delete_post_meta($order_id_ref, "bsale_docto_folio_boleta");
                        delete_post_meta($order_id_ref, "bsale_docto_folio_factura");
                        delete_post_meta($order_id_ref, "bsale_docto_folio_nc");

                        echo("<p>Se ha borrado el registro de DTEs para este pedido."
                        . "Puede emitirlos de nuevo, cambiando el pedido de estado."
                        . "(Los DTES emitidos no han sido anulados. Para ello, debe emitir notas de crédito o lo que corresponda)</p>");

                        unset($_REQUEST['borrar_factura']);

                        //si se borraron datos
                        $deleted_data = true;

                        update_post_meta($order_id_ref, 'bsale_docto_deleted', 1);

                        do_action('wcpdf_invoice_number_column_end', $post);
                        return;
                    }
                }

                //borro marca de doc borrado, en caso de que aya alguna bsale_docto_deleted
                delete_post_meta($order_id, "bsale_docto_deleted");

                $billing_rut = get_post_meta($order_id, '_billing_rut', true);
                $billing_tipo_documento = get_post_meta($order_id, '_billing_tipo_documento', true);

                $folio = get_post_meta($order_id, 'bsale_docto_folio', true);
                $bsale_docto_error = get_post_meta($order_id, 'bsale_docto_error', true);

                //url de dtes
                $bsale_docto_id_nv_url = get_post_meta($order_id, 'bsale_docto_id_nv_url', true);
                $bsale_docto_id_factura_url = get_post_meta($order_id, 'bsale_docto_id_factura_url', true);
                $bsale_docto_id_boleta_url = get_post_meta($order_id, 'bsale_docto_id_boleta_url', true);
                $bsale_docto_id_nc_url = get_post_meta($order_id, 'bsale_docto_id_nc_url', true);

                //folios de dtes
                $bsale_docto_folio_nv = get_post_meta($order_id, 'bsale_docto_folio_nv', true);
                $bsale_docto_folio_boleta = get_post_meta($order_id, 'bsale_docto_folio_boleta', true);
                $bsale_docto_folio_factura = get_post_meta($order_id, 'bsale_docto_folio_factura', true);
                $bsale_docto_folio_nc = get_post_meta($order_id, 'bsale_docto_folio_nc', true);

                $html = '<p class="dtes_bsale" style="color:#50575e">';
                $empty = true;

                if( !empty($billing_rut) )
                {
                    $html .= "<span>RUT $billing_rut ($billing_tipo_documento)</span><br/><br/>";
                    $empty = false;
                }

                $html_code = '&#10070;';

                if( !empty($bsale_docto_id_nc_url) )
                {
                    $html .= "<a href='$bsale_docto_id_nc_url' target='_blank' style='color:red;'><span class='t_d'>$html_code Nota de cr&eacute;dito</span> <span class='t_f'>#$bsale_docto_folio_nc</span></a><br/>";
                    $empty = false;
                }
                if( !empty($bsale_docto_id_factura_url) )
                {
                    $html .= "<a href='$bsale_docto_id_factura_url' target='_blank'><span class='t_d'>$html_code Factura</span> <span class='t_f'>#$bsale_docto_folio_factura</span></a><br/>";
                    $empty = false;
                }
                if( !empty($bsale_docto_id_boleta_url) )
                {
                    $html .= "<a href='$bsale_docto_id_boleta_url' target='_blank'><span class='t_d'>$html_code Boleta</span> <span class='t_f'>#$bsale_docto_folio_boleta</span></a><br/>";
                    $empty = false;
                }

                if( !empty($bsale_docto_id_nv_url) )
                {
                    $html .= "<a href='$bsale_docto_id_nv_url' target='_blank'><span class='t_d'>$html_code Nota de venta</span> <span class='t_f'>#$bsale_docto_folio_nv</span></a><br/>";
                    $empty = false;
                }

                if( !$empty )
                {
                    //borrar docs
                    $page = $_SERVER['PHP_SELF'];
                    $params = isset($_REQUEST['post_type']) ? 'post_type=' . $_REQUEST['post_type'] : 'post_type=shop_order';
                    $page = "$page?$params&borrar_factura=$order_id";
                    $question = '¿Deseas borrar los links a los dtes de este pedido?\n'
                            . 'Si los borras, podrás volver a emitirlos cambiando el pedido de estado.\n'
                            . 'Pero deberás anular en Bsale los DTS borrados.\n'
                            . 'Si lo que deseas es anularlos, debes cambiar el pedido a estado CANCELADO.';

                    $page = wp_nonce_url($page, 'borrar_factura', 'nonce');

                    // $html .= "<a title='$question' href='{$page}' onclick='return confirm(\"" . $question . "\") && confirm(\"¿Está seguro?\");' style='display:none; color: #ae0000; font-size: 11px;'>borrar links a docs</a>";
                }

                //backwARD compatibility
                if( $empty )
                {
                    $bsale_docto_url = get_post_meta($order_id, 'bsale_docto_url', true);
                    $bsale_docto_tipo = get_post_meta($order_id, 'bsale_docto_tipo', true);
                    $bsale_docto_folio = get_post_meta($order_id, 'bsale_docto_folio', true);

                    if( !empty($bsale_docto_url) && !empty(($bsale_docto_tipo)) )
                    {
                        $html .= "<a href='$bsale_docto_url' target='_blank'>$html_code $bsale_docto_tipo #$bsale_docto_folio </a><br/>";
                        $empty = false;
                    }
                }

                $html .= '</p>';

                if( !$empty )
                {
                    echo($html);
                }


                /* //si hay factura en este pedido
                  if( !empty($folio) )
                  {
                  $url = get_post_meta($order_id, 'bsale_docto_url', true);
                  $tipo_docto = get_post_meta($order_id, 'bsale_docto_tipo', true);
                  $order = new WC_Order($post->ID);

                  //para determimnar la pagina actual
                  $page = $_SERVER['PHP_SELF'];
                  $params = isset($_REQUEST['post_type']) ? 'post_type=' . $_REQUEST['post_type'] : 'post_type=shop_order';

                  $page = "$page?$params&borrar_factura=$order_id";

                  //muestro cada docto asociado a esta orden
                  $url = trim($url);
                  $url_arr = explode(' ', $url);

                  $i = 0;
                  foreach( $url_arr as $u )
                  {
                  $desc = ($i == 0) ? "$tipo_docto #$folio" : 'DTE';
                  echo "<p><a href='$u' target='_blank'>$desc </a></p>";
                  $i++;
                  }

                  echo "<p><a href='{$page}' style='color: red;'>borrar docs</a></p>";
                  } */
                if( !empty($bsale_docto_error) )
                {
                    echo("<p class='bsale_det_error' style='color: #930202;'>$bsale_docto_error</p>");
                }


                do_action('wcpdf_invoice_number_column_end', $the_order);
            }
        }
    }

    public static function bsale_product_column($columns)
    {

// put the column after the Status column
        $new_columns = array_slice($columns, 0, 2, true) +
                array( 'bsale_column' => 'Bsale' ) +
                array_slice($columns, 2, count($columns) - 1, true);
        return $new_columns;
    }

    public static function bsale_product_column_data($column, $post_ID)
    {

        if( $column === 'name' )
        {
            if( empty($post_ID) )
            {
                
            }
            else
            {
                $post_id = $post_ID;

                $bsale_info = get_post_meta($post_id, 'bsale_info', true);
                $bsale_info_variacion = get_post_meta($post_id, 'bsale_info_variacion', true);

                if( !empty($bsale_info) )
                {
                    echo "<p><span class='bsale_info' style='color: #dc3232'>$bsale_info</span></p>";
                }
                if( !empty($bsale_info_variacion) )
                {
                    echo "<p><span class='bsale_info' style='color: #dc3232'>$bsale_info_variacion</span></p>";
                }
            }
        }
    }

    public static function bsale_add_factura_number_column_quote($columns)
    {

// put the column after the Status column
        $new_columns = array_slice($columns, 0, 2, true) +
                array( 'nv_columna' => 'NV' ) +
                array_slice($columns, 2, count($columns) - 1, true);
        return $new_columns;
    }

    public static function bsale_add_factura_number_column_data_quote($column, $post_ID)
    {
        global $post, $wpo_wcpdf;

        if( $column === 'nv_columna' )
        {
            if( empty($post) || $post_ID != $post->ID )
            {
                do_action('wcpdf_invoice_number_column_end', $post);
            }
            else
            {

//id de la orden
                $order_id = $post_ID;


//hay que borrar factura? solo si el id a borrar es el de esta columna
                if( isset($_REQUEST['borrar_factura_quote']) &&
                        ((int) $_REQUEST['borrar_factura_quote']) == $order_id )
                {
                    $order_id_ref = (int) $_REQUEST['borrar_factura_quote'];

                    delete_post_meta($order_id_ref, 'bsale_docto_folio_quote');
                    delete_post_meta($order_id_ref, 'bsale_docto_url_quote');
                    delete_post_meta($order_id_ref, 'bsale_docto_tipo_quote');
                    delete_post_meta($order_id_ref, "bsale_docto_id_nv_quote");

                    echo("<p>Se ha borrado el registro de DTEs para esta cotizacion."
                    . "(Los DTES emitidos no han sido anulados. Para ello, debe emitir notas de crédito o lo que corresponda)</p>");

                    unset($_REQUEST['borrar_factura_quote']);
                    do_action('wcpdf_invoice_number_column_end', $post);
                    return;
                }

                $folio = get_post_meta($order_id, 'bsale_docto_folio_quote', true);
                $bsale_docto_error = get_post_meta($order_id, 'bsale_docto_error_quote', true);

//si hay factura en este pedido
                if( !empty($folio) )
                {
                    $url = get_post_meta($order_id, 'bsale_docto_url_quote', true);
                    $tipo_docto = get_post_meta($order_id, 'bsale_docto_tipo_quote', true);

//para determimnar la pagina actual
                    $page = $_SERVER['PHP_SELF'];
                    $params = isset($_REQUEST['post_type']) ? 'post_type=' . $_REQUEST['post_type'] : 'post_type=addify_quote';

                    $page = "$page?$params&borrar_factura_quote=$order_id";

//muestro cada docto asociado a esta orden
                    $url = trim($url);
                    $url_arr = explode(' ', $url);

                    $i = 0;
                    foreach( $url_arr as $u )
                    {
                        $desc = ($i == 0) ? "$tipo_docto #$folio" : 'DTE';
                        echo "<p><a href='$u' target='_blank'>$desc </a></p>";
                        $i++;
                    }

                    echo "<p><a href='{$page}' style='color: red;'>borrar docs</a></p>";
                }
                if( !empty($bsale_docto_error) )
                {
                    echo("<p>$bsale_docto_error</p>");
                }


                do_action('wcpdf_invoice_number_column_end', $the_order);
            }
        }
    }

    /**
     * muestra los puntos de Bsale en el dashboard del comprador
     */
    public static function display_customer_points()
    {
        $user_id = get_current_user_id();

        if( $user_id <= 0 )
        {
            return;
        }
        $user_logged = get_userdata($user_id);

        if( empty($user_logged) )
        {
            return;
        }

        $user_email = $user_logged->user_email;

        if( empty($user_email) )
        {
            return;
        }

        //puntos
        $puntos = (int) get_user_meta($user_id, 'bsale_puntos_customer', true);
        //fecha ultima vez que se preguntó por los puntos
        $puntos_fecha = get_user_meta($user_id, 'bsale_puntos_customer_last_date', true);
        //0 ó 1 
        $puntos_acumula = get_user_meta($user_id, 'bsale_puntos_customer_acumula', true);

        $strinfo = '';

        //tiempo transcurrido desde ultima consulta a Bsale por puntos
        if( $puntos_fecha > 0 )
        {
            $delta_time = time() - $puntos_fecha;
            $hours = floor($delta_time / 3600);
            $delta_time %= 3600;
            $minutes = floor($delta_time / 60);

            $strinfo .= "pf($puntos_fecha) >0, dt($delta_time) = " . time() . " - " . $puntos_fecha . " min=$minutes";
        }
        else
        {
            $intervalo = 0;
            $minutes = 0;
        }

        //si no tiene puntos o nunca he preguntado por ellos
        //pregunta aBsale cada 10 minutos
        if( $puntos <= 0 || $minutes > 10 )
        {
            $cliente = new Cliente();
            $cliente_bsale = $cliente->getCliente_by_email($user_email);

            //cliente no existe en Bsale
            /* if(!is_array($cliente_bsale) || count($cliente_bsale)<=0)
              {
              return;
              } */

            $puntos_acumula = isset($cliente_bsale['accumulatePoints']) ? $cliente_bsale['accumulatePoints'] : 0;

            $puntos = isset($cliente_bsale['points']) ? $cliente_bsale['points'] : 0;

            //actualizo datos meta
            update_user_meta($user_id, 'bsale_puntos_customer', $puntos);
            update_user_meta($user_id, 'bsale_puntos_customer_last_date', time());
            update_user_meta($user_id, 'bsale_puntos_customer_acumula', $puntos_acumula);

            //si no acumula puntos, no hago nada
            if( $puntos_acumula <= 0 )
            {
                return;
            }

            //$strinfo contiene infor para debug
        }
        ?>
        <div id="puntos_bsale" class="woocommerce-info" style="float: left; width: calc( 100% - 300px);">
            <p style="text-transform: uppercase;"><strong>Puntos acumulados: <span class="puntos_bsale_span"><?php echo $puntos; ?></span></strong></p>
        </div>

        <?php
    }

    /**
     * link a sync stock directamente
     * @global type $post
     * @return type
     */
    public static function post_edit_bsale_block()
    {
        $screen = get_current_screen();
        if( /* $screen->post_type !== 'product' || */ $screen->id !== 'product' )
        {
            return;
        }

        global $post;

        if( empty($post) || !isset($post->ID) )
        {
            return;
        }

        $post_id = $post->ID;

        global $woo_bsale_db_url;

        $url = defined('BSALE_USE_REST_API') && BSALE_USE_REST_API == true ?
                get_rest_url(null, "wcbsalev2/v1/syncprod/1?param=yes&pid=$post_id&bsale_silent=1") :
                $woo_bsale_db_url . "sync/product_sync_bsale.php?param=yes&pid=$post_id&bsale_silent=1";

        $loading_url = $woo_bsale_db_url . 'img/loading2.gif';
        ?>
        <div class="misc-pub-section my-options-bsale">
            <h2><strong>Integración Bsale</strong></h2>
            <p><a class="button sync_bsale_btn" href="<?php echo $url; ?>" data-pid="<?php echo $post_id; ?>" target="_blank" 
                  title="Sincronizar stock/precio desde Bsale para este producto y sus variaciones. Se extraerán los datos del producto de Bsale con el mismo SKU."
                  style="background-color: #ff5c1a; color: #fff; padding: 5px 15px;font-weight: bold;">SINCRONIZAR CON BSALE</a> </p>
            <p id="spinner_sync_bsale" style="display: none;" ><img id="spinner_img_bsale" style="height: 40px;" src="<?php echo $loading_url; ?>" /><br/>
                <span style="color:red">No cierre la página. Al terminar la sincronización, se recargará por sí sola.</span></p>  
            <p id="bsale_sync_result"></p>
            <p id="result_sync" style="display: none !important"></p>
        </div>
        <?php
    }

    public static function get_bsale_last_error_notice()
    {
        //no muestra avisos si esta constante está definida
        if( defined('DISABLE_NAG_NOTICES') && DISABLE_NAG_NOTICES == true )
        {
            return;
        }
        
        $bsale_option_errors = get_option('bsale_option_errors');
        $bsale_option_errors_arr = !empty($bsale_option_errors) ? json_decode($bsale_option_errors, true) : null;

        $code = isset($arr['code']) ? $arr['code'] : -1;

        if( !is_array($bsale_option_errors_arr) || count($bsale_option_errors_arr) <= 0 )
        {
            return;
        }
        $url = get_site_url() . '/wp-admin/tools.php?page=woo_bsale-admin-menu&bsale_tab=bsale_config';
        ?>
        <div class="notice notice-error is-dismissible" style="background-color: #ffe6dd;">
            <p > 
                <strong>ERROR INTEGRACIÓN WOOCOMMERCE BSALE</strong><br/><br/>
                <span class="help_bsale">
                    <span class="error_bsale"><?php echo $bsale_option_errors_arr['msg']; ?></span><br/>
                    Último intento de conectarse: <?php echo $bsale_option_errors_arr['url']; ?><br/>
                    Código http de respuesta:  <strong><?php echo $bsale_option_errors_arr['code']; ?></strong> 
                    <a href="https://es.wikipedia.org/wiki/Anexo:C%C3%B3digos_de_estado_HTTP" target="_blank">(¿qué significa?)</a><br/><br/>
                    <strong><a href=" <?php echo $url; ?>" target="_blank">Ir a Integración con Bsale</a></strong><br/>


                </span>
            </p>
        </div>
        <?php
    }

}

/**
 * recibe listaod de pickup stores y solo devuelve aquellas en que hay stock en Bsale
 * @param type $get_stores
 */
function bsale_filter_pickup_stores($get_stores)
{
//debug: si es mi email, muesro todas las tiendas
    $current_user = wp_get_current_user();
    $user_mail = $current_user->user_email;

    if( $user_mail === 'xxxx' || $user_mail === 'xxx' )
    {
//continua el debug
        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html($get_stores, "user $user_mail, muestra todas las tiendas");
        }
        return $get_stores;
    }

    if( isset($_REQUEST['param']) )
    {
        Funciones::print_r_html($get_stores, "bsale_filter_pickup_stores, params:");
    }
    else
    {
//return $get_stores;
    }
    $utils = new Utils();
//arreglo: titulo medio envio wc=>id sucursal bsale
    $shipings_arr = $utils->get_array_medios_envio();

//listado de prods del carro
    global $woocommerce;
    $cart = $woocommerce->cart->get_cart();

//arreglo con productos del carro: sku=>cantidad
    $prods_arr = array();

// Loop over $cart items
    foreach( $cart as $cart_item_key => $cart_item )
    {
        $product = $cart_item['data'];
        $product_id = $cart_item['product_id'];
        $quantity = $cart_item['quantity'];
        $sku = $cart_item['data']->get_sku();

//si ya está este sku, sumo la cantidad. Else, la agrego
        if( isset($prods_arr[$sku]) )
        {
            $prods_arr[$sku] += $quantity;
        }
        else
        {
            $prods_arr[$sku] = $quantity;
        }
    }

    if( count($prods_arr) <= 0 )
    {
        return $get_stores;
    }

    if( isset($_REQUEST['test_dte']) )
    {
        Funciones::print_r_html($prods_arr, "bsale_filter_pickup_stores, prodcuto del carro y cantidad a comprar: ");
    }

//busco prods con stock en las sucursales de Bsale:
//las sucursales e Bsale tienen stock para todos los productos del carro?
    $wpbsale = new WpBsale();
    $shipings_to_display_arr = $wpbsale->get_shipping_sucursal_stock($shipings_arr, $prods_arr);

    if( isset($_REQUEST['param']) )
    {
        Funciones::print_r_html($shipings_to_display_arr, "bsale_filter_pickup_stores, shipping asociado a suc bsale:");
    }



    $arr = array();
// $arr = $get_stores;
//  $arr[999] = 'test store';

    foreach( $get_stores as $post_id => $store )
    {
        $label = $utils->filter_chars($store);
        $label = strtolower($label);
        $display = true;

        if( isset($shipings_to_display_arr[$label]) )
        {
            $display = $shipings_to_display_arr[$label];

            if( isset($_REQUEST['param']) )
            {
                $displaystr = ($display) ? 'SÍ' : 'NO';
                Funciones::print_r_html("bsale_filter_pickup_stores name = '$label' se muestra en checkout: $displaystr");
            }
        }
//se debe mostrar este shipping method en el checkout?
        if( $display !== false )
        {
            $arr[$post_id] = $store;
        }
    }

    if( isset($_REQUEST['param']) )
    {
        Funciones::print_r_html($arr, "bsale_filter_pickup_stores, medios de envio que se muestran");
    }

    return $arr;
}

function bsale_stock_sucursales_product_html_back($post)
{
    $post_id = $post->ID;

    /* $html = get_post_meta($post_id, 'stock_por_sucursal_html', true);

      if( function_exists('bsale_filter_sucursal_html') )
      {
      $html = bsale_filter_sucursal_html($html);
      }
      echo($html); */

//    global $post;
//    $post_id = $post->ID;
    $product_id = $post_id;

    $product = wc_get_product($product_id);

//es prod válido?
    if( !$product )
    {
        return;
    }

    $html = "<div id='producto_{$product_id}'>" . get_post_meta($post_id, 'stock_por_sucursal_html', true) . '</div>';

//si es producto variable, agrego el stock de todas sus variaciones
    $variations = $product->get_children();

    if( is_array($variations) && count($variations) > 0 )
    {
        $html .= '<div class="bsale_stock_variaciones"><p><strong>Variaciones</strong></p>';
        foreach( $variations as $variacion_id )
        {
            $sku = get_post_meta($variacion_id, '_sku', true);
            $product_variation = new WC_Product_Variation($variacion_id);

            if( $product_variation )
            {
                $variation_name = current($product_variation->get_variation_attributes());
                //$skuvar = $product_variation->get_sku();
            }
            else
            {
                $variation_name = '';
            }

            $html_variacion = get_post_meta($variacion_id, 'stock_por_sucursal_html', true);

            if( !empty($html_variacion) )
            {
                $html .= "<div id='variacion_{$variacion_id}' class='{$variation_name} sku_{$sku}'>" .
                        "<p><strong>Variacion '$variation_name' sku='$sku'</strong></p>" .
                        $html_variacion . '</div>';
            }
        }
        $html .= '</div>';
    }

    echo $html;
}

function bsale_edit_fact_custom_box_html($post)
{
    die('edit_fact_custom_box_html');
    //datos de fact de este pedido
    $order_id = $post->ID;

    if( empty($order_id) )
    {
        return;
    }

    $is_add_campos_checkout_boleta = Funciones::is_add_campos_checkout_boleta();
    $is_add_campos_checkout_factura = Funciones::is_add_campos_checkout_factura();

    //datos meta de facturacion
    $billing_tipo_documento = get_post_meta($order_id, 'billing_tipo_documento', true);
    $billing_tipo_documento = empty($billing_tipo_documento) ? get_post_meta($order_id, '_billing_tipo_documento', true) : $billing_tipo_documento;

    $billing_rut = get_post_meta($order_id, 'billing_rut', true);
    $billing_rut = empty($billing_rut) ? get_post_meta($order_id, '_billing_rut', true) : $billing_rut;

    $billing_company = get_post_meta($order_id, 'billing_company', true);
    $billing_company = empty($billing_company) ? get_post_meta($order_id, '_billing_company', true) : $billing_company;

    //peru
    $billing_ruc = get_post_meta($order_id, 'billing_ruc', true);
    $billing_ruc = empty($billing_ruc) ? get_post_meta($order_id, '_billing_ruc', true) : $billing_ruc;

    $billing_giro = get_post_meta($order_id, 'billing_giro', true);
    $billing_giro = empty($billing_giro) ? get_post_meta($order_id, '_billing_giro', true) : $billing_giro;


    if( Funciones::get_pais() === 'CL' )
    {
        if( $is_add_campos_checkout_factura )
        {
            ?>
            <p>
                <label for="billing_tipo_documento">'¿Boleta o factura?</label>
                <select name="billing_tipo_documento" id="billing_tipo_documento" class="postbox">
                    <option value="">--seleccione--</option>
                    <option value="something" <?php selected($billing_tipo_documento, 'boleta'); ?>>Boleta</option>
                    <option value="else" <?php selected($billing_tipo_documento, 'factura'); ?>>Factura</option>
                </select>
            </p>
            <p>
                <label for="billing_rut">Rut para boleta/factura</label>
                <input type="text" name="billing_rut" id="billing_rut" class="postbox" value="<?php echo $billing_rut; ?>" />
            </p>
            <p>
                <label for="billing_company">Nombre de la empresa</label>
                <input type="text" name="billing_company" id="billing_company" class="postbox" value="<?php echo $billing_company; ?>" />
            </p>
            <p>
                <label for="billing_giro">Giro de la empresa</label>
                <input type="text" name="billing_giro" id="billing_giro" class="postbox" value="<?php echo $billing_giro; ?>" />
            </p>
            <?php
        }
        elseif( $is_add_campos_checkout_boleta )
        {
            ?>
            <p>
                <label for="billing_rut">Rut para boleta/factura</label>
                <input type="text" name="billing_rut" id="billing_rut" class="postbox" value="<?php echo $billing_rut; ?>" />
            </p>
            <?php
        }
    }
    elseif( Funciones::get_pais() === 'PE' )
    {
        if( $is_add_campos_checkout_factura )
        {
            ?>
            <p>
                <label for="billing_tipo_documento">'¿Boleta o factura?</label>
                <select name="billing_tipo_documento" id="billing_tipo_documento" class="postbox">
                    <option value="">--seleccione--</option>
                    <option value="something" <?php selected($billing_tipo_documento, 'boleta'); ?>>Boleta</option>
                    <option value="else" <?php selected($billing_tipo_documento, 'factura'); ?>>Factura</option>
                </select>
            </p>
            <p>
                <label for="billing_rut">DNI/CE (ingrese solo cifras)</label>
                <input type="text" name="billing_rut" id="billing_rut" class="postbox"  value="<?php echo $billing_rut; ?>" />
            </p>

            <p>
                <label for="billing_ruc">RUC de la empresa</label>
                <input type="text" name="billing_ruc" id="billing_ruc" class="postbox"  value="<?php echo $billing_ruc; ?>" />
            </p>
            <p>
                <label for="billing_company">Razón social</label>
                <input type="text" name="billing_company" id="billing_company" class="postbox" value="<?php echo $billing_company; ?>" />
            </p>
            <p>
                <label for="billing_direccion_fiscal">Dirección fiscal</label>
                <input type="text" name="billing_direccion_fiscal" id="billing_direccion_fiscal" class="postbox" value="<?php echo $billing_direccion_fiscal; ?>" />
            </p>
            <p>
                <label for="billing_giro">Giro de la empresa</label>
                <input type="text" name="billing_giro" id="billing_giro" class="postbox" value="<?php echo $billing_giro; ?>" />
            </p>

            <?php
        }
        elseif( $is_add_campos_checkout_boleta )
        {
            ?>
            <p>
                <label for="billing_rut">DNI/CE (ingrese solo cifras)</label>
                <input type="text" name="billing_rut" id="billing_rut" class="postbox"  value="<?php echo $billing_rut; ?>" />
            </p>
            <?php
        }
    }
}
