<?php

require_once dirname(__FILE__) . '/../Autoload.php';

//cargo wordpress :)
if( INTEGRACION_SISTEMA === 'woocommerce' && !function_exists('add_filter') )
{
    $file1 = dirname(__FILE__) . '/../../../wp-load.php';
    $file2 = dirname(__FILE__) . '/../../../../../wp-load.php';

    if( file_exists($file1) )
    {
        // echo("encontrado $file1");
        require_once $file1;
    }
    elseif( file_exists($file2) )
    {
        // echo("encontrado $file2");
        require_once $file2;
    }
    else
    {
        die('wp-load.php no encontrado! ' . realpath($file1) . ', ' . realpath($file2));
    }
}



//check plugin is enabled

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if( !is_plugin_active('woocommerce-bsalev2/woocommerce-bsalev2.php') )
{
    Funciones::print_r_html('plugin is NOT active');
    return;
}
else
{
    //Funciones::print_r_html('plugin is active');
}
//set session error handler
/* function session_error_handling_function($code, $msg, $file, $line) {
  echo("<p>Session error: $code '$msg', archivo $file, linea $line</p>");
  }

  set_error_handler('session_error_handling_function'); */

/**
 * Description of WoocommerceBsale
 *
 * @author Lex
 */
class WoocommerceBsale extends OCDB
{

    public function sync_variacion_wc($data)
    {
        date_default_timezone_set("America/Santiago");
        ini_set("date.timezone", "America/Santiago");

        if( defined('WC_INSERT_VARIANTES_AS_PRODS') && WC_INSERT_VARIANTES_AS_PRODS == true )
        {
            $nombre = $data['product']['name'] . ' ' . $data['variant_description'];
        }
        else
        {
            $nombre = $data['product']['name'];
        }
        $variant_id = $data['variant_id'];
        $product_name = $data['product']['name'];
        $precio = $data['variant_price']['price'];

        if( isset($data['variant_stock']['variant_total_stock']) && $data['variant_stock']['variant_total_stock'] < 0 )
        {
            $data['variant_stock']['variant_total_stock'] = 0;
        }
        $stock = $data['variant_stock']['variant_total_stock'];

        if( defined('BSALE_IDENTIFICADOR_PRODUCTO') && BSALE_IDENTIFICADOR_PRODUCTO === 'ean' )
        {
            $sku = $data['variant_barcode'];
        }
        else
        {
            $sku = $data['variant_code'];
        }

        //datos para archivo log
        $hoy = date('Y-m-d');
        $basename = "sync_variacion_wc-$hoy";
        $log = new DocumentoAbstracto();

        $prod_bsale = new ProductoBsale();

        //los que empiezan con XXX, no sincronizar 
        if( $prod_bsale->is_product_to_skip($sku) )
        {
            $title = date('d-m-Y H:i:s') . " sync_variacion_wc, (id bsale=$variant_id) sku=$sku, nombre '$nombre' empieza con prejijo, omito producto";
            Funciones::print_r_html($title);
            // $log->logFile($basename, null, null, $title);

            return false;
        }

        //resto stock desde Bsale
        //en el caso de WC, la cantidad a restar del stock se configura desde el plugin
        //salto prodcutos con precio menor a        
        if( defined('BSALE_SKIP_UPDATE_PRECIOS_LESS_THAN') && BSALE_SKIP_UPDATE_PRECIOS_LESS_THAN > 0 )
        {
            if( $precio <= BSALE_SKIP_UPDATE_PRECIOS_LESS_THAN )
            {
                $title = date('d-m-Y H:i:s') . " sync_variacion_wc, (id bsale=$variant_id) sku=$sku, precio $precio <= " . BSALE_SKIP_UPDATE_PRECIOS_LESS_THAN .
                        ", no se actualiza precio de esta variacion";
                Funciones::print_r_html($title);
                // $log->logFile($basename, null, null, $title);
                //return false;
            }
        }

        //stock por sucursal html
        if( Funciones::is_mostrar_stock_sucursal() || Funciones::is_mostrar_stock_sucursal_backend() )
        {
            $es_pack = (!empty($data['product']['pack_details']) ) ? true : false;

            $bsale = new Bsale();

            $stock_sucursal_arr = $bsale->get_stock_sucursal_html($sku, $es_pack, $stock, true);

            $data['stock_por_sucursal_html'] = $stock_sucursal_arr;

            if( isset($_REQUEST['param']) )
            {
                Funciones::print_r_html($stock_sucursal_arr, "stock_sucursal_arr para id bsale=$variant_id "
                        . "es pack=$es_pack, stock pack=$stock");
            }
        }

        $prod_wp = new ProductWP();

        //existe una variacion/producto con este sku en wc?
        $product_arr = $prod_wp->getProductoBySku($sku, true);

        //si existen prodcutos con este sku
        if( is_array($product_arr) && count($product_arr) > 0 )
        {
            $result = 0;

            foreach( $product_arr as $product )
            {
                //si existe, actualizo
                if( $product )
                {
                    $title = date('d-m-Y H:i:s') . " sync_variacion_wc, (id bsale=$variant_id) variacion sku= $sku ya existe, actualizo sus datos";
                    Funciones::print_r_html($title);
                    // $log->logFile($basename, null, null, $title);

                    $result = $this->update_variacion_wc($data, $product);
                }
            }
            //updateados, devuelvo
            return $result;
        }

        //¿debo crear productos?
        if( Funciones::is_create_products() !== true )
        {
            $title = date('d-m-Y H:i:s') . " sync_variacion_wc, (id bsale=$variant_id) sku=$sku, nombre '$nombre' no existe en la tienda y "
                    . "la creacion de productos está desactivada. Se omite.";
            Funciones::print_r_html($title);
            //$log->logFile($basename, null, null, $title);
            return false;
        }
        //creo prodcuto/variacion 
        $result = $this->add_variacion_wc($data);

        return $result;
    }

    /**
     *  actualiza prodcuto o ovariacion de WC, según los datos en $data
     * @param type $data
     * @param type $product
     * @param type $sku si $product es null, lo busca por sku
     * @return boolean
     */
    public function update_variacion_wc($data, $product = null, $sku = null)
    {
        //$conn = $this->conectar();
        /* if( $conn == false )
          {
          return null;
          } */

        //log ultimo cambio
        global $global_file_update_product;

        if( empty($global_file_update_product) )
        {
            $global_file_update_product = '';
        }

        if( defined('WC_INSERT_VARIANTES_AS_PRODS') && WC_INSERT_VARIANTES_AS_PRODS == true )
        {
            $nombre = $data['product']['name'] . ' ' . $data['variant_description'];
        }
        else
        {
            $nombre = $data['product']['name'];
        }

        $variant_id = $data['variant_id'];
        $precio = $data['variant_price']['price'];
        $precio_especial = $data['variant_price']['price_desc'];
        $precio_especial2 = (int) $data['variant_price']['price_desc2'];
        $precio_especial3 = (int) $data['variant_price']['price_desc3'];

        $stock = $data['variant_stock']['variant_total_stock'];

        if( defined('BSALE_IDENTIFICADOR_PRODUCTO') && BSALE_IDENTIFICADOR_PRODUCTO === 'ean' )
        {
            $sku = $data['variant_barcode'];
        }
        else
        {
            $sku = $data['variant_code'];
        }

        //datos para archivo log
        $hoy = date('Y-m-d');
        $basename = "sync_variacion_wc-$hoy";
        $log = new DocumentoAbstracto();

        $prod_wp = new ProductWP();

        $limit_stock = Funciones::get_bsale_limit_stock();

        //si limito stock
        if( $limit_stock != 0 )
        {

            $title = date('d-m-Y H:i:s') . "update_variacion_wc(): limito stock para ($sku) stock original=$stock - $limit_stock";
            Funciones::print_r_html($title);
            //$log->logFile($basename, null, null, $title);
            //ajusto stock

            if( $stock != 999999 )
            {
                $stock = ($stock - $limit_stock) >= 0 ? $stock - $limit_stock : 0;
            }

            $title = date('d-m-Y H:i:s') . "update_variacion_wc(): stock limitado para ($sku)=$stock ";
            Funciones::print_r_html($title);
            //$log->logFile($basename, null, null, $title);
        }

        if( $product == null )
        {
            if( !empty($sku) )
            {
                $prod_wp = new ProductWP();

                //existe una variacion/producto con este sku en wc?
                $product = $prod_wp->getProductoBySku($sku);
            }
        }

        //inicio loop productos
        if( !$product )
        {
            $title = date('d-m-Y H:i:s') . "update_variacion_wc(): producto/variacion sku= $sku no encontrado. Se omite";
            Funciones::print_r_html($title);
            //$log->logFile($basename, null, null, $title);
            return false;
        }

        //busco producto/variacion id
        $product_id = null;

        //depende de la vbersion de Woocommerce
        if( method_exists($product, 'get_id') )
        {
            $product_id = $product->get_id();
        }
        else
        {
            $product_id = $product->id;
        }


        if( !$product_id )
        {
            $title = date('d-m-Y H:i:s') . "update_variacion_wc(): producto/variacion sku= $sku PRODUCTO ID NO ENCONTRADO!. Se omite";
            Funciones::print_r_html($title);
            //$log->logFile($basename, null, null, $title);
            return false;
        }

        $product_wc_name = $product->get_title();

        $title = date('d-m-Y H:i:s') . "update_variacion_wc(): producto/variacion id wc=$product_id sku= $sku, "
                . "nombre producto wc= '$product_wc_name', stock=$stock, precio= $ $precio, precio descto= $ $precio_especial, precio2= $ $precio_especial2";
        Funciones::print_r_html($title);
        //$log->logFile($basename, null, null, $title);
        //debo actualizar producto o variacion?  
        //¿es variacion?
        if( $product instanceof WC_Product_Variation )
        {
            if( isset($_REQUEST['param']) )
            {
                Funciones::print_r_html("Producto id wc=$product_id es VARIACION");
            }
            $es_variante = true;

            $producto_padre_id = $product->get_parent_id();
            $product_padre = wc_get_product($producto_padre_id);

            if( $product_padre !== false )
            {
                $title = date('d-m-Y H:i:s') . " update_variacion_wc(): sku='$sku' es variante: $es_variante del producto: " . $product_padre->get_id() . "  '" . $product_padre->get_name() . "'";
                if( isset($_REQUEST['param']) )
                {
                    Funciones::print_r_html($title);
                }
                // $log->logFile($basename, null, null, $title);
            }
            else
            {
                $title = date('d-m-Y H:i:s') . " update_variacion_wc(): sku='$sku' es variante sin padre. Se omite.";
                if( isset($_REQUEST['param']) )
                {
                    Funciones::print_r_html($title);
                }
                // $log->logFile($basename, null, null, $title);
                return false;
            }
        }
        //es producto simple
        else
        {
            $es_variante = false;
            $producto_padre_id = 0;
            $product_padre = null;

            $title = date('d-m-Y H:i:s') . " update_variacion_wc(): sku='$sku' es producto simple";
            Funciones::print_r_html($title);
            //$log->logFile($basename, null, null, $title);
        }

        try
        {
            if( WC_TEST === true )
            {
                return false;
            }

            $post_id = (int) $product_id;

            //actualizo variacion
            if( $es_variante )
            {
                //para taxonomia con/sin stock
                $product_variante = wc_get_product($post_id);

                //precio
                if( Funciones::is_update_product_price() && $precio > 1 )
                {
                    update_post_meta($post_id, '_regular_price', $precio);

                    $precio_oferta = get_post_meta($post_id, '_sale_price', true);

                    if( !empty($precio_oferta) )
                    {
                        update_post_meta($post_id, '_price', $precio_oferta);
                    }
                    else
                    {
                        update_post_meta($post_id, '_price', $precio);
                    }
                }
                //precio descto
                if( Funciones::is_update_product_price_desc() )
                {
                    $precio_especial = $precio_especial <= 1 ? '' : $precio_especial;
                    //si viene como neto, debo sumarle el iva
                    if( defined('BSALE_LISTA_PRECIOS_ESPECIALES_PESOS_NETO') && BSALE_LISTA_PRECIOS_ESPECIALES_PESOS_NETO == true )
                    {
                        $precio_especial = $precio_especial * Funciones::get_valor_iva();
                    }

                    update_post_meta($post_id, '_sale_price', $precio_especial);

                    //si precio normal no está vacío, actualizo
                    if( !empty($precio_especial) && $precio_especial > 0 )
                    {
                        update_post_meta($post_id, '_price', $precio_especial);
                    }
                    //dejo precio normal
                    else
                    {
                        $precio_normal = get_post_meta($post_id, '_regular_price', true);
                        update_post_meta($post_id, '_price', $precio_normal);
                    }
                    /* update_post_meta($post_id, '_regular_price', $precio);

                      $precio_oferta = get_post_meta($post_id, '_sale_price', true);

                      if( !empty($precio_oferta) )
                      {
                      update_post_meta($post_id, '_price', $precio_oferta);
                      }
                      else
                      {
                      update_post_meta($post_id, '_price', $precio);
                      } */
                }

                //precio mayorista normal $precio_especial2,
                //precio mayorista oferta  $precio_especial3
                if( Funciones::is_update_product_price_mayorista() )
                {
                    //filtros para precios mayoristas, para quie puedan ser manipulados fuera del plgun
                    $arr_filter_param = array( 'precio_may_normal' => $precio_especial2, 'precio_may_oferta' => $precio_especial3 );
                    do_action('bsale_filter_update_precios_mayoristas', $post_id, $arr_filter_param);
                }

                //stock
                if( Funciones::is_update_product_stock() && $stock > -1 )
                {
                    if( $stock != 999999 )
                    {
                        wc_update_product_stock($post_id, $stock);

                        if( $stock > 0 )
                        {
                            update_post_meta($post_id, '_stock_status', 'instock');
                            $product_variante->set_stock_status('instock');
                        }
                        else
                        {
                            update_post_meta($post_id, '_stock_status', 'outofstock');
                            $product_variante->set_stock_status('outofstock');
                        }
                        $product_variante->set_manage_stock(true);
                        update_post_meta($post_id, '_manage_stock', 'yes');
                    }
                    //no control de stock
                    else
                    {
                        //update_post_meta($post_id, '_stock_status', 'instock');
                        $product_variante->set_stock_status('instock');
                        $product_variante->set_manage_stock(false);
                        update_post_meta($post_id, '_manage_stock', 'no');
                    }


                    // Save and sync the product visibility
                    if( $product_variante !== false )
                    {

                        $resv = $product_variante->save();
                        Funciones::print_r_html("save variacion $post_id: $resv");
                    }
                    //fix sitios con pocos recursos, volver a colocar campos meta
                    //no se recomienda, pero...
                    if( $stock != 999999 )
                    {
                        if( $stock > 0 )
                        {
                            update_post_meta($post_id, '_stock_status', 'instock');
                        }
                        else
                        {
                            update_post_meta($post_id, '_stock_status', 'outofstock');
                        }
                        update_post_meta($post_id, '_manage_stock', 'yes');
                    }
                    //no control de stock
                    else
                    {
                        update_post_meta($post_id, '_manage_stock', 'no');
                    }


                    //enable stock management
                    // Get an instance of the WC_Product_Variation object
                    //$variation = new WC_Product_Variation($post_id);
                }

                if( isset($data['stock_por_sucursal_html']) )
                {
                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html($data['stock_por_sucursal_html'], "wc: update variacion id=$post_id sku=$sku, stock_por_sucursal_html");
                    }
                    update_post_meta($post_id, "stock_{$sku}", $data['stock_por_sucursal_html']);
                    update_post_meta($post_id, "stock_por_sucursal_html", $data['stock_por_sucursal_html']);
                }
                else
                {
                    delete_post_meta($post_id, "stock_{$sku}");
                    delete_post_meta($post_id, "stock_por_sucursal_html");
                }

                $info = date('Y-m-d H:i:s') . ": update variacion sku=$sku, precio = $precio, stock= $stock, archivo: '$global_file_update_product'\n" .
                        print_r($data, true);
                update_post_meta($producto_padre_id, 'variacion_' . $sku, $info);

                wc_delete_product_transients($post_id);
                wc_delete_product_transients($producto_padre_id);
                //$product_padre->save();
                //Funciones::print_r_html("save prod padre #$producto_padre_id de variacion");
                //do_action('woocommerce_update_product', $producto_padre_id);
            }
            //actualizo producto simple
            else
            {
                //para taxonomia con/sin stock
                $product_simple = wc_get_product($post_id);

                //necesario
                update_post_meta($post_id, '_manage_stock', 'yes');

                //update nombre
                if( Funciones::is_update_product_name() && !empty($nombre) )
                {
                    $my_post = array( 'ID' => $post_id, 'post_title' => $nombre );
                    wp_update_post($my_post);
                }
                //update price
                if( Funciones::is_update_product_price() && $precio > 1 )
                {
                    update_post_meta($post_id, '_regular_price', $precio);

                    $precio_oferta = get_post_meta($post_id, '_sale_price', true);

                    if( !empty($precio_oferta) )
                    {
                        update_post_meta($post_id, '_price', $precio_oferta);
                    }
                    else
                    {
                        update_post_meta($post_id, '_price', $precio);
                    }
                }
                //price desc
                if( Funciones::is_update_product_price_desc() )
                {
                    $precio_especial = $precio_especial <= 1 ? '' : $precio_especial;
                    //si viene como neto, debo sumarle el iva
                    if( defined('BSALE_LISTA_PRECIOS_ESPECIALES_PESOS_NETO') && BSALE_LISTA_PRECIOS_ESPECIALES_PESOS_NETO == true )
                    {
                        $precio_especial = $precio_especial * Funciones::get_valor_iva();
                    }

                    update_post_meta($post_id, '_sale_price', $precio_especial);

                    if( !empty($precio_especial) && $precio_especial > 0 )
                    {
                        update_post_meta($post_id, '_price', $precio_especial);
                    }
                    //dejo precio normal
                    else
                    {
                        $precio_normal = get_post_meta($post_id, '_regular_price', true);
                        update_post_meta($post_id, '_price', $precio_normal);
                    }

                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html("actualizo precio oferta de prod sku='$sku', pid= $post_id: $ $precio_especial");
                    }
                }
                //precio mayorista normal $precio_especial2,
                //precio mayorista oferta  $precio_especial3
                if( Funciones::is_update_product_price_mayorista() )
                {

                    //filtros para precios mayoristas, para quie puedan ser manipulados fuera del plgun
                    $arr_filter_param = array( 'precio_may_normal' => $precio_especial2, 'precio_may_oferta' => $precio_especial3 );
                    do_action('bsale_filter_update_precios_mayoristas', $post_id, $arr_filter_param);
                }

                //update stock
                if( Funciones::is_update_product_stock() && $stock > -1 )
                {
                    if( $stock != 999999 )
                    {
                        update_post_meta($post_id, '_manage_stock', 'yes');

                        wc_update_product_stock($post_id, $stock);
                        if( $stock > 0 )
                        {
                            //update_post_meta($post_id, '_stock_status', 'instock');
                            $product_simple->set_stock_status('instock');
                        }
                        else
                        {
                            update_post_meta($post_id, '_stock_status', 'outofstock');
                            $product_simple->set_stock_status('outofstock');
                        }
                        $product_simple->set_manage_stock(true);
                        update_post_meta($post_id, '_manage_stock', 'yes');
                    }
                    else
                    {
                        //wc_update_product_stock($post_id, $stock);
                        $product_simple->set_stock_status('instock');
                        $product_simple->set_manage_stock(false);
                        update_post_meta($post_id, '_manage_stock', 'no');

                        if( isset($_REQUEST['param']) )
                        {
                            Funciones::print_r_html("save  simple $post_id: manage stock false, instock");
                        }
                        //update_post_meta($post_id, '_stock_status', 'instock');
                    }

                    if( $product_simple !== false )
                    {

                        $resv = $product_simple->save();
                        if( isset($_REQUEST['param']) )
                        {
                            Funciones::print_r_html("save prod simple $post_id: $resv, con stock = $stock");
                        }
                    }

                    //fix sitios con pocos recursos, volver a colocar campos meta
                      //no se recomienda, pero...
                      if( $stock != 999999 )
                      {
                      if( $stock > 0 )
                      {
                      update_post_meta($post_id, '_stock_status', 'instock');
                      }
                      else
                      {
                      update_post_meta($post_id, '_stock_status', 'outofstock');
                      }
                      update_post_meta($post_id, '_manage_stock', 'yes');
                      }
                      //no control de stock
                      else
                      {
                      update_post_meta($post_id, '_manage_stock', 'no');
                      }
                     // wc_delete_product_transients($post_id);
                     
                }
                if( isset($data['stock_por_sucursal_html']) && !empty($data['stock_por_sucursal_html']) )
                {
                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html($data['stock_por_sucursal_html'], "wc: update prod simple id=$post_id sku=$sku, stock_por_sucursal_html");
                    }
                    update_post_meta($post_id, "stock_{$sku}", $data['stock_por_sucursal_html']);
                    update_post_meta($post_id, "stock_por_sucursal_html", $data['stock_por_sucursal_html']);
                }
                else
                {
                    delete_post_meta($post_id, "stock_{$sku}");
                    delete_post_meta($post_id, "stock_por_sucursal_html");
                }
                //log ultimo cambio
                $info = date('Y-m-d H:i:s') . ": update producto simple sku=$sku, precio = $precio, stock= $stock, archivo: '$global_file_update_product'\n" .
                        print_r($data, true);
                update_post_meta($post_id, 'producto_update', $info);

                //wc_delete_product_transients($post_id);
            }

            //     Funciones::print_r_html( "updateProductoMAG: $producto_mag_id despues de save()" );
        }
        catch( Exception $exc )
        {
            $title = date('d-m-Y H:i:s') . " update_variacion_wc(): exception";
            Funciones::print_r_html($exc, $title);
            // $log->logFile($basename, null, null, $title);
        }
        //fin loop


        Funciones::print_r_html("update variacion, fin");
        return true; //$product_result
    }

    public function clear_product_cache($product_id)
    {
        global $wpdb;

        $wpdb->query("DELETE FROM {$wpdb->prefix}options "
                . "WHERE {$wpdb->prefix}options.option_name "
                . "LIKE '_transient_timeout_wc_var_prices_$product_id'");

        $wpdb->query("DELETE FROM {$wpdb->prefix}options "
                . "WHERE {$wpdb->prefix}options.option_name "
                . "LIKE '_transient_wc_var_prices_$product_id'");
    }

    /**
     * crea un producto simple; una variación en un producto variable existente,
     * o un producto variable + la variacion 
     * @global type $woocommerce
     * @global type $woocommerce
     * @param type $data
     * @return boolean
     */
    public function add_variacion_wc($data)
    {
        //¿debo crear productos?
        if( !Funciones::is_create_products() )
        {
            return false;
        }

        //log ultimo cambio
        global $global_file_update_product;

        if( empty($global_file_update_product) )
        {
            $global_file_update_product = '';
        }

        /* $conn = $this->conectar();
          if( $conn == false )
          {
          return null;
          } */

        if( defined('WC_INSERT_VARIANTES_AS_PRODS') && WC_INSERT_VARIANTES_AS_PRODS == true )
        {
            $nombre = $data['product']['name'] . ' ' . $data['variant_description'];
            $nombre_producto = $nombre;
            $nombre_variacion = $nombre;
        }
        else
        {
            $nombre = $data['product']['name'];
            $nombre_producto = $data['product']['name'];
            $nombre_variacion = $data['variant_description'];
        }

        $variant_id = $data['variant_id'];
        $precio = $data['variant_price']['price'];
        $precio_especial = $data['variant_price']['price_desc'];
        $precio_especial2 = $data['variant_price']['price_desc2'];
        $precio_especial3 = $data['variant_price']['price_desc3'];

        $stock = $data['variant_stock']['variant_total_stock'];

        if( defined('BSALE_IDENTIFICADOR_PRODUCTO') && BSALE_IDENTIFICADOR_PRODUCTO === 'ean' )
        {
            $sku = $data['variant_barcode'];
        }
        else
        {
            $sku = $data['variant_code'];
        }

        if( ($stock == -1 || $stock == 999999) && $precio <= 0 )
        {
            if( isset($_REQUEST['param']) )
            {
                Funciones::print_r_html("add_variacion_wc, sku='$sku' tiene stock='$stock' y precio $ $precio, no se agrega.");
            }
            return false;
        }

        if( $stock <= 0 || $precio <= 0 )
        {
            /* if( isset($_REQUEST['param']) )
              {
              Funciones::print_r_html("add_variacion_wc, sku='$sku' tiene stock='$stock' <=0 o  precio $ $precio <=0, no se agrega.");
              }
              return false; */
        }



        /* if( $stock <= 0 )
          {
          Funciones::print_r_html("add_variacion_wc, sku='$sku' tiene stock <=0, no se agrega.");
          } */

        //datos para archivo log
        $hoy = date('Y-m-d');
        $basename = "sync_variacion_wc-$hoy";
        $log = new DocumentoAbstracto();

        $prod_wp = new ProductWP();

        $limit_stock = Funciones::get_bsale_limit_stock();

        //si limito stock
        if( $limit_stock != 0 )
        {

            $title = date('d-m-Y H:i:s') . "add_variacion_wc(): limito stock para ($sku) stock original=$stock - $limit_stock";
            Funciones::print_r_html($title);
            $log->logFile($basename, null, null, $title);

            //ajusto stock
            if( $stock != 999999 )
            {
                $stock = ($stock - $limit_stock) >= 0 ? $stock - $limit_stock : 0;
            }
            $title = date('d-m-Y H:i:s') . "add_variacion_wc(): stock limitado para ($sku)=$stock ";
            Funciones::print_r_html($title);
            //$log->logFile($basename, null, null, $title);
        }
        //existe el prodcuto o variacion?   
        //si debo insertar nuevos productos como variantes?
        //valor x defecto para no insertar variante
        $product_parent_id = 0;

        //si viene en global
        global $BSALE_GLOBAL;
        //dueño del producto
        $post_author_id = isset($BSALE_GLOBAL['SELLER_ID']) ? (int) $BSALE_GLOBAL['SELLER_ID'] : 1;


        //si debo insertar como variante
        if( WC_INSERT_NUEVOS_AS_VARIANTES )
        {
            //Funciones::print_r_html( $bsale_producto, "addproducto params:" );
            //existe un producto con este nombre al que agregarle la nueva variante?
            $product_parent = get_page_by_title($nombre_producto, OBJECT, 'product');

            //si producto no existe, lo creo
            if( $product_parent == null )
            {
                if( WC_TEST !== true )
                {
                    global $woocommerce;

                    $product_parent = array(
                        'post_author' => $post_author_id,
                        'post_status' => 'pending', //publish
                        'post_title' => $nombre_producto,
                        'post_content' => '',
                        'post_parent' => '',
                        'post_type' => 'product',
                            //'post_status' => 'private',
                    );
                    //Create post               
                    $product_parent_id = wp_insert_post($product_parent);
                    //tipo de producto: variable
                    wp_set_object_terms($product_parent_id, 'variable', 'product_type');
                    update_post_meta($product_parent_id, '_visibility', 'visible'); //search
                    update_post_meta($product_parent_id, '_stock_status', 'instock');
                    //update_post_meta( $product_parent_id, '_regular_price', $precio );
                    //update_post_meta( $product_parent_id, '_price', $precio );
                    // update_post_meta( $post_id, '_sale_price', $precio_especial );
                    update_post_meta($product_parent_id, '_purchase_note', "");
                    update_post_meta($product_parent_id, '_featured', "no");
                    update_post_meta($product_parent_id, '_weight', "");
                    update_post_meta($product_parent_id, '_length', "");
                    update_post_meta($product_parent_id, '_width', "");
                    update_post_meta($product_parent_id, '_height', "");
                    // update_post_meta( $product_parent_id, '_sku', $sku );
                    // update_post_meta( $product_parent_id, '_product_attributes', array() );
                    update_post_meta($product_parent_id, '_sale_price_dates_from', "");
                    update_post_meta($product_parent_id, '_sale_price_dates_to', "");
                    //update_post_meta($product_parent_id, '_price', $precio);
                    update_post_meta($product_parent_id, '_sold_individually', "no");
                    update_post_meta($product_parent_id, '_manage_stock', "no");
                    update_post_meta($product_parent_id, '_backorders', "no");
                    update_post_meta($product_parent_id, '_stock', null);
                    update_post_meta($product_parent_id, '_et_pb_page_layout', 'et_full_width_page');

                    $title = date('d-m-Y H:i:s') . "add_variacion_wc(): creo producto padre de variacion: '$nombre_producto', id= $product_parent_id";

                    Funciones::print_r_html($title);

                    //$log->logFile($basename, null, null, $title);

                    $producto_padre_obj = wc_get_product($product_parent_id);

                    Funciones::print_r_html($producto_padre_obj);

                    //agrego porducto a catyegoria
                    //$cat_id = WC_CATEGORIA_RECIEN_LLEGADOS;
                    //wp_set_object_terms( $post_id, $cat_id, 'product_cat' );
                    //xxx crear automaticamente este atributo si no existe
                    $talla_attributes = $prod_wp->get_attributes_wc('pa_talla', true);

                    $available_attributes = array( 'pa_talla' );
                    $variations = array( 'pa_talla' => $talla_attributes, );

                    // Add attributes passing the new post id, attributes & variations
                    $prod_wp->insert_product_attributes($product_parent_id, $available_attributes, $variations);
                }
            }
            else
            {
                if( method_exists($product_parent, 'get_id') )
                {
                    $product_parent_id = $product_parent->get_id();
                }
                else
                {
                    $product_parent_id = $product_parent->ID;
                }

                $title = date('d-m-Y H:i:s') . "add_variacion_wc(): obtengo producto padre id= $product_parent_id, '$nombre_producto' de variacion a crear";
                Funciones::print_r_html($title);
                // $log->logFile($basename, null, null, $title);
            }
        }

        try
        {

            if( WC_TEST == true )
            {
                return false;
            }
            //inserto producto               
            global $woocommerce;

            if( WC_INSERT_NUEVOS_AS_VARIANTES )
            {

                $title = date('d-m-Y H:i:s') . "add_variacion_wc(): creo variacion sku= $sku, '$nombre_variacion', para producto $product_parent_id '$nombre_producto', "
                        . "precio= $ $precio, precio desc= $ $precio_especial, precio2 = $ $precio_especial2, stock=$stock ";
                Funciones::print_r_html($title);
                // $log->logFile($basename, null, null, $title);

                $post = array(
                    'post_author' => $post_author_id,
                    'post_status' => 'publish', //publish pending
                    'post_title' => $nombre_variacion,
                    'post_content' => '',
                    'post_parent' => $product_parent_id,
                    'post_type' => 'product_variation',
                        //'post_status' => 'private',
                );
                //Create post               
                $post_id = wp_insert_post($post);

                update_post_meta($post_id, '_visibility', 'search'); //search

                update_post_meta($post_id, '_regular_price', $precio);
                update_post_meta($post_id, '_sku', $sku);
                update_post_meta($post_id, '_price', $precio);
                update_post_meta($post_id, '_sold_individually', 'no');
                update_post_meta($post_id, '_manage_stock', 'yes');
                update_post_meta($post_id, '_backorders', 'no');
                update_post_meta($post_id, '_stock', $stock);

                if( $stock > 0 )
                {
                    update_post_meta($post_id, '_stock_status', 'instock');
                }
                else
                {
                    update_post_meta($post_id, '_stock_status', 'outofstock');
                }
                //update_post_meta($post_id, '_manage_stock', 'yes');
                update_post_meta($post_id, '_et_pb_page_layout', 'et_full_width_page');

                //precio descto
                if( Funciones::is_update_product_price_desc() )
                {
                    $precio_especial = $precio_especial <= 1 ? '' : $precio_especial;

                    //si viene como neto, debo sumarle el iva
                    if( defined('BSALE_LISTA_PRECIOS_ESPECIALES_PESOS_NETO') && BSALE_LISTA_PRECIOS_ESPECIALES_PESOS_NETO == true )
                    {
                        $precio_especial = $precio_especial * Funciones::get_valor_iva();
                    }

                    update_post_meta($post_id, '_sale_price', $precio_especial);
                }
                //precio mayorista normal $precio_especial2,
                //precio mayorista oferta  $precio_especial3
                if( Funciones::is_update_product_price_mayorista() )
                {

                    //filtros para precios mayoristas, para quie puedan ser manipulados fuera del plgun
                    $arr_filter_param = array( 'precio_may_normal' => $precio_especial2, 'precio_may_oferta' => $precio_especial3 );
                    do_action('bsale_filter_add_precios_mayoristas', $post_id, $arr_filter_param);

                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html($arr_yith, " update_post_meta($post_id, '_product_rules', YITH role based price");
                    }
                }

                if( isset($data['stock_por_sucursal_html']) && !empty($data['stock_por_sucursal_html']) )
                {
                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html($data['stock_por_sucursal_html'], "wc: add variacion id=$post_id sku=$sku, stock_por_sucursal_html");
                    }
                    update_post_meta($post_id, "stock_{$sku}", $data['stock_por_sucursal_html']);
                    update_post_meta($post_id, "stock_por_sucursal_html", $data['stock_por_sucursal_html']);
                }
                else
                {
                    delete_post_meta($post_id, "stock_{$sku}");
                    delete_post_meta($post_id, "stock_por_sucursal_html");
                }


                //inserto atributo               
                $atributo_value = '20'; //atributo por default               

                $attribute_term = get_term_by('name', $atributo_value, 'pa_talla'); // We need to insert the slug not the name into the variation post meta
                if( isset($attribute_term->slug) )
                {
                    //Funciones::print_r_html($attribute_term->slug, "get_term_by( 'name', $atributo_value, 'pa_talla' )");
                    update_post_meta($post_id, 'attribute_pa_talla', $attribute_term->slug);
                    // Again without variables: update_post_meta(25, 'attribute_pa_size', 'small')
                }
                //add size attributes to this variation:
                $talla_attributes = $this->get_attributes_wc('pa_talla');
                wp_set_object_terms($post_id, $talla_attributes, 'pa_talla');
            }
            //inserto producto simple
            else
            {

                $title = date('d-m-Y H:i:s') . "add_variacion_wc(): creo producto simple sku= $sku, '$nombre_producto'. precio= $ $precio, precio desc= $ $precio_especial, precio2 = $ $precio_especial2, stock=$stock";
                Funciones::print_r_html($title);
                //$log->logFile($basename, null, null, $title);

                $objProduct = new WC_Product();

                $objProduct->set_name($nombre_producto);
                $objProduct->set_status('pending');  // can be publish,draft or any wordpress post status
                $objProduct->set_catalog_visibility('visible'); // add the product visibility status
                $objProduct->set_description($nombre_producto);
                $objProduct->set_sku($sku); //can be blank in case you don't have sku, but You can't add duplicate sku's
                $objProduct->set_price($precio); // set product price
                $objProduct->set_regular_price($precio); // set product regular price
                //no control stock
                if( $stock == 999999 )
                {
                    $objProduct->set_stock_status('instock');
                    $objProduct->set_manage_stock(false);
                    update_post_meta($post_id, '_manage_stock', 'no');
                }
                else
                {
                    $objProduct->set_manage_stock(true); // true or false
                    update_post_meta($post_id, '_manage_stock', 'yes');
                    $objProduct->set_stock_quantity($stock);

                    if( $stock > 0 )
                    {
                        $objProduct->set_stock_status('instock'); // in stock or out of stock value
                    }
                    else
                    {
                        $objProduct->set_stock_status('outofstock');
                    }
                }

                $objProduct->set_backorders('no');
                $objProduct->set_reviews_allowed(true);
                $objProduct->set_sold_individually(false);
                //$objProduct->set_category_ids(array( 1, 2, 3 )); // array of category ids, 

                $post_id = $objProduct->save(); // it will save the product and return the generated product id

                /* $post = array(
                  'post_author' => $post_author_id,
                  'post_status' => 'pending', //publish
                  'post_title' => $nombre_producto, //$name,
                  'post_content' => '',
                  'post_parent' => '',
                  'post_type' => 'product',
                  //'post_status' => 'private',
                  );
                  //Create post
                  $post_id = wp_insert_post($post);

                  wp_set_object_terms($post_id, 'simple', 'product_type');
                  update_post_meta($post_id, '_visibility', 'visible'); //search
                  //    update_post_meta( $post_id, '_virtual', 'yes' ); //xxx revusar
                  update_post_meta($post_id, '_regular_price', $precio);
                  update_post_meta($post_id, '_price', $precio);
                  // update_post_meta( $post_id, '_sale_price', $precio_especial );
                  update_post_meta($post_id, '_purchase_note', '');
                  update_post_meta($post_id, '_featured', 'no');
                  update_post_meta($post_id, '_weight', '');
                  update_post_meta($post_id, '_length', '');
                  update_post_meta($post_id, '_width', '');
                  update_post_meta($post_id, '_height', '');
                  update_post_meta($post_id, '_sku', $sku);
                  update_post_meta($post_id, '_product_attributes', array());
                  update_post_meta($post_id, '_sale_price_dates_from', '');
                  update_post_meta($post_id, '_sale_price_dates_to', '');
                  update_post_meta($post_id, '_sold_individually', 'no');
                  update_post_meta($post_id, '_manage_stock', 'yes');
                  update_post_meta($post_id, '_backorders', 'no');
                  update_post_meta($post_id, '_stock', $stock);

                  if( $stock > 0 )
                  {
                  update_post_meta($post_id, '_stock_status', 'instock');
                  }
                  else
                  {
                  //
                  update_post_meta($post_id, '_stock_status', 'outofstock');
                  }

                  // update_post_meta($post_id, '_et_pb_page_layout', 'et_full_width_page');
                 */
                if( isset($data['stock_por_sucursal_html']) )
                {
                    update_post_meta($post_id, "stock_{$sku}", $data['stock_por_sucursal_html']);
                    update_post_meta($post_id, "stock_por_sucursal_html", $data['stock_por_sucursal_html']);
                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html($data['stock_por_sucursal_html'], "wc: add prod simple id=$post_id sku=$sku, stock_por_sucursal_html");
                    }
                }
                else
                {
                    delete_post_meta($post_id, "stock_{$sku}");
                    delete_post_meta($post_id, "stock_por_sucursal_html");
                }

                //precio descto
                if( Funciones::is_update_product_price_desc() )
                {
                    $precio_especial = $precio_especial <= 1 ? '' : $precio_especial;

                    update_post_meta($post_id, '_sale_price', $precio_especial);
                }
                //precio mayorista normal $precio_especial2,
                //precio mayorista oferta  $precio_especial3
                if( Funciones::is_update_product_price_mayorista() )
                {

                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html($arr_yith, " update_post_meta($post_id, '_product_rules', YITH role based price");
                    }

                    //filtros para precios mayoristas, para quie puedan ser manipulados fuera del plgun
                    $arr_filter_param = array( 'precio_may_normal' => $precio_especial2, 'precio_may_oferta' => $precio_especial3 );
                    do_action('bsale_filter_add_precios_mayoristas', $post_id, $arr_filter_param);
                }

                //log ultimo cambio
                $info = date('Y-m-d H:i:s') . ": create producto simple sku=$sku, precio = $precio, stock= $stock, archivo: '$global_file_update_product'\n" .
                        print_r($data, true);
                // update_post_meta($post_id, 'producto_update', $info);
            }

            return true;
//endif;
        }
        catch( Exception $e )
        {
            $title = date('d-m-Y H:i:s') . "add_variacion_wc(): sku=$sku, excepcion";
            Funciones::print_r_html($e, $title);
            //$log->logFile($basename, $e, null, $title);
        }
    }

}
