<?php

require_once dirname(__FILE__) . '/../Autoload.php';

if( !defined('WP_USE_THEMES') )
{
    define('WP_USE_THEMES', false);
}

//cargo wordpress :)
if( INTEGRACION_SISTEMA === 'woocommerce' && !function_exists('add_filter') )
{
    $file1 = dirname(__FILE__) . '/../../../wp-load.php';
    $file2 = dirname(__FILE__) . '/../../../../../wp-load.php';

    if( file_exists($file1) )
    {
// echo("encontrado $file1");
        require_once $file1;
    }
    elseif( file_exists($file2) )
    {
// echo("encontrado $file2");
        require_once $file2;
    }
    else
    {
        die('wp-load.php no encontrado! ' . realpath($file1) . ', ' . realpath($file2));
    }
}

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ProductWP
 *
 * @author angelorum
 */
class ProductWP extends OCDB
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_all_products_ids2($post_type = "'product'", $limit = 500)
    {
        global $wpdb;
        // $limit determines how many rows you want to handle at any given time
        // increase / decrease this limit to see how much your server can handle at a time 
        $limit = ($limit < 0) ? 1 : (int) $limit;
        $post_type = empty($post_type) ? "'product'" : $post_type;

        $start = 0;

        $file_temp = dirname(__FILE__) . '/../logs/wp_all_import.txt';
        //borro file if existes
        if( file_exists($file_temp) )
        {
            unlink($file_temp);
        }

        // open file handle
        $myfile = fopen($file_temp, 'a');

        $qry = "SELECT ID FROM `$wpdb->posts` where post_type IN($post_type) AND post_status <> 'trash' limit %d, %d";
        while( $result = $wpdb->get_results($wpdb->prepare($qry, array( $start, $limit ))) )
        {
            $write_data = '';
            foreach( $result as $row )
            {
                $write_data .= $row->ID . "\n";
            }

            fwrite($myfile, $write_data);
            $start = $start + $limit;
        }

        // close file handle
        fclose($myfile);

        //abro archivo y paso a string
        $archivolocal = file_get_contents($file_temp);
        //remuevo el ultimo \n
        $archivolocal = substr($archivolocal, 0, -1);
        $arraux = explode("\n", $archivolocal);

        return $arraux;
    }

    /**
     * devuelve array con listado de product ids
     */
    public function get_all_products_ids($post_type = "'product'", $limit = 500)
    {
        return $this->get_all_products_ids2($post_type, $limit);

        $args = array(
            'posts_per_page' => -1,
            'post_type' => 'product', //array('product', 'product_variation'),
            'fields' => 'ids', // Only get post IDs
        );
        $the_query = new WP_Query($args);

        $arraux = array();

        while( $the_query->have_posts() )
        {
            $the_query->the_post();
            $post_id = get_the_ID();
            $arraux[] = $post_id;
        }
        /* //post con paginacion
          $page = 1;
          $arraux = array();
          do
          {
          $ok = false;
          $args = array(
          'posts_per_page' => 1000,
          'paged' => $page,
          'post_type' => array( 'product', 'product_variation' ), //'product',
          'fields' => 'ids', // Only get post IDs
          );
          $the_query = new WP_Query($args);
          $page++;

          while( $the_query->have_posts() )
          {
          $ok = true;
          $the_query->the_post();
          $post_id = get_the_ID();
          $arraux[] = $post_id;
          }
          }
          while( $ok ); */


        /* Restore original Post Data */
        wp_reset_postdata();

        if( isset($_REQUEST['param']) && $_REQUEST['param'] === 'yes' )
        {
            Funciones::print_r_html($arraux, "get_all_products_ids, resultado:");
        }
        return $arraux;
    }

    public function get_stock_sucursal_from_meta($post_id = 0, $sku = null)
    {
        global $wpdb;

        $meta_key = "stock_{$sku}";

        $sql = "SELECT meta.meta_value FROM "
                . "{$wpdb->postmeta} meta, "
                . "{$wpdb->posts} post "
                . " WHERE meta.meta_key='$meta_key' "
                . "AND "
                . "meta.post_id = post.ID "
                . "AND post.post_status <> 'trash' "
                . " LIMIT 1";

//Funciones::print_r_html("get_stock_sucursal_from_meta(sku=$sku), sql='$sql'");

        $stock_html = $wpdb->get_var($sql);

        return $stock_html;
    }

    /**
     * 
     * @global type $wpdb
     * @param type $sku_or_ean
     * @param type $not_join
     * @return \WC_Product
     */
    public function getProductoBySku($sku_or_ean, $return_array = false)
    {
        if( defined('BSALE_IDENTIFICADOR_PRODUCTO') && BSALE_IDENTIFICADOR_PRODUCTO === 'ean' )
        {
            $ean = true;
        }
        else
        {
            $ean = false;
        }

        global $BSALE_GLOBAL;
        $user_id = isset($BSALE_GLOBAL['SELLER_ID']) ? (int) $BSALE_GLOBAL['SELLER_ID'] : 0;

        global $wpdb;

        $sql = "SELECT meta.post_id as post_id, post.post_type as post_type FROM "
                . "{$wpdb->postmeta} meta, "
                . "{$wpdb->posts} post "
                . " WHERE meta.meta_key='_sku' AND meta.meta_value='%s' "
                . "AND "
                . "meta.post_id = post.ID ";

//multiuser: solo posts (productos) de este user
        if( $user_id > 0 )
        {
            $sql .= " AND post.post_author = '$user_id' ";
        }

        $sql .= "AND post.post_status <> 'trash' ";

        if( !$return_array )
        {
            $sql .= " LIMIT 1";
        }


        $sql = $wpdb->prepare($sql, $sku_or_ean);


        $results = $wpdb->get_results($sql);

        $productos_arr = array();


        Funciones::print_r_html($results, "getProductoBySku($sku_or_ean), sql='$sql', respuesta");

        foreach( $results as $r )
        {
            $product_id = $r->post_id;
            $post_type = $r->post_type;

            if( $product_id <= 0 )
            {
                continue;
            }
            if( $post_type === 'product' )
            {
                try
                {
                    $productos_arr[] = new WC_Product($product_id);
                }
                catch( Exception $exc )
                {
                    Funciones::print_r_html($exc, "getProductoBySku, post $product_id, del tipo= '$post_type', no se puedo crear WC_Product()");
                    continue;
                }
            }
            //product_variation
            elseif( $post_type === 'product_variation' )
            {
                try
                {
                    $productos_arr[] = new WC_Product_Variation($product_id);
                }
                catch( Exception $exc )
                {
                    Funciones::print_r_html($exc, "getProductoBySku, post $product_id, del tipo= '$post_type', no se puedo crear WC_Product_Variation()");
                    continue;
                }
            }
        }

        //si no retorno array, solo retorno el 1er producto
        if( !$return_array )
        {
            return isset($productos_arr[0]) ? $productos_arr[0] : null;
        }

        //retorno array de objetos
        return $productos_arr;
    }

    public function get_attributes_wc($taxonomy, $create_if_no_exists = false)
    {
//Funciones::print_r_html( 'get_attributes_wc' );
        $terms = get_terms(array(
            'taxonomy' => $taxonomy,
            'hide_empty' => false,
        ));

        $arr = array();

        foreach( $terms as $each_term )
        {
// echo $each_term->name . '</br>';
            $arr[] = $each_term->name;
        }
        return $arr;
    }

    public function insert_product_attributes($post_id, $available_attributes, $variations)
    {
        foreach( $available_attributes as $attribute ) // Go through each attribute
        {
            $values = array(); // Set up an array to store the current attributes values.
//hay values para este atributo?
// Funciones::print_r_html("insert_product_attributes, testing '$attribute'...");
            if( !isset($variations[$attribute]) )
            {
                Funciones::print_r_html('insert_product_attributes: atributo ' . $attribute . ' sin values');
                continue;
            }
            $valuesarr = $variations[$attribute];

// Essentially we want to end up with something like this for each attribute:
// $values would contain: array('small', 'medium', 'medium', 'large');

            $values = /* array_unique */( $valuesarr ); // Filter out duplicate values
// Store the values to the attribute on the new post, for example without variables:
// wp_set_object_terms(23, array('small', 'medium', 'large'), 'pa_size');
            wp_set_object_terms($post_id, $values, $attribute);
// Funciones::print_r_html("wp_set_object_terms( $post_id, values, $attribute );");
// Funciones::print_r_html( $values, "insert_product_attributes: wp_set_object_terms para $attribute, post= $post_id" );
        }

        $product_attributes_data = array(); // Setup array to hold our product attributes data

        foreach( $available_attributes as $attribute ) // Loop round each attribute
        {
            $product_attributes_data[$attribute] = array( // Set this attributes array to a key to using the prefix 'pa'

                'name' => $attribute,
                'value' => '',
                'is_visible' => '1',
                'is_variation' => '1',
                'is_taxonomy' => '1'
            );
        }

        update_post_meta($post_id, '_product_attributes', $product_attributes_data); // Attach the above array to the new posts meta data key '_product_attributes'
    }

}
