<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of VariantesProductoBsale
 *
 * @author angelorum
 */
class VariantesProductoBsale extends DocumentoAbstracto
{

    public function count()
    {

        $url = BSALE_VARIANTES_COUNT_URL;
        $response_array = $this->get($url);

        Funciones::print_r_html("VariantesProductoBsale->count variaciones en Bsale url='$url'");

        return isset($response_array['count']) ? $response_array['count'] : -1;
    }

    public function get_all_sku_productos($load_in_new_table = false)
    {
        $tabla = new SkuProductosTable();
        $tabla->clear_all($load_in_new_table);


        $limit = 50;
        $offset = 0;
        $total = $this->count();

        if( $total <= 0 )
        {
            Funciones::print_r_html("No hay lista de sku");
            return;
        }

        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html("get_all_sku_productos: $total sku ...");
            //die('fin');
        }

        //recorro y voy guardando en la db temporal
        for(; $total > 0; $total -= $limit )
        {
            $url = BSALE_VARIANTES_URL . "?limit=$limit&offset=$offset"; //fields=[code,id]&

            if( isset($_REQUEST['param']) )
            {
                Funciones::print_r_html("get_all_sku_productos: $url");
            }

            $response_array = $this->get($url);
            if( isset($response_array['items']) )
            {
                $response_array = $response_array['items'];
            }

            //Funciones::print_r_html($response_array);
            /* if ( $offset == 0 )
             */

//devuelvo un array con con [producto_id]=>sku
            //           $arraux = array();
            $len = count($response_array);
            for( $i = 0; $i < $len; $i++ )
            {
                $v = $response_array[$i];

                //solo activadas
                $state = (int) $v['state'];
                $producto_id = $v['product']['id'];
                $sku = trim($v['code']);
                //si identificador es sku, dato1 es ean; y viceversa
                $dato1 = trim($v['barCode']);

                //solo variaciones activas
                if( $state != 0 && isset($_REQUEST['param']) ) //state=0, activas
                {
                    Funciones::print_r_html(null, "get_all_sku_productos: variacion sku= '$sku' está desactivada en Bsale, se omite.");
                    continue;
                }

                //requiero este dato
                if( !isset($v['product']['id']) && isset($_REQUEST['param']) )
                {
                    Funciones::print_r_html(null, "sku= '$sku' no tiene prod id, se omite");
                    continue;
                }


                $variante_id = $v['id'];
                $description = $v['description'];

                //los que empiezan con 'gama', no                    
                /* $start = substr($description, 0, 4);
                  if (strcasecmp($start, 'gama') == 0)
                  {
                  continue;
                  } */

                //si identifico los productos por ean
                if( defined('BSALE_IDENTIFICADOR_PRODUCTO') && BSALE_IDENTIFICADOR_PRODUCTO === 'ean' )
                {
                    $sku = $v['barCode'];
                    $dato1 = $v['code'];
                }
                //   $arraux[$producto_id] = $sku;

                $array_datos = array();
                $array_datos['producto_bsale_id'] = $producto_id;
                $array_datos['sku'] = $sku;
                $array_datos['dato1'] = $dato1;
                $array_datos['variante_id'] = $variante_id;
                $array_datos['description'] = $description;

                // Funciones::print_r_html($array_datos, "get_all_sku_productos(), agrego");

                $tabla->add($array_datos, $load_in_new_table);
                //muestro atributos
                //$atributos = $this->get_atributos_variante($variante_id);
            }


            $offset += $limit;

            unset($response_array);
        }
        return true;
    }

    /**
     * devuelve la variacion dede Bsale
     * @param type $sku
     * @return type
     */
    public function get_variacion_by_sku($sku)
    {
        $sku = urlencode($sku);
        sleep(1);
        //Funciones::print_r_html("get_variacion_by_sku sku= '$sku'");
        $url = BSALE_VARIANTES_URL . "?code=$sku"; //fields=[code,id]&
        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html("get_variacion_by_sku {$sku}: $url");
        }
        $response_array = $this->get($url);
        if( isset($response_array['items']) )
        {
            $response_array = $response_array['items'];
        }

        $len = is_array($response_array) ? count($response_array) : 0;
        for( $i = 0; $i < $len; $i++ )
        {
            $v = $response_array[$i];

            return $v;
        }

        return null;
    }

    public function get_atributos_variante($variante_id)
    {
        $url = sprintf(BSALE_PRODUCTO_VARIANTES_URL, $variante_id);
        $response = $this->get($url);

        Funciones::print_r_html($response, " get_atributos_variante( $variante_id)");
    }

    public function get_stock_producto($producto_sku, $officeid = null)
    {
        if( $officeid == null )
        {
            $officeid = Funciones::get_matriz_bsale();
        }

        $url = BSALE_PRODUCTO_STOCK_URL . "?code=$producto_sku&officeid=$officeid";
        $response_array = $this->get($url);

        //  Funciones::print_r_html( $response_array, "get_stock_producto( $producto_sku, $officeid )" );
        if( isset($response_array['items']) )
        {
            $response_array = $response_array['items'];
        }
        //xxx dejar stock en 0
        $stock = isset($response_array['quantityAvailable']) ? $response_array['quantityAvailable'] : 0;

        unset($response_array);
        return $stock;
    }

    /**
     * 
     * 
     * @param type $producto_sku
     * @param type $officeid
     * @return type
     */
    public function get_precio_producto($producto_sku, $officeid = null)
    {
        if( $officeid == null )
        {
            $officeid = Funciones::get_matriz_bsale();
        }
        $url = Funciones::get_lp_url_bsale() . "?code=$producto_sku&officeid=$officeid";
        $response_array = $this->get($url);

        // Funciones::print_r_html( $response_array, "get_precio_producto( $producto_sku, $officeid )" );

        if( isset($response_array['items']) )
        {
            $response_array = $response_array['items'];
        }
        //xxx dejar precio en 0
        $stock = isset($response_array['variantValueWithTaxes']) ? $response_array['variantValueWithTaxes'] : 0;

        unset($response_array);
        return $stock;
    }

}
