<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of TipoProductosBsale
 *
 * @author angelorum
 */
class UsuariosBsale extends DocumentoAbstracto
{

    /**
     * no está implementada en bsale
     * @return type
     */
    public function count()
    {
        return 500;
//        $url = BSALE_SUCURSALES_URL . '?limit=1&offset=0';
//        $response_array = $this->get($url);
//
//        //  Funciones::print_r_html($response_array, "StockProductosBsale->count(): $url");
//
//        return isset($response_array['count']) ? $response_array['count'] : -1;
    }

    public function get_usuarios_array($only_enabled = false)
    {
        $sucursales = $this->get_all_usuarios(false);

        $arraux = array();

        if( !is_array($sucursales) )
        {
            return $arraux;
        }

        foreach( $sucursales as $s )
        {
            //state=0 user enabled
            if( $only_enabled && $s['state'] != 0 )
            {
                continue;
            }
            if( !isset($s['id']) )
            {
                continue;
            }

            $user_id = $s['id'];
            $arraux[$user_id] = $s;
        }

        return $arraux;
    }

    /**
     * indices: id, name, etc
     * @return type
     */
    public function get_all_usuarios($filter = null)
    {
        $limit = 50;
        $offset = 0;
        $total = $this->count();
        $arraux = array();

        if( $total <= 0 )
        {
            //Funciones::print_r_html("No hay lista de sucursales");
            return array();
        }
        //Funciones::print_r_html("get_all_sucursales: descargando $total sucursales...");
        //  $total = 300;
        for(; $total > 0; $total -= $limit )
        {
            $url = BSALE_USERS_GET_URL . "?limit=$limit&offset=$offset";

          //  Funciones::print_r_html("get_all_usuarios: $url");

            $response_array = $this->get($url);
            // $total = isset($response_array['count']) ? $response_array['count'] : $total;

            if( isset($response_array['items']) )
            {
                $response_array = $response_array['items'];
            }
            //devuelvo un array con con [producto_id]=>sku

            $len = count($response_array);
            for( $i = 0; $i < $len; $i++ )
            {
                $arraux[] = $response_array[$i];
            }

            if( $len < $limit )
            {
                break;
            }
            $offset += $limit;
        }
        return $arraux;
    }

    /**
     * devuelve un array con los ids de todas las sucursales 
     */
    public function get_all_usuarios_ids()
    {
        $arr = $this->get_all_sucursales();
        $array_sucursales = array();

        foreach( $arr as $value )
        {
            $array_sucursales[] = $value['id'];
        }
        return $array_sucursales;
    }

}
