<?php

require_once dirname( __FILE__ ) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of StockProductosBsale
 *
 * @author angelorum
 */
class StockProductosBsale extends DocumentoAbstracto
{

    public function count( $sucursal_id = null )
    {

        $url = BSALE_PRODUCTO_STOCK_URL . '?limit=1&offset=0';

        if ( $sucursal_id )
            $url .= "&officeid=$sucursal_id";

        $response_array = $this->get( $url );

        //  Funciones::print_r_html($response_array, "StockProductosBsale->count(): $url");

        return isset( $response_array['count'] ) ? $response_array['count'] : -1;
    }

    public function get_all_stock_productos()
    {
        //cargo listado de sucursales dede bsale
        $sucursales_bsale = new SucursalesBsale();
        $sucursales_bsale->get_all_sucursales( true );

        

        $tabla = new StockStockTable();
        $tabla->clear_all();

        $otras_sucursales = explode( ',', Funciones::get_sucursales_bsale() );
        
        if(empty($otras_sucursales) || !is_array($otras_sucursales))
        {
            $otras_sucursales = array();
        }
        //junto todas ls sucursales
        $sucursales = array_merge( array( Funciones::get_matriz_bsale() ), $otras_sucursales );

        //obtengo listado de todas las sucursales, para sumar el stock de todas
        //solo si la constante BSALE_SUCURSAL_ALL_SUCURSALES_ID= true
        if ( defined( 'BSALE_SUCURSAL_ALL_SUCURSALES_ID' ) && BSALE_SUCURSAL_ALL_SUCURSALES_ID === true )
        {
            $sucursales_table = new SucursalesBsale();
            $sucursales = $sucursales_table->get_all_sucursales_ids();
            Funciones::print_r_html( $sucursales, "todas las sucursales:" );
        }


        //rincon fotog aqui agregar, obtener listado de toda slas suciursales, id y nombre
      
        
        foreach ( $sucursales as $sucursal_id )
        {
            //solo numeros
            $sucursal_id = intval( $sucursal_id );
            if ( $sucursal_id <= 0 )
                continue;
            $this->get_stock_from_sucursal( $sucursal_id );
        }
        return true;
        
    }

    public function get_stock_from_sucursal( $sucursal_id, $clear_table = false )
    {
        Funciones::print_r_html( "get_stock_from_sucursal: $sucursal_id" );
        $tabla = new StockStockTable();

        if ( $clear_table )
            $tabla->clear_all();

        //guardo stock por sucursal
        $stock_por_sucursal = new StockSucursalesProductos();
       // $stock_por_sucursal->clear_all($sucursal_id); no borro, actualizo


        $limit = 50;
        $offset = 0;
        $total = $this->count();

        if ( $total <= 0 )
        {
            Funciones::print_r_html( "get_stock_from_sucursal $sucursal_id: No hay lista de stocks para sucursal $sucursal_id" );
            return;
        }
        Funciones::print_r_html( "get_stock_from_sucursal $sucursal_id: descargando $total stocks..." );
        //  $total = 300;
        //recorro y voy guardando en la db temporal
        for (; $total > 0; $total-=$limit )
        {
            $url = BSALE_PRODUCTO_STOCK_URL . "?officeid=$sucursal_id&limit=$limit&offset=$offset";



            $response_array = $this->get( $url );
            if ( isset( $response_array['items'] ) )
            {
                $response_array = $response_array['items'];
            }
//devuelvo un array con con [producto_id]=>sku
            $arraux = array();
            $len = count( $response_array );

            //    Funciones::print_r_html("get_all_stock_productos $len: $url");

            for ( $i = 0; $i < $len; $i++ )
            {
                $v = $response_array[$i];

                //requiero este dato
                if ( !isset( $v['variant']['id'] ) )
                {
                    Funciones::print_r_html( null, "no tiene variant id" );
                    continue;
                }
                $variante_id = $v['variant']['id'];
                $stock = $v['quantityAvailable'];
                //   $arraux[$producto_id] = $precio;

                //if ( $sucursal_id === Funciones::get_matriz_bsale() )
                //{
                    $array_datos = array();
                    $array_datos['variante_id'] = $variante_id;
                    $array_datos['stock'] = $stock;

                    $tabla->add_or_update( $array_datos );
                //}

                //guardo stock por sucursal
                $array_datos2 = array( 'variante_id' => $variante_id, 'sucursal_id' => $sucursal_id,
                    'sku_ean' => '', 'stock' => $v['quantityAvailable'] );
                $stock_por_sucursal->add_or_update( $array_datos2 );
            }


            $offset+=$limit;

            unset( $response_array );
        }
        return true;
    }

}
