<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ProductoBsale
 *
 * @author angelorum
 */
class ProductoBsale extends DocumentoAbstracto
{

    /**
     *  funcion que hace dos cosdas:
     * 
     * 1) revisa si hay productos por enviar a bsale; en ese caso, los envia
     * 2) si ya se enviaron todos, procede a obteenr desde bsale 
     * prodcutos nuevos, y los clasifica si son para add o update a js
     * @return type
     */
    public static function syncDatosBsaleToJumpseller()
    {
        ini_set('memory_limit', '256M');
        set_time_limit(0); //10 minutod

        Funciones::print_r_html("syncDatosBsaleToJumpseller inicio");
        //desde ahora, laintegracion funciona con webhooks.
        //esto solo se usa para el cotizador.
        Funciones::print_r_html("syncDatosBsaleToJumpseller cargo datos para el cotizador");
        self::loadDataFromBsale();
        return;

        //veo si hay prodcutos pendientes por enviar
        //si no es false, es que se enviaron
        if( JumpSellerProduct::hayProductosPorEnviar() == false )
        {
            self::loadDataFromJumpseller();
            self::loadDataFromBsale();

            return;
        }

        Funciones::print_r_html("self::loadDataFromBsale()==true, procedo a comparar productos");
        //de los prodcutos cargados recien, veo cuales se deben add, update o delete
        self::prepararProductosParaEnviar();
        Funciones::print_r_html("syncDatosBsaleToJumpseller fin");
        return;
    }

    public static function prepararProductosParaEnviar()
    {
        $productos_db = new ProductoBsale();

        Funciones::print_r_html("sendDataToJumpseller antes ");
        $result_array = $productos_db->compareProductosBsaleToJS();
        Funciones::print_r_html("sendDataToJumpseller despues ");
        return $result_array;
    }

    /* public static function checkProductosPorEnviarAJS( $borrar_sobrantes = true )
      {
      $p = new SkuProductosTable();
      $cantidad = $p->count_por_enviarMagento();

      if ( $borrar_sobrantes && $cantidad <= 0 )
      {
      Funciones::print_r_html( "No tengo productos de bsale para sync, veo si en js hgay productos para borrar" );
      $p = new MagentoProduct();
      $p->borrarProductosExtraMagento();
      }

      return ($cantidad > 0);

      Funciones::print_r_html( "checkProdcutosPorEnviarAJS inicio" );

      $producto_bsale = new ProductoBsale();

      //veo si tengo prodcutpos desde bsale que sincronizar
      $stock_db = new ProductosStockBsale();
      $productos_for_add = $stock_db->get_all( null, 'estado_para_enviar = "A"', 200 );

      //add prodcutos a js
      if ( !empty( $productos_for_add ) && count( $productos_for_add ) > 0 )
      {
      Funciones::print_r_html( "checkProdcutosPorEnviar a JS 'A' de cant productos: " . count( $productos_for_add ) );
      //$productos_for_add = array_slice( $productos_for_add, 0, 50 );
      $producto_bsale->sendProductosToJumseller( $productos_for_add, 'A' );

      return 'A';
      }

      //updato productos a js
      $productos_for_update = $stock_db->get_all( null, 'estado_para_enviar = "U"', 200 );
      if ( !empty( $productos_for_update ) && count( $productos_for_update ) > 0 )
      {
      Funciones::print_r_html( "checkProdcutosPorEnviarAJS 'U' de cant productos: " . count( $productos_for_update ) );
      // $productos_for_update = array_slice( $productos_for_update, 0, 50 );
      $producto_bsale->sendProductosToJumseller( $productos_for_update, 'U' );


      return 'U';
      }
      //si no hay ni para add ni update, veo si en la tabla de productos de js
      //hay algunos para eliminar
      $prod_js = new JumpSellerProduct();
      $productos_js_para_borrar = $prod_js->get_all_by_sku_index();

      if ( !empty( $productos_js_para_borrar ) && count( $productos_js_para_borrar ) > 0 )
      {
      $me = new ProductosJumpsellerTable();

      Funciones::print_r_html( "checkProdcutosPorEnviarAJS productos para borrar: " . count( $productos_js_para_borrar ) );

      foreach ( $productos_js_para_borrar as $sku => $prod )
      {
      //borro desde js y de tabla local
      $producto_js_id = $prod['producto_jumpseller_id'];

      $me->delete_producto( $producto_js_id );
      $prod_js->delete_product( $producto_js_id );
      Funciones::print_r_html( "delete js prod $producto_js_id sku: $sku" );
      }
      return 'D';
      }
      return false;
      } */

    public static function loadDataFromBsale()
    {
        //stocks desde bsale
        $stock_db = new StockProductosBsale();
        $stock_db->get_all_stock_productos();

        //cargo precios desde bsale

        $precios_db = new PreciosProductosBsale();
        $precios_db->get_all_precios_productos();

        $lp_oferta_id = Funciones::get_lp_oferta_bsale();
        //cargo precios especiales desde bsale
        if( $lp_oferta_id > 0 )
        {
            $precios_esp = new PreciosEspecialesBsale();
            $precios_esp->get_all_precios_productos();
        }

        //cargo mas precios especiales desde bsale (aakash, listados excel)
        if( BSALE_LISTA_PRECIOS_ESPECIALES_2 > 0 )
        {
            $precios_esp = new PreciosEspecialesBsale();
            $precios_esp->get_all_precios_productos(BSALE_PRODUCTO_PRECIO_ESPECIAL2_URL, 'precio3');
        }
        if( BSALE_LISTA_PRECIOS_ESPECIALES_3 > 0 )
        {
            $precios_esp = new PreciosEspecialesBsale();
            $precios_esp->get_all_precios_productos(BSALE_PRODUCTO_PRECIO_ESPECIAL3_URL, 'precio4');
        }
        if( BSALE_LISTA_PRECIOS_ESPECIALES_4 > 0 )
        {
            $precios_esp = new PreciosEspecialesBsale();
            $precios_esp->get_all_precios_productos(BSALE_PRODUCTO_PRECIO_ESPECIAL4_URL, 'precio5');
        }
        if( BSALE_LISTA_PRECIOS_ESPECIALES_5 > 0 )
        {
            $precios_esp = new PreciosEspecialesBsale();
            $precios_esp->get_all_precios_productos(BSALE_PRODUCTO_PRECIO_ESPECIAL5_URL, 'precio6');
        }

        //cargo listado de prodcutos desde bsale
        $productos_db = new ProductoBsale();
        $productos_db->get_all();

        //cargo nombres de tipos de producto en campo 'description'
        $tbl = new ProductosStockBsale();
        $tbl->loadTiposEnTablaProducto();

        //cargo sku de cada producto
        $variantes_db = new VariantesProductoBsale();
        $variantes_db->get_all_sku_productos();

        //guardo sku, precio y stock en tabla de productos local
        $res = $productos_db->loadDatosEnTablaProducto();
        Funciones::print_r_html($res, "loadDataFromBsale: tabla productos local: guardo sku, precio y stock desde las otras tablas");

        return true;
    }

    public static function loadDataFromMagento()
    {
        $mag = new MagentoProduct();
        $mag->get_all_save_in_table();
    }

    public static function loadDataFromJumpseller()
    {
        // die("antes de cargar prods desde js");
        //cargo listado de productos desde js
        $producto_js = new JumpSellerProduct();
        //xxx sacar noro categoria
        $producto_js->get_all(/* array( 333 ) */);
    }

    public function sendProductosToJumseller($bsale_products, $accion)
    {
        $js_productos = new ProductosJumpsellerTable();
        //recorro los productos de bsale y los voy comparando con los de js
        $l = count($bsale_products);
        Funciones::print_r_html("sendProductosToJumseller accion '$accion', Total productos bsale a sync: $l");
        $producto_js = new ProductosJumpsellerTable();

        foreach( $bsale_products as $p )
        {
            if( $accion === 'A' )
            {

                $this->addProductoJumpseller($p);

                //borro este producto de la tabla de productos de js, porque ya se ha sincronizado
                $producto_js->delete_producto_by_sku($p['sku']);
            }
            else if( $accion === 'U' )
            {
                $js_producto = $js_productos->find_by_sku($p['sku']);
                $this->updateProductoJumpseller($p, $js_producto);

                //borro este producto de la tabla de productos de js, porque ya se ha sincronizado               
                $producto_js->delete_producto_by_sku($p['sku']);
            }
        }
    }

    /**
     * cantidad de prodcutos alojados en bsale
     */
    public function count()
    {

        $url = BSALE_PRODUCTOS_COUNT_URL;
        $response_array = $this->get($url);

        //  Funciones::print_r_html( "count() productos $url" );

        return isset($response_array['count']) ? $response_array['count'] : -1;
    }

    /**
     * {
      "href": "https://api.bsale.cl/v1/variants.json",
      "count": 3,
      "limit": 25,
      "offset": 0,
      "items": [
      {
      "href": "https://api.bsale.cl/v1/variants/500.json",
      "id": 500,
      "description": "gap",
      "unlimitedStock": 0,
      "allowNegativeStock": 0,
      "state": 0,
      "barCode": "1351176376",
      "code": "1351176376", //este es el SKU!!
      "imagestionCenterCost": 0,
      "imagestionAccount": 0,
      "imagestionConceptCod": 0,
      "imagestionProyectCod": 0,
      "imagestionCategoryCod": 0,
      "imagestionProductId": 0,
      "serialNumber": 0,
      "prestashopCombinationId": 0,
      "prestashopValueId": 0,
      "product": {
      "href": "https://api.bsale.cl/v1/products/150.json",
      "id": "150"
      },
      "attribute_values": {
      "href": "https://api.bsale.cl/v1/variants/500/attribute_values.json"
      },
      "costs": {
      "href": "https://api.bsale.cl/v1/variants/500/costs.json"
      }
      },
     * @param type $producto_id
     * @return type
     */
    public function get_variantes_producto($producto_id)
    {
        $url = sprintf(BSALE_PRODUCTO_VARIANTES_URL, $producto_id);
        $response_array = $this->get($url);


        if( isset($response_array['items']) )
        {
            $response_array = $response_array['items'];
        }
        // Funciones::print_r_html($response_array, "get_variantes_producto( $producto_id ): $url");
        return $response_array;
    }

    /**
     * devuelve datos de una unica variante desde Bsale
     */
    public function get_variante($variante_id, $include_av_cost = false)
    {
        $url = sprintf(BSALE_VARIANTE_URL, $variante_id);
        $response_array = $this->get($url);
        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html("get_variante($variante_id), $url");
        }

        //debo incluir el costo de la variacion?
        if( $include_av_cost )
        {
            $response_cost = $this->get_variante_average_cost($variante_id);
            $response_array['costs_variation'] = $response_cost;
        }
        return $response_array;
    }

    public function get_variante_average_cost($variante_id)
    {
        $url = sprintf(BSALE_VARIANTE_COSTS_URL, $variante_id);
        $response_array = $this->get($url);

        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html("get_variante_average_cost($variante_id), $url");
        }
        return $response_array;
    }

    /**
     * obtiene datos del prodcuto desde Bsale
     * @param type $producto_id
     * @return type
     */
    public function get_producto($producto_id)
    {
        $url = sprintf(BSALE_PRODUCTO_DETALLE_URL, $producto_id);
        $response_array = $this->get($url);

        return $response_array;
    }

    /**
     * devuelve tipo dep roducto from bsale
     * @param type $type_producto_id
     * @return type
     */
    public function get_producto_type($type_producto_id)
    {
        $url = sprintf(BSALE_PRODUCTO_TYPE_URL, $type_producto_id);
        $response_array = $this->get($url);

        return $response_array;
    }

    public function get_producto_type_from_table($type_producto_id)
    {
        $tbl = new TipoProductosTable();
        $result = $tbl->get_tipo($type_producto_id);

        //si no está en la tabla, lo busco desde Bsale
        if( !isset($result['id']) )
        {
            $nuevo_tipo = $this->get_producto_type($type_producto_id);
            //si existe en Bsale, lo agrego a la tabla
            if( isset($nuevo_tipo['name']) )
            {
                $tbl->add($nuevo_tipo);
                $result = $nuevo_tipo;
            }
            else
            {
                //este tipo no existe en bsale
                $result = null;
            }
        }
        return $result;
    }

    public function get_producto_sku($producto_id)
    {
        //obtengo las variantes para pillar el sku
        $response_array = $this->get_variantes_producto($producto_id);

        $sku = null;
        if( !empty($response_array) && count($response_array) > 0 )
        {
            $response_array = $response_array[0];
            $sku = isset($response_array['code']) ? $response_array['code'] : null;
            // Funciones::print_r_html(null, "get_producto_sku( $producto_id ): $sku");
        }
        unset($response_array);

        return $sku;
    }

    public function get_producto_sku_by_ean($ean)
    {
        $url = BSALE_VARIANTES_URL . "?barcode=$ean";

        Funciones::print_r_html("get_producto_sku_by_ean: $url");
        $response_array = $this->get($url);


        if( isset($response_array['items']) )
        {
            $response_array = $response_array['items'];
        }
        //   Funciones::print_r_html($response_array, "get_variantes_producto( $producto_id )");
        return $response_array;
    }

    /**
     * get stock de variante (aunque diga: de producto)
     * {
      "href": "https://api.bsale.cl/v1/stocks.json",
      "count": 1049,
      "limit": 2,
      "offset": 0,
      "items": [
      {
      "href": "https://api.bsale.cl/v1/stocks/629.json",
      "id": 629,
      "quantity": 60.36,
      "quantityReserved": 0.0,
      "quantityAvailable": 60.36,
      "variant": {
      "href": "https://api.bsale.cl/v1/variants/351.json",
      "id": "351"
      },
      "office": {
      "href": "https://api.bsale.cl/v1/offices/2.json",
      "id": "2"
      }
      },
      {
      "href": "https://api.bsale.cl/v1/stocks/630.json",
      "id": 630,
      "quantity": 0.0,
      "quantityReserved": 0.0,
      "quantityAvailable": 0.0,
      "variant": {
      "href": "https://api.bsale.cl/v1/variants/351.json",
      "id": "351"
      },
      "office": {
      "href": "https://api.bsale.cl/v1/offices/1.json",
      "id": "1"
      }
      }
      ]
      }
     * @param type $producto_sku
     * @return type
     */
    public function get_stock_producto($producto_sku, $officeid = null, $variantid = null)
    {
        if( $officeid == null )
        {
            $officeid = Funciones::get_matriz_bsale();
        }

        $producto_sku = trim($producto_sku);
        $producto_sku = urlencode($producto_sku);

        if( empty($producto_sku) && empty($variantid) )
        {
            return -1;
        }

        if( defined('BSALE_IDENTIFICADOR_PRODUCTO') && BSALE_IDENTIFICADOR_PRODUCTO === 'ean' )
        {
            $ean = true;
        }
        else
        {
            $ean = false;
        }

        $param = $ean ? 'barcode' : 'code';

        //si no viene $variantid, fiultro por sku o barCode
        if( empty($variantid) )
        {
            $url = BSALE_PRODUCTO_STOCK_URL . "?$param=$producto_sku&officeid=$officeid";
        }
        //si viene, prefiero $variantid
        else
        {
            $url = BSALE_PRODUCTO_STOCK_URL . "?variantid=$variantid&officeid=$officeid";
        }

        $i = 0;
        //repito dos veces, en caso de que encuentre stock <0
        do
        {

            $response_array = $this->get($url);

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html($response_array, "get_stock_producto( $producto_sku, $officeid, $variantid ), url= '$url'");
            }

            if( isset($response_array['items']) )
            {
                $response_array = $response_array['items'];
                if( count($response_array) > 0 )
                {
                    $response_array = $response_array[0];
                }
            }
            //xxx dejar stock en 0
            $stock = isset($response_array['quantityAvailable']) ? $response_array['quantityAvailable'] : -1;

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("get_stock_producto( $producto_sku, stock es '$stock'");
            }

            if( $stock != -1 )
            {
                break;
            }
            $i++;
            sleep(1);
        }
        while( $i < 1 );

        unset($response_array);
        return $stock;
    }

    /**
     * 
     * 
     * @param type $producto_sku
     * @param type $officeid
     * @return type
     */
    public function get_precio_producto($producto_sku, $lista_precios = null, $variacion_id = null)
    {
        $producto_sku = trim($producto_sku);

        $lp = Funciones::get_lp_bsale();
        //no tiene lp asignada
        if( $lp <= 0 )
        {
            return -1;
        }
        $producto_sku = urlencode($producto_sku);

        $my_url = Funciones::get_lp_url_bsale(); //&officeid=$officeid

        if( $lista_precios && $lista_precios == Funciones::get_lp_oferta_bsale() )
        {
            $my_url = Funciones::get_url_lp_especial(); //&officeid=$officeid
        }
        elseif( $lista_precios && $lista_precios == BSALE_LISTA_PRECIOS_ESPECIALES_2 )
        {
            $my_url = BSALE_PRODUCTO_PRECIO_ESPECIAL2_URL; //&officeid=$officeid
        }
        elseif( $lista_precios && $lista_precios == BSALE_LISTA_PRECIOS_ESPECIALES_3 )
        {
            $my_url = BSALE_PRODUCTO_PRECIO_ESPECIAL3_URL; //&officeid=$officeid
        }
        elseif( $lista_precios && $lista_precios == BSALE_LISTA_PRECIOS_ESPECIALES_4 )
        {
            $my_url = BSALE_PRODUCTO_PRECIO_ESPECIAL4_URL; //&officeid=$officeid
        }
        elseif( $lista_precios && $lista_precios == BSALE_LISTA_PRECIOS_ESPECIALES_5 )
        {
            $my_url = BSALE_PRODUCTO_PRECIO_ESPECIAL5_URL; //&officeid=$officeid
        }

        $url = $my_url . "?code=$producto_sku"; //&officeid=$officeid


        $response_array = $this->get($url);



        if( isset($response_array['items']) )
        {
            $response_array = $response_array['items'];
            if( count($response_array) > 0 )
            {
                $response_array = $response_array[0];
            }
        }

        //si no se pudo, pruebo con el id
        if( !isset($response_array['variantValueWithTaxes']) && $variacion_id != null )
        {
            $url = $my_url . "?variantid=$variacion_id";
            $response_array = $this->get($url);

            //todo de nuevo
            if( isset($response_array['items']) )
            {
                $response_array = $response_array['items'];


                if( count($response_array) > 0 )
                {
                    $response_array = $response_array[0];
                }
            }
        }
        if( $lista_precios == 6 )
        {
            Funciones::print_r_html($response_array, "get_precio_producto( sku=$producto_sku, var id=$variacion_id ), url='$url'");
        }
        //xxx dejar precio en 0
        $stock = isset($response_array['variantValueWithTaxes']) ? (int) $response_array['variantValueWithTaxes'] : -1;

        unset($response_array);
        return $stock;
    }

    public function get_variaciones_docto($docto_bsale_id)
    {
        //url para obrtener listado de variaciones compradas 
        $url = sprintf(BSALE_DOCUMENTO_STOCK_URL, $docto_bsale_id);
        $response_array = $this->get($url);

        Funciones::print_r_html($response_array, "get_variaciones_docto($docto_bsale_id) $url");

        if( isset($response_array['items']) )
        {
            $response_array = $response_array['items'];
            if( count($response_array) > 0 )
            {
                $response_array = $response_array[0];
            }
        }
        return $response_array;
    }

    /**
     * $array_datos['stock_control']  se usa en caso de que el producto sea un pack
     * en ese caso, se guardan las variantes que forman el pack en formato json, para luego 
     * detectar la cantidad de ese producto
     * @param type $response_array
     */
    public function save_productos_to_local_db($response_array)
    {
        $productos_db = new ProductosStockBsale();

        $len = count($response_array);
        for( $i = 0; $i < $len; $i++ )
        {
            $r = $response_array[$i];

            //los que empiezan con 'gama', no                    
            $start = substr($r['name'], 0, 4);
            if( strcasecmp($start, 'gama') == 0 )
            {
                continue;
            }

            $r['name'] = !empty($r['name']) ? $r['name'] : ' ';
            //dexcripcio no debe ser null ni '_'
            $r['description'] = !empty($r['description']) ? $r['description'] : '';
            $r['description'] = $r['description'] === '_' ? ' ' : $r['description'];

            //solo prodcutos activos state, estado del producto activo(0) o inactivo (1) (Boolean).
            if( !isset($r['pack_details']) && ( $r['state'] == 1 || $r['state'] == true) )
            {
                continue;
            }

            $array_datos = array();
            $array_datos['producto_bsale_id'] = $r['id'];
            $array_datos['name'] = $r['name'];
            $array_datos['description'] = $r['description'];
            $array_datos['centro_costo'] = $r['costCenter'];
            $array_datos['stock_control'] = 0; //0 es por default $r['stockControl'];
            $array_datos['state'] = $r['state'];
            $array_datos['sku'] = null; //$r['sku'];
            $array_datos['precio'] = 0; //$r['precio'];
            $array_datos['stock'] = isset($r['product_type']['id']) ? $r['product_type']['id'] : 0; //stock producto es el tipo
            //Funciones::print_r_html("save_productos_to_local_db: {$array_datos['producto_bsale_id']} {$array_datos['name']}");

            /* if( $array_datos['producto_bsale_id']===232)
              {
              Funciones::print_r_html($r, "pack de prueba 1538080074258");
              } */
            //es pack?
            if( isset($r['pack_details']) )
            {
                $str_pack = $r['pack_details'];
                $json_pack = json_encode($str_pack, JSON_UNESCAPED_UNICODE);
                $array_datos['stock_control'] = $json_pack;

                Funciones::print_r_html("producto {$array_datos['name']} es pack (no tiene sku, pues lo tienen las variantes)");
            }

            $productos_db->add($array_datos);

            unset($array_datos);
        }
    }

    public function loadDatosEnTablaProducto()
    {
        $stock_db = new ProductosStockBsale();
        $stock_db->loadDatosEnTablaProducto();
    }

    /**
     * 
     * @param type $show    
     * @return type
     */
    public function get_all($show = false, $cantidad = null)
    {
        //limpio tabla de stcok
        $stock_db = new ProductosStockBsale();
        $stock_db->clear_all();



        $limit = 50; //xxx sacar, cambiar por 200
        $offset = 0;
        $total = $this->count();

        if( $show && $cantidad > 0 )
            $total = $cantidad;


        if( $total <= 0 )
        {
            Funciones::print_r_html("No hay lista de productos");
            return;
        }
        Funciones::print_r_html("Productos Bsale get_all: $total productos...");
        //$total = 300;

        $respuesta = array();

        //recorro y voy guardando en la db temporal
        for(; $total > 0; $total -= $limit )
        {
            $url = sprintf(BSALE_PRODUCTOS_LISTADO_URL, $limit, $offset);
            $response_array = $this->get($url);

            $this->save_productos_to_local_db($response_array['items']);


            //  Funciones::print_r_html( "Buscando productos $url offset: $offset, cantidad: $limit" );

            $offset += $limit;

            if( $show )
            {
                $respuesta = array_merge($respuesta, $response_array['items']);
            }
            unset($response_array);
        }
        return $respuesta;
    }

    public function get_all_with_data()
    {
        //traigo desde bsale
        $this->get_all();
        //los saco dela db para saber sus datos
        $productos_db = new ProductosStockBsale();
        $productos_from_local_db = $productos_db->get_all();

        $arraux = array();
        //recorro el arreglo para obtener sku, precio y stock
        $len = 10; //count( $productos_from_local_db );
        for( $i = 0; $i < $len; $i++ )

        //  foreach ( $respuesta as $r )
        {
            $r = $productos_from_local_db[$i];

            $producto_id = $r['producto_bsale_id'];
            $producto_sku = $this->get_producto_sku($producto_id);

            //si no hay sku, no puiedo consultar lo demas
            if( empty($producto_sku) )
            {
                // Funciones::print_r_html(null, "producto $producto_id no tiene sku");
                $arraux[] = $r;
                continue;
            }

            // Funciones::print_r_html(null, "producto $producto_id tiene sku $producto_sku");
            $producto_precio = $this->get_precio_producto($producto_sku);
            $producto_stock = $this->get_stock_producto($producto_sku);

            $r['sku'] = $producto_sku;
            $r['precio'] = $producto_precio;
            $r['stock'] = $producto_stock;

            $productos_from_local_db[$i] = $r;
            //los guardo en la db
            // $update_str = " sku = '$producto_sku', precio = '$producto_precio', stock = '$producto_stock' ";
            //  $productos_db->update_producto( $producto_id, $update_str );
        }

        return $productos_from_local_db;
    }

    public function create($nombre, $description, $ledgerAccount = '', $costCenter = 23, $stockControl = 1, $allowDecimal = 0)
    {
        $url = BSALE_PRODUCTO_POST_URL;

        $old_timezone = date_default_timezone_get();

        if( Funciones::get_pais() === 'PE' )
        {
            $timezone = 'America/Lima';
        }
        else
        {
            $timezone = 'America/Santiago';
        }

        date_default_timezone_set($timezone);
        ini_set("date.timezone", $timezone);


        $hoy = date('Y-m-d');
        $gmt_date = strtotime($hoy);
        $gmt_date_expiracion = $gmt_date;
        $hoy_from_timestamp = date('Y-m-d', $gmt_date);

        date_default_timezone_set($old_timezone);
        ini_set("date.timezone", $old_timezone);

        $arr_datos = array(
            'name' => $nombre,
            'description' => $description,
            'allowDecimal' => $allowDecimal,
            'ledgerAccount' => $ledgerAccount,
            'costCenter' => $costCenter,
            'stockControl' => $stockControl
        );

        $result = $this->post($url, $arr_datos);

        return $result;
    }

    public function deleteProducto($producto_id)
    {

        $url = sprintf(BSALE_PRODUCTO_DELETE_URL, $producto_id);

        $arr_datos = array(
            'id' => $producto_id,
                /* 'name' => $nombre,
                  'description' => $description,
                  'allowDecimal' => $allowDecimal,
                  'ledgerAccount' => $ledgerAccount,
                  'costCenter' => $costCenter,
                  'stockControl' => $stockControl */
        );

        $result = $this->delete($url, null);

        return $result;
    }

    public function edit($producto_id, $nombre, $description, $ledgerAccount = '', $costCenter = 23, $stockControl = 1, $allowDecimal = 0)
    {
        $url = sprintf(BSALE_PRODUCTO_PUT_URL, $producto_id);

        $hoy = date('Y-m-d');
        $gmt_date = strtotime($hoy);
        $gmt_date_expiracion = $gmt_date;

        $arr_datos = array(
            'id' => $producto_id,
            'name' => $nombre,
            'description' => $description,
            'allowDecimal' => $allowDecimal,
            'ledgerAccount' => $ledgerAccount,
            'costCenter' => $costCenter,
            'stockControl' => $stockControl
        );

        $result = $this->put($url, $arr_datos);

        return $result;
    }

    public function stockRestar($sku, $cant_a_restar)
    {
        
    }

    public function compareProductosBsaleToJS()
    {
        Funciones::print_r_html("compareProductosBsaleToJS: inicio");
        //voy guardanmdo los resultados de la sync
        $result_array = array();
        $producto_js = new ProductosJumpsellerTable();

        //extraigo listado de productos existentes en jumpseller
        $js = new JumpSellerProduct();
        $js_products = $js->get_all_by_sku_index();

        //productos de bsale
        $bsale = new ProductosStockBsale();
        $bsale_products = $bsale->get_all_by_sku_index();

        //recorro los productos de bsale y los voy comparando con los de js
        $l = count($bsale_products);
        Funciones::print_r_html("compareProductosBsaleToJS: Total productos bsale a sync: $l");

        foreach( $bsale_products as $sku => $p )
        {
            //si este producto existe en js, veo si ha cambiado
            if( isset($js_products[$sku]) )
            {
                $this->updateProductoJumpseller($p, $js_products[$sku]);
                $producto_js->delete_producto_by_sku($sku);
                //lo remuevo del listado de js, pues ya esta revisado
                unset($js_products[$sku]);
            }
            //si no existe, debo agregarlo
            else
            {
                $this->addProductoJumpseller($p);
                $producto_js->delete_producto_by_sku($sku);
            }
        }

        Funciones::print_r_html("compareProductosBsaleToJS: fin");
        return $result_array;
    }

    public function changeStateProductoBsale($variante_id, $state)
    {
        $prodcuto_bsale = new SkuProductosTable();
        $update_str = " estado_para_enviar = '$state' ";
        $prodcuto_bsale->update($variante_id, $update_str);
    }

    public function updateProductoJumpseller($bsale_producto, $js_producto, $status = 'available')
    {
        $precio = $bsale_producto['precio'];
        $stock = $bsale_producto['stock'];
        $sku = $bsale_producto['sku'];
        $variante_id = $bsale_producto['variante_id'];
        $estado = $js_producto['state'];

        $stock == ($stock > 1) ? $stock - 1 : $stock;

        $estado = ($estado == 1) ? 'available' : 'disabled';

        //lo marco como enviado
        $prodcuto_bsale = new SkuProductosTable();

        $prodcuto_bsale->delete($variante_id);

        //rincon fotográfico, precios <=1 que no se actualicen datos
        if( $precio <= 1 )
        {
            Funciones::print_r_html("ProductoOpenCart::updateProducto: producto ($sku) precio bsale= $precio <=1, se omite actualizacion");
            return false;
        }
        //$prodcuto_bsale->update_producto( $bsale_producto['producto_bsale_id'], $update_str );
        //veo si es necesario actualizar el producto o no
        //si tiene los mismos datos, no lo actualizo
        if( isset($bsale_producto['nombre_producto']) && strcasecmp($bsale_producto['nombre_producto'], $js_producto['name']) == 0 &&
                /* strcasecmp( $bsale_producto['description'], $js_producto['description'] ) == 0 && */
                (int) $bsale_producto['precio'] == (int) $js_producto['precio'] &&
                (int) $bsale_producto['stock'] == (int) $js_producto['stock'] &&
                strcasecmp($estado, $status) == 0 )
        {
            Funciones::print_r_html("updateProductoJumpseller: ($sku) {$bsale_producto['nombre_producto']} sin cambios, se omite ");
            return true;
        }

        $nombre_prod = trim($bsale_producto['nombre_producto'] . ' ' . $bsale_producto['descripcion']);

        if( empty($nombre_prod) )
        {
            return;
        }
        $status = $stock <= 0 ? 'disabled' : 'available';
        //formato de producto de js
        $arr_datos['product'] = array(
            'name' => $bsale_producto['nombre_producto'] . ' ' . $bsale_producto['descripcion'],
            //   'description' => $bsale_producto['descripcion'],
            'price' => $precio,
            'stock' => $stock,
            'status' => $status,
        );

        $producto_id = $js_producto['producto_jumpseller_id'];

        $js = new JumpSellerProduct();
        $js->update_product($producto_id, $arr_datos);
        Funciones::print_r_html("update js prod: $sku-{$bsale_producto['nombre_producto']}, "
                . "$ $precio bsale, $ {$js_producto['precio']} js,"
                . " cant: bsale $stock, js {$js_producto['stock']}");
    }

    public function addProductoJumpseller($bsale_producto)
    {

        $bsale_producto['nombre_producto'] = empty($bsale_producto['nombre_producto']) ? 'falta nombre' : $bsale_producto['nombre_producto'];

        $precio = $bsale_producto['precio'];
        $stock = (int) $bsale_producto['stock'];
        $variante_id = $bsale_producto['variante_id'];

        $stock == ($stock > 1) ? $stock - 1 : $stock;

        //lo marco como enviado
        $prodcuto_bsale = new SkuProductosTable();

        $prodcuto_bsale->delete($variante_id);

        $nombre = $bsale_producto['nombre_producto'] . ' ' . $bsale_producto['descripcion'];

        if( empty($nombre) || $stock <= 0 || $precio <= 0 )
            return;

        //formato de producto de js
        $arr_datos['product'] = array(
            'name' => $nombre,
            'description' => $bsale_producto['descripcion'],
            'price' => $precio,
            'stock' => $stock,
            'status' => 'available',
            'sku' => $bsale_producto['sku'],
        );

        //categoria por default para los prod recien llegados
        $arr_datos['product']['categories'] = array(
            array( 'id' => JUMPSELLER_CATEGORIA_RECIEN_LLEGADOS ) );

        $js = new JumpSellerProduct();
        //¿existe este producto en js?
        $js_producto_existente = $js->get_producto_by_sku($bsale_producto['sku']);
        if( $js_producto_existente !== false )
        {
            Funciones::print_r_html("addProductoJumpseller ERROR: ({$bsale_producto['sku']}) {$bsale_producto['nombre_producto']}ya existe, lo envío a update");

            $js_producto = array(
                'state' => $js_producto_existente['status'],
                'precio' => $js_producto_existente['price'],
                'stock' => $js_producto_existente['stock'],
                'producto_jumpseller_id' => $js_producto_existente['id']
            );
            $this->updateProductoJumpseller($bsale_producto, $js_producto);
            return;
        }
        $js->add_product($arr_datos);
        Funciones::print_r_html("addProductoJumpseller: ({$bsale_producto['sku']}) {$bsale_producto['nombre_producto']}, $ $precio, cant: $stock");
    }

    public function is_product_to_skip($sku = null)
    {
        $sku_arr = Funciones::get_skus_to_skip();

        if( empty($sku_arr) || !is_array($sku_arr) )
        {
            return false;
        }
        //recorro cada coincidencia
        foreach( $sku_arr as $text )
        {
            if( empty($text) )
            {
                continue;
            }
            $len = strlen($text);

            $start = substr($sku, 0, $len);
            if( strcasecmp($start, $text) == 0 )
            {
                if( isset($_REQUEST['param']) )
                {
                    Funciones::print_r_html($sku_arr, "is_product_to_skip($sku), skip sku='$sku'. Prefijos prohibidos:");
                }
                //skip product
                return true;
            }
        }

        return false;
    }

    public function update_variant_js($data, $access_array = null)
    {
        $nombre = $data['product']['name'] . ' ' . $data['variant_description'];
        $precio = $data['variant_price']['price'];
        $stock = $data['variant_stock']['variant_total_stock'];
        $variant_id = $data['variant_id'];

        if( defined('BSALE_IDENTIFICADOR_PRODUCTO') && BSALE_IDENTIFICADOR_PRODUCTO === 'ean' )
        {
            $sku = $data['variant_barcode'];
        }
        else
        {
            $sku = $data['variant_code'];
        }

        //datos para archivo log
        $hoy = date('Y-m-d');
        $basename = "update_variacion_jumpseller-$hoy.log";

        if( $this->is_product_to_skip($nombre) )
        {
            $title = date('d-m-Y H:i:s') . " update_variant_js, (id bsale=$variant_id) sku=$sku, nombre '$nombre' empieza con prefijo, omito producto";
            Funciones::print_r_html($title);
            $this->logFile($basename, null, null, $title);

            return false;
        }

        //resto stock dede Bsale
        if( defined('BSALE_RESTAR_A_STOCK_BSALE') && BSALE_RESTAR_A_STOCK_BSALE > 0 )
        {
            $stock -= BSALE_RESTAR_A_STOCK_BSALE;
            $stock = ($stock < 0) ? 0 : $stock;

            $title = date('d-m-Y H:i:s') . " update_variant_js, (id bsale=$variant_id) sku=$sku, resto " . BSALE_RESTAR_A_STOCK_BSALE . ", nuevo stock $stock";
            Funciones::print_r_html($title);
            $this->logFile($basename, null, null, $title);
        }

        //salto prodcutos con precio menor a        
        if( defined('BSALE_SKIP_UPDATE_PRECIOS_LESS_THAN') && BSALE_SKIP_UPDATE_PRECIOS_LESS_THAN > 0 )
        {
            if( $precio <= BSALE_SKIP_UPDATE_PRECIOS_LESS_THAN )
            {
                $title = date('d-m-Y H:i:s') . " update_variant_js, (id bsale=$variant_id) sku=$sku, precio $precio <= " . BSALE_SKIP_UPDATE_PRECIOS_LESS_THAN . ", no se actualiza variacion";
                Funciones::print_r_html($title);
                $this->logFile($basename, null, null, $title);
                return false;
            }
        }

        $status = ($stock <= 0) ? 'disabled' : 'available'; //not-available
        //formato de producto de js
        $arr_datos['product'] = array(
            'name' => $nombre,
            'description' => '',
            'price' => $precio,
            'stock' => $stock,
            'status' => $status,
            'sku' => $sku,
            'stock_unlimited' => false,
        );



        $js = new JumpSellerProduct();

        //¿existe este producto en js?
        $js_producto_existente = $js->get_producto_by_sku($sku, $access_array);

        $title = date('d-m-Y H:i:s') . " update_variant_js: producto existe? sku=$sku. Respuesta:";
        $this->logFile($basename, $js_producto_existente, null, $title);

        //hubo error al preguntar?
        if( $js_producto_existente && isset($js_producto_existente['error']) )
        {
            return false;
        }

        //update product
        if( $js_producto_existente !== false )
        {
            Funciones::print_r_html("update_variant_js ($sku) $nombre ya existe, actualizo");

            $product_js_id = $js_producto_existente['id'];

            $result = $js->update_product($product_js_id, $arr_datos, $access_array);

            $title = date('d-m-Y H:i:s') . " update_variant_js: actualizo variacion id=$product_js_id (id bsale=$variant_id) ($sku) $nombre, precio $ $precio, stock: $stock";
            Funciones::print_r_html($title);
            $this->logFile($basename, $arr_datos, null, $title);
            $this->logFile($basename, $result, null, '----update producto, respuesta de JS:');

            //en caso de que el producto no exista
            if( isset($result['errors']) && $result['curl_code'] == 404 )
            {
                //dejo que lo cree como nuevo
            }
            else
            {
                return $result;
            }
        }

        //add product
        if( $access_array != null && isset($access_array['CATEG']) && !empty($access_array['CATEG']) )
        {
            $categ_nuevos = $access_array['CATEG'];
        }
        else
        {
            $categ_nuevos = JUMPSELLER_CATEGORIA_RECIEN_LLEGADOS;
        }
        //categoria por default para los prod recien llegados
        $arr_datos['product']['categories'] = array(
            array( 'id' => $categ_nuevos ) );

        //variante siempre se agrega como disabled, hasta que suban las fotos y etc
        $arr_datos['product']['status'] = 'disabled';

        $result = $js->add_product($arr_datos, $access_array);

        $title = date('d-m-Y H:i:s') . " update_variant_js: agrego variacion: (id bsale=$variant_id) ($sku) $nombre, precio $ $precio, stock: $stock";
        Funciones::print_r_html($title);
        $this->logFile($basename, $arr_datos, null, $title);


        return $result;
    }

    public function get_stock_producto_sucursales($sku_or_ean, $variantid = null)
    {
        //listado de sucursales, la primera es la matriz
        $otras_sucursales = explode(',', Funciones::get_sucursales_bsale());

        $sucursales_array = array_merge(array( Funciones::get_matriz_bsale() ), $otras_sucursales);

        $sucursales_stock = array();
        foreach( $sucursales_array as $sucursal_id )
        {
            if( empty($sucursal_id) )
            {
                continue;
            }
            $stock = $this->get_stock_producto($sku_or_ean, $sucursal_id, $variantid);
            $sucursales_stock[$sucursal_id] = $stock;
        }
        return $sucursales_stock;
    }

    /**
     * devuelve el proximo numero de serie disponible para la variante indicada
     * @param type $variante_id
     * @param type $office_id
     * @return type
     */
    public function get_serie_variante($variante_id, $office_id = null)
    {
        $office_id = $office_id == null ? Funciones::get_matriz_bsale() : $office_id;

        $url = sprintf(BSALE_SERIALS_URL, $variante_id) . "?officeid={$office_id}";
        $response = $this->get($url);
        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html($response, "get_serie_variante($variante_id, $office_id) url = '$url'");
        }
        return $response;
    }

    /**
     * deveulve el sgte numero de serie disponible para la variacion indicada
     * @param type $variante_id
     * @param type $office_id
     */
    public function get_next_serie_variante($variante_id, $quantity = 1, $office_id = null)
    {
        $resp = $this->get_serie_variante($variante_id, $office_id);

        //veo si hay serie disponibles
        if( !isset($resp['items']) || count($resp['items']) <= 0 )
        {
            return null;
        }

        $arr_serials = array();
        $serials_count = 0;

        foreach( $resp['items'] as $s )
        {
            if( $s['stockAvailable'] > 0 && !empty($s['serialNumber']) )
            {
                $arr_serials[] = $s['serialNumber'];
                $serials_count++;
            }
            if( $serials_count >= $quantity )
            {
                break;
            }
        }
        //devuelvo string con nros de serie
        if( count($arr_serials) > 0 )
        {
            $seriales_txt = $arr_serials; //implode(',', $arr_serials);
        }
        else
        {
            $seriales_txt = null;
        }

        return $seriales_txt;
    }

}
