<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of PreciosProductosBsale
 *
 * @author angelorum
 */
class PreciosProductosBsale extends DocumentoAbstracto
{

    public function count()
    {

        $url = Funciones::get_lp_url_bsale() . '?limit=1&offset=0';
        $response_array = $this->get($url);

        //   Funciones::print_r_html( $response_array, $url );
        //   die();
        return isset($response_array['count']) ? $response_array['count'] : -1;
    }

    public function get_all_precios_productos()
    {
        $tabla = new PreciosProductosTable();
        $tabla->clear_all();

        $limit = 50;
        $offset = 0;
        $total = $this->count();

        if( $total <= 0 )
        {
            //Funciones::print_r_html( "No hay lista de precios" );
            return;
        }
        else
        {
            Funciones::print_r_html("get_all_precios_productos: descargando $total precios...");
        }
        //  $total = 300;
        //recorro y voy guardando en la db temporal
        for(; $total > 0; $total -= $limit )
        {
            $url = Funciones::get_lp_url_bsale() . "?limit=$limit&offset=$offset";
            //   Funciones::print_r_html( "get_all_precios_productos: $url" );

            $response_array = $this->get($url);
            if( isset($response_array['items']) )
            {
                $response_array = $response_array['items'];
            }

//devuelvo un array con con [producto_id]=>sku
            $arraux = array();
            $len = count($response_array);
            for( $i = 0; $i < $len; $i++ )
            {
                if( !isset($response_array[$i]) )
                {
                    Funciones::print_r_html($response_array, "get_all_precios_productos: no se encuentra offset $i");
                    continue;
                }
                $v = $response_array[$i];

                //requiero este dato
                if( !isset($v['variant']['id']) )
                {
                    Funciones::print_r_html(null, "no tiene variant id");
                    continue;
                }
                $variante_id = $v['variant']['id'];
                $precio = $v['variantValueWithTaxes'];
                //   $arraux[$producto_id] = $precio;

                $array_datos = array();
                $array_datos['variante_id'] = $variante_id;
                $array_datos['precio'] = $precio;
                $tabla->add($array_datos);
            }


            $offset += $limit;

            unset($response_array);
        }
        return true;
    }

    /*
     * listas de precio
     */

    public function count_lp()
    {

        $url = BSALE_LISTAS_PRECIO_URL . '?limit=1&offset=0';
        $response_array = $this->get($url);

//        Funciones::print_r_html( $response_array, $url );
        //   die();
        return isset($response_array['count']) ? $response_array['count'] : -1;
    }

    public function get_all_listas_de_precios($show = false)
    {
        // $tabla = new PreciosProductosTable();
        // $tabla->clear_all();

        $respuesta = array();

        $limit = 50;
        $offset = 0;
        $total = $this->count_lp();

        if( $total <= 0 )
        {
            //Funciones::print_r_html( "No hay lista de precios" );
            return array();
        }
        //  $total = 300;
        //recorro y voy guardando en la db temporal
        for(; $total > 0; $total -= $limit )
        {
            $url = BSALE_LISTAS_PRECIO_URL . "?limit=$limit&offset=$offset";
            $response_array = $this->get($url);
            if( isset($response_array['items']) )
            {
                $response_array = $response_array['items'];
            }

            if( $show )
            {
                Funciones::print_r_html($response_array, "get_all_listas_de_precios: $url");
            }

            if( !is_array($response_array) )
            {
                return $respuesta;
            }
            $len = count($response_array);
            for( $i = 0; $i < $len; $i++ )
            {
                $v = $response_array[$i];
                $id = $v['id'];
                $respuesta[] = $v;
                //$tabla->add( $array_datos );
            }


            $offset += $limit;

            unset($response_array);
        }
        return $respuesta;
    }

}
