<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SkuProductosTable
 *
 * @author angelorum
 */
class SkuProductosTable extends OCDB
{

    function __construct()
    {
        parent::__construct();
    }

    public function clear_all($load_in_new_table = false)
    {
        $conn = $this->conectar();
        if( $conn == false )
        {
            return false;
        }

        try
        {
            $table = ($load_in_new_table) ? $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE2 : $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE;

            $sql = "TRUNCATE TABLE '$table';";
            if( INTEGRACION_SISTEMA === 'woocommerce' )
            {
                global $wpdb;
                $Result = $wpdb->query($sql);
            }
            else
            {
                $Result = mysqli_query($conn, $sql);
            }
        }
        catch( Exception $exc )
        {
            //  mysqli_rollback( $conn );
            echo $exc->getTraceAsString();
        }
    }

    public function add($array_datos, $load_in_new_table = false)
    {
        $conn = $this->conectar();
        if( $conn == false )
        {
            return -1;
        }

        $producto_bsale_id = $array_datos['producto_bsale_id'];
        $sku = $array_datos['sku'];
        $variante_id = $array_datos['variante_id'];

        $array_datos['description'] = str_replace('Â', '', $array_datos['description']);
        $array_datos['description'] = utf8_decode($array_datos['description']);


        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            $description = esc_sql($array_datos['description']);
        }
        else
        {

            $description = mysqli_real_escape_string($conn, $array_datos['description']);
        }

        $description = $description === '_' ? ' ' : $description;

        // Funciones::print_r_html("saco basura: $description");

        $dato1 = isset($array_datos['dato1']) ? $array_datos['dato1'] : null;
        $dato2 = isset($array_datos['dato2']) ? $array_datos['dato2'] : null;

        $table = ($load_in_new_table) ? $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE2 : $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE;

        //backward compatibility
        if( $dato1 != null )
        {
            $SQL = "INSERT INTO $table(producto_bsale_id, sku, variante_id, descripcion, dato1, dato2) "
                    . " VALUES ('$producto_bsale_id', '$sku', $variante_id, '$description', '$dato1', '$dato2' );";
        }
        else
        {
            $SQL = "INSERT INTO $table(producto_bsale_id, sku, variante_id, descripcion) "
                    . " VALUES ('$producto_bsale_id', '$sku', $variante_id, '$description' );";
        }

        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html($SQL, "add row to tablas de productos:");
        }

        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            global $wpdb;
            $Result = $wpdb->query($SQL);
        }
        else
        {
            $Result = mysqli_query($conn, $SQL);
        }


        return $Result;
    }

    public function update($variante_id, $update_str)
    {

        $sql = "update {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} set $update_str"
                . " WHERE variante_id = $variante_id ;";

        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }

        //Funciones::print_r_html("SkuProductosTable->update '$sql'");
        //  Funciones::print_r_html( $SQL, "guardarTransaccion:" );
        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            global $wpdb;
            $result = $wpdb->query($sql);
        }
        else
        {
            $result = mysqli_query($conn, $sql);
        }
        return $result;
    }

    public function update_por_producto_id($producto_id, $update_str)
    {

        $sql = "update {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} set $update_str"
                . " WHERE producto_bsale_id = $producto_id ;";

        Funciones::print_r_html($sql, "update_por_producto_id($producto_id):");

        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }

        $result = mysqli_query($conn, $sql);
        return $result;
    }

    /**
     * 
     * @param type $update_str
     * @param type $load_in_new_table
     * @return typeactualkiza prodcutos en masa segun el string
     */
    public function update_producto_str($update_str, $where, $load_in_new_table = false)
    {
        $table = ($load_in_new_table) ? $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE2 : $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE;

        $sql = "update $table set $update_str"
                . " WHERE $where;";

        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }

        Funciones::print_r_html("update_producto_str, sql= '$sql'");

        $result = mysqli_query($conn, $sql);
        return $result;
    }

    public function delete($variante_id, $load_in_new_table = false)
    {

        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }

        $table = ($load_in_new_table) ? $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE2 : $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE;

        $sql = "delete from $table WHERE variante_id = $variante_id ;";

        if( isset($_REQUEST['param']) )
        {
           // Funciones::print_r_html("delete variacion '$sql'");
        }
        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            global $wpdb;
            $result = $wpdb->query($sql);
        }
        else
        {
            $result = mysqli_query($conn, $sql);
        }

        return $result;
    }

    public function count_por_enviarJumpseller()
    {
        $sql = "select count(variante_id) as cantidad from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE};";
        // Funciones::print_r_html( "count_por_enviar: $sql" );
        $conn = $this->conectar();
        if( $conn == false )
            return;

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        $row = mysqli_fetch_assoc($result);
        $cantidad = (int) $row['cantidad'];

        mysqli_free_result($result);
        return $cantidad;
    }

    public function count_por_enviarMagento()
    {
        $sql = "select count(variante_id) as cantidad from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE};";
        // Funciones::print_r_html( "count_por_enviar: $sql" );
        $conn = $this->conectar();
        if( $conn == false )
            return;

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        $row = mysqli_fetch_assoc($result);
        $cantidad = (int) $row['cantidad'];

        mysqli_free_result($result);
        return $cantidad;
    }

    public function count_por_enviarOpenCart()
    {
        return $this->count_por_enviarMagento();
    }

    public function count_por_enviarWoocommerce()
    {
        return $this->count_por_enviarMagento();
    }

    public function get_all($fields = null)
    {
        $fields = empty($fields) ? ' * ' : $fields;
        $sql = "select $fields from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} order by producto_bsale_id;";

        $conn = $this->conectar();
        if( $conn == false )
            return;

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        while( $row = mysqli_fetch_assoc($result) )
        {
            $arr[] = $row;
        }
        mysqli_free_result($result);
        return $arr;
    }

    public function get_all_by_name($fields = null)
    {
        $fields = empty($fields) ? ' * ' : $fields;
        $sql = "select $fields from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} order by "
                . "nombre_producto, descripcion;";

        $conn = $this->conectar();
        if( $conn == false )
            return;

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        while( $row = mysqli_fetch_assoc($result) )
        {
            $arr[] = $row;
        }
        mysqli_free_result($result);
        return $arr;
    }

    public function get_by_variante_id($variante_id)
    {
        $sql = "select * from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} where variante_id = '$variante_id';";

        $conn = $this->conectar();
        if( $conn == false )
            return;

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        $row = mysqli_fetch_assoc($result);
        mysqli_free_result($result);
        return $row;
    }

}
