<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ProductosStockBsale
 *
 * @author angelorum
 */
class ProductosStockBsale extends OCDB
{

    function __construct()
    {
        parent::__construct();
    }

    /**
     * la tabla de productos bsale,oc_bsale_products, 
     * gurda en el parm stock el type product id
     * esta función lee el type id y guarda el nombre de este en
     * el campo descripción.
     * Saca el listado de types de la tabla local 'bsale_tipos_producto'
     */
    public function loadTiposEnTablaProducto()
    {
        $conn = $this->conectar();
        if( $conn == false )
        {
            die('loadTiposEnTablaProducto() error de conexion');
            return;
        }

        //agrego tipo de producto a nombre de producto en tabla de producto, antes de mover todo a talba bsale_sku_productos       
        $tipos_tbl = new TipoProductosTable();
        $tipos_arr = $tipos_tbl->get_all_array();

        Funciones::print_r_html($tipos_arr, "loadTiposEnTablaProducto(), tipos_tbl->get_all_array()");

        foreach( $tipos_arr as $t )
        {
            $tipo_id = $t['id'];
            $tipo_name = $t['name'];

            $sql = "update {$this->STOCK_PRODUCTOS_BSALE_TABLE} "
                    . "SET "
                    // . "SET name = CONCAT('$tipo_name ', name ),"
                    . "description = '$tipo_name ' "
                    . "WHERE "
                    . "stock = '$tipo_id';";

            Funciones::print_r_html("loadTiposEnTablaProducto(): '$sql'");

            if( !$result = mysqli_query($conn, $sql) )
            {
                die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
            }
        }
    }

    public function loadDatosEnTablaProducto()
    {
        $modo2 = ( defined('BSALE_MODO2') && BSALE_MODO2 === true ) ? true : false;



        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }

        $skutable = new SkuProductosTable();

        //paso precios a tabla de sku, bsale_sku_productos
        $sql = "select * from {$this->STOCK_PRECIOS_PRODUCTOS_BSALE_TABLE} ;";

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }

        while( $row = mysqli_fetch_assoc($result) )
        {
            $variante_id = $row['variante_id'];
            $precio = $row['precio'];
            $precio2 = $row['precio2'];
            $precio3 = $row['precio3'];
            $precio4 = $row['precio4'];
            $precio5 = $row['precio5'];
            $precio6 = $row['precio6'];

            $update_str = " precio='$precio', precio2='$precio2', precio3='$precio3', "
                    . "precio4='$precio4', precio5='$precio5', precio6='$precio6' ";
            $skutable->update($variante_id, $update_str);
        }
        mysqli_free_result($result);

        //para tabla stock, paso a tabla bsale_sku_productos ****
        $sql = "select * from {$this->STOCK_STOCK_PRODUCTOS_BSALE_TABLE} ;";

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        while( $row = mysqli_fetch_assoc($result) )
        {
            $variante_id = $row['variante_id'];
            $stock = $row['stock'];

            $update_str = " stock='$stock' ";
            $skutable->update($variante_id, $update_str);
        }
        mysqli_free_result($result);

        //ahora paso nombre de producto, paso a tabla bsale_sku_productos
        $sql = "select * from {$this->STOCK_PRODUCTOS_BSALE_TABLE} ;";

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        while( $row = mysqli_fetch_assoc($result) )
        {
            $producto_bsale_id = $row['producto_bsale_id'];
            $name = mysqli_real_escape_string($conn, $row['name']);

            //typo de producto en description
            if( INTEGRACION_SISTEMA === 'woocommerce' )
            {
                $description = esc_sql($row['description']);
            }
            else
            {
                $description = mysqli_real_escape_string($conn, $row['description']);
            }


            //debo agregar el tipo de prod al nombre de este?
            if( defined('ADD_TYPE_A_NOMBRE_PRODUCTO') && ADD_TYPE_A_NOMBRE_PRODUCTO == true )
            {
                if( strcasecmp($description, 'sin tipo') != 0 )
                {
                    $name = "$description $name";
                }
            }

            $update_str = " nombre_producto='$name' ";
            $skutable->update_por_producto_id($producto_bsale_id, $update_str);
        }
        mysqli_free_result($result);


        //paso sku a la tabla de stock por sucursal, pues hasta ahora solo tiene el variante id
        //stock x sucursal
        $sucursal_productos_table = new StockSucursalesProductos();

        $sql = "select variante_id, sku from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} ;";

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        while( $row = mysqli_fetch_assoc($result) )
        {
            $variante_id = $row['variante_id'];
            $sku = $row['sku'];

            $update_str = " producto_sku_ean='$sku' ";
            $sucursal_productos_table->update($variante_id, $update_str);
        }
        mysqli_free_result($result);

        //actualizo stock de productos que son pack
        $this->ajustar_stock_packs();

        //  die("here");
        //borro productos que vengan sin sku
        $this->deleteProductosSinSku();
        $this->deleteVariantesSinProducto();

        //borro productos que vengan sin stock
        //$this->deleteProductosSinStock();
        ////lo saque porque a veces vienen sin nombre
        //$this->deleteProductosSinNombre();
        //solo se sincronizan los productos que ya estan en magento.
        //los que no estan, se ignoran
        if( $modo2 )
        {
            $this->deleteProductosQueNoEstanEnMagento();
        }

        $this->copiarACotizador();

        return true;
    }

    /**
     * copio istado de productos desde bsale_sku_productos a la de cotizacion
      sql table:
      CREATE TABLE `oc_bsale_cotizador` (
      `variante_id` int(11) NOT NULL,
      `producto_bsale_id` int(11) DEFAULT '0',
      `nombre_producto` varchar(200) COLLATE utf8_bin DEFAULT NULL,
      `sku` varchar(200) COLLATE utf8_bin DEFAULT NULL,
      `dato1` varchar(200) COLLATE utf8_bin DEFAULT NULL,
      `dato2` varchar(200) COLLATE utf8_bin DEFAULT NULL,
      `descripcion` varchar(200) COLLATE utf8_bin DEFAULT NULL,
      `precio` varchar(20) COLLATE utf8_bin DEFAULT '0',
      `precio2` varchar(20) COLLATE utf8_bin DEFAULT '0',
      `precio3` varchar(20) COLLATE utf8_bin DEFAULT '0',
      `precio4` varchar(20) COLLATE utf8_bin DEFAULT '0',
      `precio5` varchar(20) COLLATE utf8_bin DEFAULT '0',
      `precio6` varchar(20) COLLATE utf8_bin DEFAULT '0',
      `stock` int(11) DEFAULT '0',
      `estado_para_enviar` char(1) COLLATE utf8_bin DEFAULT NULL
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

      ALTER TABLE `oc_bsale_cotizador`
      ADD PRIMARY KEY (`variante_id`);

     */
    public function copiarACotizador()
    {
        $conn = $this->conectar();
        if( $conn == false )
            return;

        $skutable = new SkuProductosTable();

        $tabla_productos = $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE;
        $tabla_cotizador = 'oc_bsale_cotizador';

        //limpio cotizador
        $sql = "TRUNCATE TABLE $tabla_cotizador;";


        mysqli_query($conn, $sql);

        Funciones::print_r_html($sql, "copiarACotizador sql ");
        $sql = "INSERT INTO $tabla_cotizador SELECT * FROM $tabla_productos ORDER BY nombre_producto, descripcion";

        try
        {
            mysqli_query($conn, $sql);
            Funciones::print_r_html("copiarACotizador, FIN ");
        }
        catch( Exception $exc )
        {

            echo $exc->getTraceAsString();
        }
    }

    public function get_all_cotizador($fields = null)
    {
        $tabla_cotizador = 'oc_bsale_cotizador';

        $fields = empty($fields) ? ' * ' : $fields;
        $sql = "select $fields from $tabla_cotizador where stock > 0 order by nombre_producto, descripcion;";

        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        while( $row = mysqli_fetch_assoc($result) )
        {
            $arr[] = $row;
        }
        mysqli_free_result($result);

        //  Funciones::print_r_html("Total geT ALL: " .  count( $arr ));

        if( isset($_GET['test']) && $_GET['test'] === '1' )
        {
            Funciones::print_r_html("get_all_cotizador(), sql= '$sql'");
            Funciones::print_r_html($arr, "get_all_cotizador(), respuesta " . count($arr));
        }
        return $arr;
    }

    /**
     * devuelve todas las rows de l cotizador, separadas en dos indices de array:
     * 'h'=>rows de hombre
     * 'm'=>rows de mujer
     * 'desc'=>rows sin genero
     */
    public function get_all_cotizador_by_marca()
    {
        $rows = $this->get_all_cotizador();

        return $rows;

        $arr = array( 'h' => array(), 'm' => array(),
            'u' => array(), 'desc' => array() );

        foreach( $rows as $r )
        {
            $desc = $r['descripcion'];

            //es de hombre?
            $findme = '(H)';
            $pos = strpos($desc, $findme);
            if( $pos !== false )
            {
                $arr['h'][] = $r;
                continue;
            }
            //es de mujer
            $findme = '(M)';
            $pos = strpos($desc, $findme);
            if( $pos !== false )
            {
                $arr['m'][] = $r;
                continue;
            }
            //es unisex
            $findme = '(U)';
            $pos = strpos($desc, $findme);

            //agrego unisex a listado de hombres y mujeres
            if( $pos !== false )
            {
                $arr['u'][] = $r;
                $arr['h'][] = $r;
                $arr['m'][] = $r;
                continue;
            }
            //si llegué hasta acá es porque el prodcuto no tiene clasificacion
            $arr['desc'][] = $r;
        }
        return $arr;
    }

    public function get_all_cotizador_por_genero()
    {
        $rows = $this->get_all_cotizador();

        $arr = array( 'h' => array(), 'm' => array(),
            'u' => array(), 'desc' => array() );

        foreach( $rows as $r )
        {
            $desc = $r['descripcion'];

            //es de hombre?
            $findme = '(H)';
            $pos = strpos($desc, $findme);
            if( $pos !== false )
            {
                $arr['h'][] = $r;
                continue;
            }
            //es de mujer
            $findme = '(M)';
            $pos = strpos($desc, $findme);
            if( $pos !== false )
            {
                $arr['m'][] = $r;
                continue;
            }
            //es unisex
            $findme = '(U)';
            $pos = strpos($desc, $findme);

            //agrego unisex a listado de hombres y mujeres
            if( $pos !== false )
            {
                $arr['u'][] = $r;
                $arr['h'][] = $r;
                $arr['m'][] = $r;
                continue;
            }
            //si llegué hasta acá es porque el prodcuto no tiene clasificacion
            $arr['desc'][] = $r;
        }
        return $arr;
    }

    public function clear_all()
    {
        $conn = $this->conectar();
        if( $conn == false )
            return;

        try
        {

            //  $sql = "SET FOREIGN_KEY_CHECKS=0;";
            // mysqli_query( $conn, $sql );

            $sql = "TRUNCATE TABLE {$this->STOCK_PRODUCTOS_BSALE_TABLE};";
            //   Funciones::print_r_html( $sql, "sql para clear" );

            mysqli_query($conn, $sql);

            //  $sql = "SET FOREIGN_KEY_CHECKS=1;";
            //  mysqli_query( $conn, $sql );
        }
        catch( Exception $exc )
        {
            //  mysqli_rollback( $conn );
            echo $exc->getTraceAsString();
        }
    }

    public function add($array_datos)
    {
        $conn = $this->conectar();
        if( $conn == false )
            return -1;
        //saco basura        
        $array_datos['name'] = str_replace('Â', '', $array_datos['name']);
        $array_datos['description'] = str_replace('Â', '', $array_datos['description']);


        $producto_bsale_id = $array_datos['producto_bsale_id'];
        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            $name = esc_sql($array_datos['name']);
            $description = esc_sql($array_datos['description']);
            $centro_costo = esc_sql($array_datos['centro_costo']);
        }
        else
        {
            $name = mysqli_real_escape_string($conn, $array_datos['name']);
            $description = mysqli_real_escape_string($conn, $array_datos['description']);
            $centro_costo = mysqli_real_escape_string($conn, $array_datos['centro_costo']);
        }

        $stock_control = $array_datos['stock_control'];
        $state = $array_datos['state'];
        $sku = $array_datos['sku'];
        $precio = $array_datos['precio'];
        $stock = $array_datos['stock'];

        // $hoy = date( "Y-m-d H:i:s" );

        /* Update order header for invoice charged on */
        $SQL = "INSERT INTO {$this->STOCK_PRODUCTOS_BSALE_TABLE}(producto_bsale_id, name, description, "
                . "centro_costo, stock_control, state, sku, precio, stock) "
                . " VALUES ('$producto_bsale_id', '$name', '$description', '$centro_costo', '$stock_control',"
                . " '$state',"
                . " '$sku', '$precio', '$stock' )";


        //   Funciones::print_r_html( $SQL, " prodcuto bsale a local db:" );
        $Result = mysqli_query($conn, $SQL);

        return $Result;
    }

    public function update_producto($producto_bsale_id, $update_str)
    {

        $sql = "update {$this->STOCK_PRODUCTOS_BSALE_TABLE} set $update_str"
                . " WHERE producto_bsale_id = $producto_bsale_id ;";

        $conn = $this->conectar();
        if( $conn == false )
            return;

        $result = mysqli_query($conn, $sql);
        return $result;
    }

    public function delete_producto($producto_bsale_id)
    {

        $conn = $this->conectar();
        if( $conn == false )
            return;
        $sql = "delete from {$this->STOCK_PRODUCTOS_BSALE_TABLE}  "
                . "WHERE producto_bsale_id = $producto_bsale_id ;";

        $result = mysqli_query($conn, $sql);
        return $result;
    }

    public function get_all($fields = null, $where = null, $limit = '', $load_in_new_table = false)
    {
        $fields = empty($fields) ? ' * ' : $fields;

        $table = ($load_in_new_table) ? $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE2 : $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE;

        $sql = "select $fields from $table ";

        if( !empty($where) )
        {
            $sql .= " WHERE $where ";
        }
        $sql .= "order by producto_bsale_id desc " . (!empty($limit) ? " LIMIT $limit" : '' ) . ";";


        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }
        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            global $wpdb;

            //paso resulktados a un array
            $arr = array();
            $result = $wpdb->get_results($sql, ARRAY_A);

            foreach( $result as $row )
            {
                $arr[] = $row;
            }
            return $arr;
        }

        //cuando no es con Wc
        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        while( $row = mysqli_fetch_assoc($result) )
        {
            $arr[] = $row;
        }
        mysqli_free_result($result);

        //  Funciones::print_r_html("Total geT ALL: " .  count( $arr ));
        return $arr;
    }

    /**
     * numer de productos sin estado E
     */
    public function count_por_enviar()
    {
        $sql = "select count(producto_bsale_id) as cantidad from {$this->STOCK_PRODUCTOS_BSALE_TABLE} "
                . " WHERE NOT (estado_para_enviar = 'E') OR estado_para_enviar is null ;";
        // Funciones::print_r_html( "count_por_enviar: $sql" );
        $conn = $this->conectar();
        if( $conn == false )
            return;

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        $row = mysqli_fetch_assoc($result);
        $cantidad = (int) $row['cantidad'];

        mysqli_free_result($result);
        return $cantidad;
    }

    /**
     * numer de productos sin estado E
     */
    public function count_por_enviarMagento()
    {
        $sql = "select count(producto_bsale_id) as cantidad from {$this->STOCK_PRODUCTOS_BSALE_TABLE};";
        // Funciones::print_r_html( "count_por_enviar: $sql" );
        $conn = $this->conectar();
        if( $conn == false )
            return;

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        $row = mysqli_fetch_assoc($result);
        $cantidad = (int) $row['cantidad'];

        mysqli_free_result($result);
        return $cantidad;
    }

    /**
     *  debuelve todos los productos indexados por sku
     * @param type $fields
     * @return type
     */
    public function get_all_by_sku_index($fields = null, $where = null, $limit = '')
    {
        //borro producots mal insertados
        $this->deleteProductosSinSku();
        $bsale_products = $this->get_all($fields, $where, $limit);
        $arraux = array();

        $l = count($bsale_products);
        //  Funciones::print_r_html( "get_all_by_sku_index: $l;" );
        if( $l <= 0 )
            return array();

        for( $i = 0; $i < $l; $i++ )
        {
            $c = $bsale_products[$i];
            //xxx scar eso del sku$i
            /*  $c['sku'] = !empty( $c['sku'] ) ? $c['sku'] : "sku$i";
              $c['name'] = !empty( $c['name'] ) ? $c['name'] : "name$i";
              $c['description'] = !empty( $c['description'] ) ? $c['description'] : "description$i"; */

            $sku = $c['sku'];

            $arraux[$sku] = $c;
            //  Funciones::print_r_html( "get_all_by_sku_index: arraux[$sku] " );
        }
        unset($bsale_products);

        //  Funciones::print_r_html( "get_all_by_sku_index: " . count( $arraux ) );
        return $arraux;
    }

    public function get_all_by_product($limit = '')
    {
        //borro producots mal insertados
        $this->deleteProductosSinSku();
        $bsale_products = $this->get_all(null, null, $limit);
        $arraux = array();

        $l = count($bsale_products);
        //  Funciones::print_r_html( "get_all_by_sku_index: $l;" );
        if( $l <= 0 )
            return array();

        for( $i = 0; $i < $l; $i++ )
        {
            $c = $bsale_products[$i];
            $producto_bsale_id = $c['producto_bsale_id'];

            //se ha creado este producto?
            if( !isset($arraux[$producto_bsale_id]) )
            {
                $producto_nombre = $c['nombre_producto'];

                $arraux[$producto_bsale_id] = array(
                    'nombre_producto' => $producto_nombre,
                    'producto_bsale_id' => $producto_bsale_id,
                    'producto_sku' => $c['sku'],
                    'producto_descripcion' => $c['descripcion'],
                    'producto_precio' => $c['precio'],
                    'producto_stock' => $c['stock'],
                    'variantes' => array() );
            }
            //agrego la variante
            $arraux[$producto_bsale_id]['variantes'][] = $c;

            //  Funciones::print_r_html( "get_all_by_sku_index: arraux[$sku] " );
        }
        unset($bsale_products);

        //  Funciones::print_r_html( "get_all_by_sku_index: " . count( $arraux ) );
        return $arraux;
    }

    public function deleteProductosQueNoEstanEnMagento()
    {
        $conn = $this->conectar();
        if( $conn == false )
            return;
        $magento_tabla = $this->STOCK_PRODUCTOS_JUMPSELLER_TABLE;
        $bsale_tabla = $this->STOCK_SKU_PRODUCTOS_BSALE_TABLE;
        $sql = "delete from $bsale_tabla b WHERE  NOT EXISTS "
                . "(select sku from $magento_tabla m  where m.sku=b.sku) ;";
        $result = mysqli_query($conn, $sql);
    }

    public function deleteProductosSinSku()
    {
        $conn = $this->conectar();
        if( $conn == false )
            return;

        $sql = "delete from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} WHERE sku='' OR sku is null ;";
        $result = mysqli_query($conn, $sql);
    }

    /**
     * borra las variantes que no tienen producto id en la tabla de productos
     * @return type
     */
    public function deleteVariantesSinProducto()
    {
        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }
        //ids de prodcutos de tabla productos
        $sql = "select producto_bsale_id from {$this->STOCK_PRODUCTOS_BSALE_TABLE} order by producto_bsale_id;";

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //ids de productos de la tabla producto
        $arr_productos_id = array();

        while( $row = mysqli_fetch_assoc($result) )
        {
            $arr_productos_id[] = (int) $row['producto_bsale_id'];
        }
        mysqli_free_result($result);


        //ids de productos de tabla variantes sku stock precio
        $sql = "select producto_bsale_id from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} order by producto_bsale_id;";

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }

        //recorro las variantes y si no hay prodcuto id en tabla producto, borro la variante
        while( $row = mysqli_fetch_assoc($result) )
        {
            $producto_bsale_id = (int) $row['producto_bsale_id'];

            //si no está en la tabla de productos, se borran las variantes de ese producto
            if( !in_array($producto_bsale_id, $arr_productos_id) )
            {
                $sql = "delete from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} WHERE producto_bsale_id='$producto_bsale_id';";
                mysqli_query($conn, $sql);
            }
        }
        mysqli_free_result($result);
    }

    /**
     * coloca el stock de los prodcutos que osn packs
     * @return type
     */
    public function ajustar_stock_packs()
    {
        $conn = $this->conectar();
        if( $conn == false )
            return;
        //para update stock
        $skutable = new SkuProductosTable();

        $sql = "select * from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} WHERE stock <=0 OR stock = '' OR stock is null ;";

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }

        //recorro variantes sin stock
        while( $row = mysqli_fetch_assoc($result) )
        {
            $variante_id = $row['variante_id'];
            $sku = $row['sku'];
            $producto_bsale_id = $row['producto_bsale_id'];

            //obtengo producto de la variante
            $sql = "select stock_control from {$this->STOCK_PRODUCTOS_BSALE_TABLE} where producto_bsale_id = '$producto_bsale_id';";

            if( !$result2 = mysqli_query($conn, $sql) )
            {
                die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
            }
            $row = mysqli_fetch_assoc($result2);

            //stock control contiene el json con las variantes que forman el pack
            $stock_control = $row['stock_control'];
            mysqli_free_result($result2);

            //veo si hay json o no
            if( empty($stock_control) || $stock_control == 0 || $stock_control == 1 )
            {
                //no es pack, lo salto
                continue;
            }

            $pack_details = json_decode($stock_control, true);

            if( empty($pack_details) )
            {
                Funciones::print_r_html("ajustar_stock_packs() para producto=$producto_bsale_id, variante=$variante_id ($sku), pack details is null, continue.");
                continue;
            }
            $stock_pack = $this->get_stock_para_pack($pack_details);

            //actualizo stock de pack
            $update_str = " stock='$stock_pack' ";

            Funciones::print_r_html("ajustar_stock_packs()para producto=$producto_bsale_id, variante=$variante_id ($sku): $update_str");
            $skutable->update($variante_id, $update_str);
        }
        mysqli_free_result($result);
    }

    /**
     * recibe un array con el listado de variantes de un pack
     * busca el stock de cada una y le asigna al pack el menor stock de variante
     * @param type $pack_details
     */
    public function get_stock_para_pack($pack_details)
    {
        $skutable = new SkuProductosTable();
        $total_stock_pack = 0;
        //arrays con el stock de cada variante que forma el pack
        $arr_stocks_variante = array();

        foreach( $pack_details as $p )
        {
            //cant de prods de esta variante en el pack
            $quantity = $p['quantity'];

            if( $quantity <= 0 )
            {
                continue;
            }

            $variant_pack_id = isset($p['variant']['id']) ? $p['variant']['id'] : 0;

            if( $variant_pack_id <= 0 )
            {
                continue;
            }
            //obtengo variante dede tabla stock
            $variante_row = $skutable->get_by_variante_id($variant_pack_id);

            if( empty($variante_row) )
            {
                //varianbte sin stock
                $arr_stocks_variante[] = 0;
                continue;
            }
            //si mi pack tiene 2 unid y en stock hay 40, el máximo de stock del pack
            //es de 40/2= 20 unidades del pack
            $stock_variante = $variante_row['stock'] / $quantity;

            //el stock debe ser, al menos, igual a la cantidad de esa variante que contiene el pack
            if( $stock_variante <= 0 )
            {
                $stock_variante = 0;
            }
            //guardo en listado de stocks de variantes
            $arr_stocks_variante[] = $stock_variante;
        }
        //en $arr_stocks_variante están los stock, por separado, de cada variante que conforma el 
        //pack. Extraigo el menor etock y lo devuelvo
        if( count($arr_stocks_variante) > 0 )
        {
            $total_stock_pack = min($arr_stocks_variante);
        }

        return $total_stock_pack;
    }

    public function deleteProductosSinStock()
    {
        if( defined('BSALE_MODO2') && BSALE_MODO2 === true )
        {
            return;
        }
        $conn = $this->conectar();
        if( $conn == false )
            return;

        $sql = "delete from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} WHERE stock <=0 OR stock = '' OR stock is null ;";
        $result = mysqli_query($conn, $sql);
    }

    public function deleteProductosSinNombre()
    {
        $conn = $this->conectar();
        if( $conn == false )
            return;

        $sql = "delete from {$this->STOCK_SKU_PRODUCTOS_BSALE_TABLE} WHERE nombre_producto = '' OR nombre_producto is null ;";
        $result = mysqli_query($conn, $sql);
    }

}
