
var $ = jQuery.noConflict();

$(document).ready(function ()
{
    try
    {
        console.log("bs admin ok..");
        //boton synd datos prodcutos en admin de productos
        button_sync_all_add();
        //boton sync prodcuto individual
        do_bsale_sync_button();

        //params de pagina config
        set_param_links();

        //proceso de sincronizar todos los productos        ;
        do_sync_all_productosV2();

        //config bsale: payments
        // do_bsale_payments_config();

    } catch (e)
    {
        console.log("js: ", e);
    }


});

/**
 * 0 empezar, 1 en curso, 2 detenida
 * @param {type} status
 * @returns {undefined}
 */
function set_state_sync_bsale(status)
{
    if ($ === undefined)
    {
        var $ = jQuery.noConflict();
    }
    $("#state_sync_bsale", ".wrap.bsale_wooc").val(status);
    // $("#state_sync_bsale", ".wrap.bsale_wooc").attr("value", status);
}
function get_state_sync_bsale()
{
    if ($ === undefined)
    {
        var $ = jQuery.noConflict();
    }
    return $("#state_sync_bsale", ".wrap.bsale_wooc").val();
}

/**
 * sync all prodcutos wc segun los datos de Bsale, sin ajax sync
 * @returns {undefined}
 */
function do_sync_all_productosV2()
{
    var $ = jQuery.noConflict();

    var product_ids_array;
    var ajax_url = $("#sync_bsale_url").val();
    var button_stop = $("#sync_bsale_info");

    //para detener la sync
    $("#stop_sync_bsale_products").on("click", function ()
    {
        set_state_sync_bsale(2); //stop sync
    });

    $("#start_sync_bsale_products").on("click", function ()
    {
        $("#sync_bsale_info").val("");

        $("#start_sync_bsale_products").css("display", "none");

        //paso ids del textarea a un array 
        product_ids_array = $("#product_ids").val().split("\n");

        //limpio listado prods de text area 
        // $("#product_ids").val("");

        // console.log("do_sync_all_productos(), url=" + ajax_url);
        console.log("do_sync_all_productos(), product_ids_array");
        console.log(product_ids_array);

        var len = product_ids_array.length - 1; //-1 porque el ultimo caracter es \n y si no lo coloco al final, cuenta un prod menos
        var prod_counter = 0;
        var i = 0;

        //   $("#bsale_total_prods_count").html(len);

        bsale_info_ta_sync("La sincronización ha comenzado. Si desea detenerla, cierre esta página.");
        bsale_info_ta_sync("Total productos a sincronizar: " + len); //
        set_msg_sync("La sincronización ha comenzado. Si desea detenerla, cierre esta página.");

        set_state_sync_bsale(1); //inicio

        //recorro prod ids y voy llamando a ajax
        function next_sync_bsale()
        {
            //debo continuar?
            if (get_state_sync_bsale() === "2")
            {
                bsale_info_ta_sync("La sincronización se ha detenido.");
                set_msg_sync("La sincronización se ha detenido.");
                $("#start_sync_bsale_products").css("display", "inline-block");
                return true;
            }
            console.log("get_state_sync_bsale(): " + get_state_sync_bsale());

            var prod_id = product_ids_array[i];
            var prod_url = ajax_url + prod_id;
            prod_counter = i + 1;
            i++;

            if (i > len)
            {
                //sync terminada
                //fin ajax
                bsale_info_ta_sync("---¡La sincronización ha terminado!---");
                set_msg_sync("Sincronización terminada");
                $("#start_sync_bsale_products").css("display", "inline-block");
                return true;
            }

            //console.log("do_sync_all_productos(), url: syncronizando producto id=" + pid + "...");            
            //llamo a ajax con variable global de wp "ajaxurl"
            var jqxhr = $.ajax({
                //   url: prod_url,
                url: ajaxurl,
                data: {
                    action: "bsale_ajax_sync_prod_action",
                    param: "yes",
                    pid: prod_id,
                    bsale_silent: 1
                },
                async: true,
                timeout: 90000 //miliseconds
            }).done(function (data, textStatus, jqXHR)
            {
                //prods sincronizados
                $("#bsale_sync_prods_count").html(i);
                // console.log("success");
                log_sync_all_productos(prod_counter, data);
                next_sync_bsale();
            }).fail(function (data, textStatus, jqXHR)
            {
                console.log("error, timeout o fail de sync prod: " + data + ":: " + textStatus + "::" + jqXHR);
                log_sync_all_productos(prod_counter, data, prod_id);
                next_sync_bsale();
            });
        }

        //first time
        next_sync_bsale();


    });
}



function log_sync_all_productos($counter, $str, $product_id)
{
    var $ = jQuery.noConflict();

    var obj;

    if ($str === "")
    {
        console.log("error sync prod, respuesta vacía (timeout?): " + $str);
        return false;
    }
    try
    {
        //console.log("data respuesta...:");
        //console.log($str);
        //$str = $.trim($str);

        if ($str.product_name !== undefined)
        {
            obj = $str;
            console.log("str es objeto $str.product_name: " + $str.product_name);
        } else
        {
            obj = JSON.parse($str);
        }


        //console.log("obj json:");
        //console.log(obj);

        //vienen datos?
        if (obj != null && obj.product_name !== undefined)
        {
            var product_name = obj.product_name;
            var res = obj.result;
            var error_msg = obj.error;
            var resultado = "";

            if (res == true)
            {
                resultado = "Exito";
            } else
            {
                resultado = "Error";
            }
            //id prod/variacion=>sku
            var prod_skus_arr = obj.list_skus;
            var skus_list = "";

            $.each(prod_skus_arr, function (key, value)
            {
                skus_list += "  [#" + key + " sku=" + value + "]";
            });

            var $info_prod = $counter + ") Sincronizando Producto '" + product_name + "', con skus '" + skus_list + "', resultado= " + resultado + " " + error_msg;

            bsale_info_ta_sync($info_prod);

            if (res == true)
            {
                bsale_set_info_prod_sync_ok($info_prod);
            } else
            {
                bsale_set_info_prod_sync_failed($info_prod);
            }
        }
        //error en respuesta de ajax
        else
        {
            var $info_prod = $counter + ") ERROR Sincronizando Producto " + $product_id + "; '" + $str + "";
            bsale_info_ta_sync($info_prod);
            bsale_set_info_prod_sync_failed($info_prod);


        }
    } catch (e)
    {
        console.log("error sync prod: " + $str);
        console.log(e);

        var $info_prodx = $counter + ") Sincronizando Producto '... ok";

        bsale_info_ta_sync($info_prodx);
    }



}

/**
 * agrega texto al textarea con info
 * @returns {undefined}
 */
function bsale_info_ta_sync(linea)
{
    var $ = jQuery.noConflict();

    var $edit = $("#sync_bsale_info");
    var curValue = $edit.val();

    var newValue = curValue + "\n" + linea;

    $edit.val(newValue);
}

function bsale_set_info_prod_sync_ok(linea)
{
    var $ = jQuery.noConflict();

    var $edit = $("#skus_updated");
    var curValue = $edit.val();

    var newValue = curValue + "\n" + linea;

    $edit.val(newValue);
}

function bsale_set_info_prod_sync_failed(linea)
{
    var $ = jQuery.noConflict();

    var $edit = $("#skus_failed");
    var curValue = $edit.val();

    var newValue = curValue + "\n" + linea;

    $edit.val(newValue);
}

/**
 * 
 * @param {type} $str
 * @returns {undefined}coloca texto en span de información
 */
function set_msg_sync($str)
{
    var $ = jQuery.noConflict();

    var $edit = $("#sync_bsale_msg");
    $edit.html($str);
}
/**
 * agrega boton para link para sincronizar precio y stock de todos los productos
 * @returns {undefined}
 */
function button_sync_all_add()
{
    var $ = jQuery.noConflict();

    var title = "Sincroniza precio y stock desde Bsale para todos los productos woocommerce.";
    var style = "background-color: #ff5c1a; color: #fff;padding: 5px 20px;text-transform: uppercase;border-color:#717171;border-radius: 5px;";

    var $elem = $("a.page-title-action", "body.wp-admin.post-type-product #wpbody-content .wrap").last();
    $elem.after("<a id='sync_all_productos_bsale' href='tools.php?page=woo_bsale-admin-menu&bsale_tab=bsale_sync&bsale_silent=1' target='_blank' class='page-title-action bsale' title='" + title + "' style='" + style + "'>Sincronizar productos Bsale</a>");
}

function do_bsale_sync_button()
{
    var $ = jQuery.noConflict();
    var $count = 0; //veces que se ha intentado sincronizar

    $(".sync_bsale_btn").on("click", function (e)
    {
        e.preventDefault();

        var prod_id = $(this).attr("data-pid");

        //var url = $(this).attr("href");

        //ajaxurl es global de WP
        var url = ajaxurl + "?action=bsale_ajax_sync_prod_action&param=yes&pid=" + prod_id + "&bsale_silent=1";

        //console.log("sync_bsale_btn, url:  " + url);
        //escondo boton
        $(this).css("display", "none");

        //console.log("sync_bsale_btn, sigo");
        //muestro spinner
        $("#spinner_sync_bsale").css("display", "inline-block");

        var me = $(this);

        $("#result_sync").load(url, function (response, status, xhr)
        {
            console.log("sync_bsale_btn, fin ajax");
            if (status === "error")
            {
                //incremento intentos fallidos
                $count++;
                if ($count <= 3)
                {
                    //intento de nuevo
                    me.trigger("click");
                } else
                {
                    var msg = "No se pudo sincronizar el producto: ";
                    $("#bsale_sync_result").html(msg + xhr.status + " " + xhr.statusText);
                }
            } else
            {
                $("#bsale_sync_result").html("Sincronización exitosa. Ahora, la página se recargará.");
                location.reload();

            }

            me.css("display", "inline-block");
            $("#spinner_sync_bsale").css("display", "none");

        });//fin $("#result_sync").
    });
}



/**
 * en página de config, lleno params en input antes de hacer clic en url
 * @returns {undefined}
 */
function set_param_links()
{
    var $ = jQuery.noConflict();

    $(".test_bsale_input").on("change", function ()
    {
        var val = $.trim($(this).val());

        //link target, donde colocar el val al final de la url
        var target = $(this).attr("data-target");
        //url del target
        var url = $(target).attr("data-url") + val;
        //coloco url
        $(target).attr("href", url);

        //si no se ha esrito nada, remuevo link
        if (val === "")
        {
            $(target).removeAttr("href");
        }
    });
}

