<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SucursalesTable
 *
 * @author angelorum
 */
class SucursalesTable extends OCDB
{

    function __construct()
    {
        parent::__construct();
    }

    public function clear_all()
    {
        $conn = $this->conectar();
        if( $conn == false )
            return;

        $prefix = self::$db_prefix;
        $table = "{$prefix}bsale_sucursales";

        try
        {

            //  $sql = "SET FOREIGN_KEY_CHECKS=0;";
            // mysqli_query( $conn, $sql );

            $sql = "TRUNCATE TABLE $table;";
            //   Funciones::print_r_html( $sql, "sql para clear" );

            mysqli_query($conn, $sql);

            //  $sql = "SET FOREIGN_KEY_CHECKS=1;";
            //  mysqli_query( $conn, $sql );
        }
        catch( Exception $exc )
        {
            //  mysqli_rollback( $conn );
            echo $exc->getTraceAsString();
        }
    }

    public function add($array_datos)
    {
        $conn = $this->conectar();
        if( $conn == false )
            return -1;

        $prefix = self::$db_prefix;
        $table = "{$prefix}bsale_sucursales";

        $sucursal_id = $array_datos['sucursal_id'];
        $nombre = $array_datos['nombre'];
        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            $nombre = esc_sql($nombre);
        }
        else
        {
            $nombre = mysqli_real_escape_string($conn, $nombre);
        }


        /* Update order header for invoice charged on */
        $SQL = "INSERT INTO $table(sucursal_id, nombre) "
                . " VALUES ('$sucursal_id', '$nombre')";
        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            global $wpdb;
            $Result = $wpdb->query($SQL);
        }
        else
        {
            //  Funciones::print_r_html( $SQL, "guardarTransaccion:" );
            $Result = mysqli_query($conn, $SQL);
        }



        return $Result;
    }

    public function get_by_id($sucursal_id)
    {
        $prefix = self::$db_prefix;
        $table = "{$prefix}bsale_stock_sucursal";


        $sql = "select * from $table where sucursal_id= '$sucursal_id' ;";

        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }

        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            global $wpdb;

            //paso resulktados a un array
            $arr = array();
            $result = $wpdb->get_results($sql, ARRAY_A);

            foreach( $result as $row )
            {
                //1 sola row
                return $row;
            }
            return $arr;
        }

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }

        $row = mysqli_fetch_assoc($result);

        mysqli_free_result($result);
        return $row;
    }

    public function get_all($fields = null)
    {
        $prefix = self::$db_prefix;
        $table = "{$prefix}bsale_sucursales";

        $fields = empty($fields) ? ' * ' : $fields;
        $sql = "select $fields from $table order by sucursal_id;";

        $conn = $this->conectar();
        if( $conn == false )
        {
            return;
        }

        if( INTEGRACION_SISTEMA === 'woocommerce' )
        {
            global $wpdb;

            //paso resulktados a un array
            $arr = array();
            $result = $wpdb->get_results($sql, ARRAY_A);

            foreach( $result as $row )
            {
                $arr[] = $row;
            }
            return $arr;
        }

        if( !$result = mysqli_query($conn, $sql) )
        {
            die("get_all(): $sql: There was an error running the query ['" . mysqli_connect_error() . "']");
        }
        //paso resulktados a un array
        $arr = array();
        while( $row = mysqli_fetch_assoc($result) )
        {
            $arr[] = $row;
        }
        mysqli_free_result($result);
        return $arr;
    }

}
