<?php

/*
 * integraciónm con Dokan multivendor
  lee los archivos .json de la carpeta  de cada usuario que haya
 * activado la integración y llama al archivo php que las procesa
 *  */
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once dirname(__FILE__) . '/../lib/Autoload.php';

if( !(PHP_SAPI === 'cli' || PHP_SAPI === 'cgi-fcgi') && (!isset($_REQUEST['param']) || $_REQUEST['param'] !== 'yes' ) )
{
    echo('not allowed');
    exit;
}

if( !(PHP_SAPI === 'cli' || PHP_SAPI === 'cgi-fcgi') && !current_user_can('edit_posts') )
{
    echo('user not allowed!!');
    exit;
}


global $RESEND_NOTIFICACIONES_URL;

//sin trailing /
$RESEND_NOTIFICACIONES_URL = array( );

//urls to resend
$urls_to_resend = Funciones::get_resend_urls();

if( is_array($urls_to_resend) && count($urls_to_resend) > 0 )
{
    $RESEND_NOTIFICACIONES_URL = array_merge($RESEND_NOTIFICACIONES_URL, $urls_to_resend);
}

do_resend();

/**
 * recorre a todos los usuarios seller que tengan la integrac con Dokan
 * activada y procesa los avisos
 */
function do_resend()
{
    global $RESEND_NOTIFICACIONES_URL;

    if( !is_array($RESEND_NOTIFICACIONES_URL) && empty($RESEND_NOTIFICACIONES_URL) )
    {
        return true;
    }
    $folder_resend = dirname(__FILE__) . '/resend/';
    //leo avisos de bslae y los envio a otras urls, luego los borro del a carpeta resend
    resend_mensajes_bsale($folder_resend, $RESEND_NOTIFICACIONES_URL);
}

/**
 * recorre los archivos del folrder "resend" yt los reevnia alas urls
 * borra cada archivo una vez que lo envió a todas las url
 * recorre de a 50 archivos por usuario
 * @param type $user_id
 * @param type $folder
 * @param type $parameters_urls_arr
 * @return boolean
 */
function resend_mensajes_bsale($folder, $parameters_urls_arr)
{

    $dir = $folder;

    // Open a directory, and read its contents
    if( !is_dir($dir) )
    {
        Funciones::print_r_html("resend_mensajes_bsale()  '$dir' no es un folder. Se omite");
        return false;
    }
    $dh = opendir($dir);

    if( $dh === false )
    {
        Funciones::print_r_html("function read_avisos(), '$dir' opendir no pudo abrirlo");
        return false;
    }

    $i = 0;

    $utils = new Utils();

    while( ($file = readdir($dh)) !== false )
    {
        if( $file === '.' || $file === '..' )
        {
            continue;
        }
        //solo archivos .json
        if( !$utils->has_file_extension($file, 'json') )
        {
            //Funciones::print_r_html("function read_avisos(), '$file' no es json");
            continue;
        }
        //solo archivos .json
        Funciones::print_r_html("read_avisos(), procesando filename: '$dir/$file' ...");
        procesar_aviso_resend($dir, $file, $parameters_urls_arr);

        $i++;

        if( $i >= 50 )
        {
            return true;
        }
    }
    closedir($dh);

    return true;
}

function procesar_aviso_resend($dir, $file, $parameters_urls_arr)
{
    $post_vars = file_get_contents("$dir/$file");
    $post_vars = trim($post_vars);

    if( empty($post_vars) )
    {
        Funciones::print_r_html("procesar_aviso_resend archivo  ('{$dir}{$file}', está vacío");
        $res = unlink("{$dir}{$file}");
        return false;
    }

    $mu = new Multiuser();

    foreach( $parameters_urls_arr as $url )
    {
        Funciones::print_r_html("procesar_aviso_resend enviando ('{$dir}{$file}', a url='$url'...");

        //valido url
        if( filter_var($url, FILTER_VALIDATE_URL) === FALSE )
        {
            Funciones::print_r_html("ERROR! procesar_aviso_resend enviando url='$url' no es válida");
            continue;
        }

        $response = $mu->send_to_url($url, $post_vars);

        Funciones::print_r_html($response, "procesar_aviso_resend a url='$url', respuesta:");
    }
    $res = unlink("{$dir}{$file}");


    if( $res === false )
    {
        Funciones::print_r_html("procesar_aviso_resend: no se pudo borrar {$dir}{$file}!");
    }
}
