<?php
/* error_reporting(E_ALL);
  ini_set('display_errors', 1); */
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
require_once dirname(__FILE__) . '/../Autoload.php';
define('WP_ORDER_COMPLETED_TEST', false);

/**
 * Description of WpBsale
 *
 * @author angelorum
 */
class WpBsale
{

    //public static function 
    public function get_shipping_methods_wc($enabled = false, $formatted = true)
    {
        $active_methods = array();
        $shipping_methods = WC()->shipping()->get_shipping_methods();

        foreach( $shipping_methods as $id => $shipping_method )
        {
            //Funciones::print_r_html($shipping_method, "get_shipping_methods_wc loop:");
            //if( isset($shipping_method->enabled) && 'yes' === $shipping_method->enabled )
            {
                $active_methods[$id] = array(
                    'id' => $id,
                    'title' => $shipping_method->method_title,
                    'description' => $shipping_method->method_description,
                    'enabled' => $shipping_method->enabled,
                    'tax_status' => $shipping_method->tax_status,
                );
            }
        }

        return $active_methods;
    }

    /**
     * devuelve listado de todos los medios de pago instalados en woocommerce
     * @param type $enabled (devuelve solo los enabled)
     * fomrmatted: solo devuelve id, title y enabled
     */
    public static function get_payments_wc($enabled = false, $formatted = true)
    {
        $payment_gateways_obj = new WC_Payment_Gateways();
        $enabled_payment_gateways = $payment_gateways_obj->payment_gateways();

        $arr = array();

        foreach( $enabled_payment_gateways as $p )
        {
            if( $enabled && $p->enabled !== 'yes' )
            {
                continue;
            }
            if( $formatted )
            {
                $arr[] = array( 'id' => $p->id, 'title' => $p->title, 'enabled' => $p->enabled );
            }
            else
            {
                $arr[] = (array) $p;
            }
        }
        return $arr;
    }

    public static function is_in_category($product_id)
    {
        return true;

//veo si prodcuto pertenece a una de las categorias aceptadas
        global $options;
        $categs_str = trim(get_option('bsale_categorias_id'));

        if( empty($categs_str) )
        {
            return true;
        }

        $categorias_permitidas = explode(',', $categs_str);

        /*  Funciones::print_r_html($categorias_permitidas, "categs permitidas");
          die(); */

        if( empty($categorias_permitidas) )
        {
            return true;
        }

        $categories = array();

        $terms = wp_get_post_terms($product_id, 'product_cat');
//guardo categorias
        foreach( $terms as $term )
        {
            $categories[] = $term->term_id; // . ' ' . $term->slug;
            $categories[] = $term->parent;
        }
//  $categories = $product->get_categories( $product_id );
// Funciones::print_r_html( $categories, "ctegorias" );
//veo si categ producto esta en categ allowed
        foreach( $categories as $cc )
        {
            if( in_array($cc, $categorias_permitidas) )
            {
                return true;
            }
        }
        return false;
    }

    public static function is_role_user($user_id, $role_required)
    {
        $user_info = get_userdata($user_id);
        $user_roles = implode(', ', $user_info->roles);

        return strcasecmp($role_required, $user_roles) == 0;
    }

    public function is_valid_for_dte($order)
    {
        $order_id = $order->get_id();
        $modo_pago = get_post_meta($order_id, '_payment_method', true);
        $nombre_pago = get_post_meta($order_id, '_payment_method_title', true); //_payment_method_title
        $status = $order->get_status();


        //en caso de que quedeba generar nv para todas las compras completed, excepto las 
        //con bacs (ellas las generaron en on hold)
        /* if( defined('WC_PAYMENTS_GENERAR_NV_ON_COMPLETED') && WC_PAYMENTS_GENERAR_NV_ON_COMPLETED == true && $status === 'completed' )
          {
          return true && ($modo_pago !== 'bacs');
          } */

        //solo si hay medio de envio que saltar
        if( defined('WC_SKIP_DTE_WITH_SHIPPING') && !empty(WC_SKIP_DTE_WITH_SHIPPING) )
        {
            //medio de envio de esta orden
            $shipping_methods_arr = $order->get_shipping_methods();

            $shippings_str = WC_SKIP_DTE_WITH_SHIPPING;
            //paso a minúsculas
            $shippings_str = strtolower($shippings_str);

            //split por comas
            $shippings_arr = explode(',', $shippings_str);

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("is_valid_for_dte id=$order_id, reviso envios a omitir: '$shippings_str'");
            }

            if( is_array($shippings_arr) && count($shippings_arr) > 0 )
            {
                foreach( $shipping_methods_arr as $shipping_item_obj )
                {
                    $shipping_data = $shipping_item_obj->get_data();

                    $shipping_data_id = $shipping_data['id'];
                    $shipping_data_order_id = $shipping_data['order_id'];
                    $shipping_data_name = $shipping_data['name'];
                    $shipping_data_method_title = $shipping_data['method_title'];
                    $shipping_data_method_id = $shipping_data['method_id'];
                    $shipping_data_instance_id = $shipping_data['instance_id'];
                    $shipping_data_total = $shipping_data['total'];
                    $shipping_data_total_tax = $shipping_data['total_tax'];
                    $shipping_data_taxes = $shipping_data['taxes'];

                    //a minusculas 
                    $shipping_data_method_title = strtolower($shipping_data_method_title);

                    if( isset($_REQUEST['test_dte']) )
                    {
                        Funciones::print_r_html("is_valid_for_dte id=$order_id, reviso envio de orden name = '$shipping_data_method_title'");
                    }

                    //recorro los medios de envio a omitir y los comparo con el titulo del envio de esta orden
                    foreach( $shippings_arr as $shipping_a_omitir )
                    {
                        $shipping_a_omitir = strtolower($shipping_a_omitir);

                        //este envio está en ls lista de los rechazados?
                        if( strpos($shipping_data_method_title, $shipping_a_omitir) !== false )
                        {
                            if( isset($_REQUEST['test_dte']) )
                            {
                                Funciones::print_r_html("is_valid_for_dte id=$order_id, reviso envio de orden name = '$shipping_data_method_title' "
                                        . "está en el envio a omitir = '$shipping_a_omitir'. Para esta orden no se genera dte");
                            }
                            return false;
                        }
                    }
                }
            }
        }


        return true;
    }

    /**
     * si esta orden, en este estado, puede emitir dte(boleta/factura)
     * @param type $order
     * @return boolean
     */
    public function is_for_dte($order)
    {
        $order_id = $order->get_id();
        $modo_pago = $billing_paymethod = get_post_meta($order_id, '_payment_method', true);
        $status = $order->get_status();

        $tipo_docto_meta = get_post_meta($order_id, 'bsale_docto_tipo', true);

        //si viene test dte, solo es para ver, no para emitir
        //ya se ha emitido dte para esta orden
        if( $tipo_docto_meta === 'boleta' || $tipo_docto_meta === 'factura' )
        {
            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("is_for_dte: pedido id=$order_id, en estado= '$status' ya ha emitido dtes");
            }
            else
            {
                return false;
            }
        }

        //estados en los que se debe emitir fact o boleta:
        $estados_arr = Funciones::get_estados_dte_arr();

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html($estados_arr, "Estados de pedidos permitidos para emitir dte  para el pedido id=$order_id, actualmen te en estado= '$status'");
        }
        //si el estado del pedido no está entre los permitidos, se retorna false ahora
        if( !in_array($status, $estados_arr) )
        {
            return false;
        }

        return true;
    }

    public function is_for_nota_venta($order)
    {
        $order_id = $order->get_id();
        $modo_pago = $billing_paymethod = get_post_meta($order_id, '_payment_method', true);
        $status = $order->get_status();

        //si ya se ha emitido nv, no se emite
        //bsale_docto_id_nv
        $bsale_docto_id_nv = (int) get_post_meta($order_id, 'bsale_docto_id_nv', true);

        //nv ya se ha creado, se omite
        if( $bsale_docto_id_nv > 0 )
        {
            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("Ya se ha emitido nv para el pedido id=$order_id, actualmen te en estado= '$status'");
            }
            else
            {
                return false;
            }
        }

        //estados en los que se debe emitir nv:
        $estados_arr = Funciones::get_estados_nv_arr();

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html($estados_arr, "Estados de pedidos permitidos para emitir nv  para el pedido id=$order_id, actualmen te en estado= '$status'");
        }
        //si el estado del pedido no está entre los permitidos, se retorna false ahora
        if( !in_array($status, $estados_arr) )
        {
            return false;
        }

        $payments_nv = Funciones::get_pagos_nv();
        //emito nv para todas las ventas en este estado?
        if( $payments_nv === 'all' )
        {
            return true;
        }

        if( !empty($payments_nv) )
        {
            $arr_pagos = explode(',', $payments_nv);
        }
        else
        {
            $arr_pagos = array();
        }


        foreach( $arr_pagos as $p )
        {
            $p = trim($p);
            $res = strcasecmp($modo_pago, $p);

            if( $res == 0 )
            {
                return true;
            }
        }

        return false;
    }

    /**
     * anula dts en Bsale
     * si solo hay NV, hace un DELETE a la nv
     * si hay boleta o factura, genera NC
     * @param type $order_id
     * @return boolean
     */
    public static function anular_dte_bsale($order_id)
    {
        $me = new WpBsale();

        $order = new WC_Order($order_id);

        if( empty($order) )
        {
            return null;
        }
        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("anular_dte_bsale(order id=$order_id)");
        }

        $order_number = $order->get_order_number();
        //se ha emitido nc?
        $bsale_nc_id = (int) get_post_meta($order_id, 'bsale_docto_id_nc', true);

        if( $bsale_nc_id > 0 )
        {
            if( isset($_REQUEST['test_dte']) )
            {
                $bsale_docto_id_nc_url = get_post_meta($order_id, 'bsale_docto_id_nc_url', true);
                Funciones::print_r_html("anular_dte_bsale(order id=$order_id), ya se ha emitido NC id=$bsale_nc_id, url=$bsale_docto_id_nc_url");
            }
            return false;
        }

        //url de dtes
        $bsale_docto_id_nv_url = get_post_meta($order_id, 'bsale_docto_id_nv_url', true);
        $bsale_docto_id_factura_url = get_post_meta($order_id, 'bsale_docto_id_factura_url', true);
        $bsale_docto_id_boleta_url = get_post_meta($order_id, 'bsale_docto_id_boleta_url', true);
        $bsale_docto_id_nc_url = get_post_meta($order_id, 'bsale_docto_id_nc_url', true);

        //folios de dtes
        $bsale_docto_folio_nv = get_post_meta($order_id, 'bsale_docto_folio_nv', true);
        $bsale_docto_folio_boleta = get_post_meta($order_id, 'bsale_docto_folio_boleta', true);
        $bsale_docto_folio_factura = get_post_meta($order_id, 'bsale_docto_folio_factura', true);
        $bsale_docto_folio_nc = get_post_meta($order_id, 'bsale_docto_folio_nc', true);

        //tiene boleta o factura?
        $has_bol_or_factura = false;
        $has_nv = false;

        //si tiene boleta, emito NC para la boleta
        if( !empty($bsale_docto_id_boleta_url) )
        {
            $has_bol_or_factura = true;
        }
        //si tiene factura, emito NC para la factura
        if( !empty($bsale_docto_id_factura_url) )
        {
            $has_bol_or_factura = true;
        }
        //solo tiene nv?
        if( !empty($bsale_docto_id_nv_url) )
        {
            $has_nv = true;
        }

        //si no tiene dts, no hago nada
        if( !$has_bol_or_factura && !$has_nv )
        {
            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("anular_dte_bsale(order id=$order_id) no tiene boly, fact ni NV. No se hace nada.");
            }
            return true;
        }

        $bsale_dte = new BsaleDTE();

        //si ntiene bol o factura, creo NC
        if( $has_bol_or_factura )
        {
            //veo si ha sido declarada al SII
            $factura_id = get_post_meta($order_id, 'bsale_docto_id_factura', true);
            $boleta_id = get_post_meta($order_id, 'bsale_docto_id_boleta', true);

            //encuentro el tiupo de dte a anualar
            $tipo_dte = !empty($factura_id) ? 'factura' : 'boleta';

            $tipo_documento = $tipo_dte;
            $tipo_docto_nombre = $tipo_dte;

            //id del dte
            $dte_id = $tipo_dte === 'boleta' ? $boleta_id : $factura_id;

            //get sucursal desde donde fue emitida
            $doc = new Documento();

            $doc_details = $doc->get_docto($dte_id);

            $sucursal_id = isset($doc_details['office']['id']) ? $doc_details['office']['id'] : 0;
            $informedSii = isset($doc_details['informedSii']) ? $doc_details['informedSii'] : -1;
            $dte_folio = isset($doc_details['number']) ? $doc_details['number'] : '';

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("anular_dte_bsale(order id=$order_id), debo anular $tipo_dte id=$dte_id, folio $dte_folio, "
                        . "de sucursal id=$sucursal_id, estado en SII=$informedSii");
            }

            //si no es cero, no ha sido declarada o fue rechazada por el sii, solo se hace DELETE
            //parece que siempre debo hacer nc
            // 0 es correcto, 1 es enviado, 2 es rechazado (Integer).
            if( $informedSii == 2 )
            {
                //puedo usar la clase NV, pues llama al delete de Bsale sin distinguir el tipo de dte (bol, fact, nv, etc)
                $nv = new NotaVenta();

                //solo debo hacer DELETE de la nv
                $result = $nv->delete_nv($dte_id, $sucursal_id);

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html($result, "anular_dte_bsale(order id=$order_id), estado en SII=$informedSii no aporbado, hago DELETE, anular $tipo_dte id=$dte_id, folio $dte_folio, "
                            . "de sucursal id=$sucursal_id, respuesta");
                }

                //error?
                $error_msg = isset($result['error']) ? $result['error'] : null;

                //exito en la anualcion
                if( empty($error_msg) )
                {
                    $str_note = "Pedido cancelado. $tipo_documento folio #$dte_folio ha sido borrada (" . print_r($result, true) . ")";

                    update_post_meta($order_id, "bsale_docto_id_{$tipo_documento}", ''); //id doc en Bsale
                    update_post_meta($order_id, "bsale_docto_id_{$tipo_documento}_url", ''); //url
                    update_post_meta($order_id, "bsale_docto_folio_$tipo_documento", ''); //folio
                    update_post_meta($order_id, 'bsale_docto_error', ''); //limpio error

                    $note = $str_note;
                    // Add the note
                    $note_id = $order->add_order_note($note);

                    //no hago return, pues si hay nv, debo anularla más abajo
                }
                //error
                else
                {
                    $error_msg = isset($result['error']) ? $result['error'] : print_r($result, true);
                    $str_note = "Pedido cancelado:  $tipo_documento folio #$dte_folio ERROR: $error_msg";

                    update_post_meta($order_id, 'bsale_docto_error', $str_note);
                    //update_post_meta($order_id, 'bsale_docto_tipo', $str_note);

                    $note = $str_note;
                    // Add the note
                    $note_id = $order->add_order_note($note);
                }
                //no hago return, pues si hay nv, debo anularla más abajo
            }
            //genero NC, no se hace DELETE de NV
            elseif( !empty($sucursal_id) )
            {
                $tipo_documento_nc = 'nc';
                $tipo_docto_nombre_nc = 'Nota de crédito';

                $result = $bsale_dte->crear_nc_bsale($order_number, null, $order_id);

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html($result, "anular_dte_bsale(order id=$order_id), estado en SII=$informedSii emitido, "
                            . "hago NC, respuesta");
                }

                //msge de exito
                if( isset($result['urlPublicView']) )
                {
                    $str_note = "ver <a href='{$result['urlPublicView']}' target='_blank'>"
                            . "$tipo_docto_nombre_nc #{$result['number']} para $tipo_documento folio #$dte_folio</a>";


                    update_post_meta($order_id, "bsale_docto_id_{$tipo_documento_nc}", $result['id']); //id doc en Bsale
                    update_post_meta($order_id, "bsale_docto_id_{$tipo_documento_nc}_url", $result['urlPublicView']); //url
                    update_post_meta($order_id, "bsale_docto_folio_{$tipo_documento_nc}", $result['number']); //folio
                    update_post_meta($order_id, 'bsale_docto_error', ''); //limpio error

                    $note = $str_note;
                    // Add the note
                    $note_id = $order->add_order_note($note);
                }
                else
                {
                    $error_msg = isset($result['error']) ? $result['error'] : print_r($result, true);
                    $str_note = "$tipo_docto_nombre folio #$dte_folio, $tipo_docto_nombre_nc ERROR: $error_msg";

                    update_post_meta($order_id, 'bsale_docto_error', $str_note);
                    //update_post_meta($order_id, 'bsale_docto_tipo', $str_note);

                    $note = $str_note;
                    // Add the note
                    $note_id = $order->add_order_note($note);
                }
                return $result;
            }
        }

        //si llego hasta aquí, solo puedo hacer DELETE nv
        if( $has_nv )
        {
            $nv_id = get_post_meta($order_id, 'bsale_docto_id_nv', true);
            //get sucursal desde donde fue emitida
            $doc = new Documento();

            $doc_details = $doc->get_docto($nv_id);
            $sucursal_id = isset($doc_details['office']['id']) ? $doc_details['office']['id'] : 0;
            $dte_folio = isset($doc_details['number']) ? $doc_details['number'] : '';

            //doc no existe en bsale
            if( $sucursal_id <= 0 )
            {
                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("anular_dte_bsale(order id=$order_id) nv id= #$nv_id no existe en Bsale. No se hace nada");
                }
            }

            $nv = new NotaVenta();

            //solo debo hacer DELETE de la nv
            $result = $nv->delete_nv($nv_id, $sucursal_id);

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html($result, "anular_dte_bsale(order id=$order_id), DELETE de nv, respuesta");
            }

            //error?
            $error_msg = isset($result['error']) ? $result['error'] : null;

            $tipo_documento = 'nv';
            $tipo_docto_nombre = 'Nota de venta';

            //exito en la anualcion
            if( empty($error_msg) )
            {

                $str_note = "Pedido cancelado. $tipo_docto_nombre folio #$dte_folio ha sido borrada</a>";

                update_post_meta($order_id, "bsale_docto_id_{$tipo_documento}", ''); //id doc en Bsale
                update_post_meta($order_id, "bsale_docto_id_{$tipo_documento}_url", ''); //url
                update_post_meta($order_id, "bsale_docto_folio_$tipo_documento", ''); //folio
                update_post_meta($order_id, 'bsale_docto_error', ''); //limpio error

                $note = $str_note;
                // Add the note
                $note_id = $order->add_order_note($note);
            }
            //error
            else
            {
                $error_msg = isset($result['error']) ? $result['error'] : print_r($result, true);
                $str_note = "Pedido cancelado. $tipo_docto_nombre folio #$dte_folio ERROR: $error_msg";

                update_post_meta($order_id, 'bsale_docto_error', $str_note);
                //update_post_meta($order_id, 'bsale_docto_tipo', $str_note);

                $note = $str_note;
                // Add the note
                $note_id = $order->add_order_note($note);
            }
        }
        return true;
    }

    /**
     * para valores de comuna creados con select de plugin de checkout
     * @param type $order_id
     * @param type $comuna_key
     * @param type $pais
     * @return type
     */
    public static function get_comuna_value_checkout_field($order_id, $comuna_key, $pais = 'CL')
    {
        $fields = WC()->countries->get_address_fields(WC()->countries->get_base_country(), 'billing_');
        foreach( $fields as $name => $field )
        {
            if( $name !== $comuna_key )
            {
                continue;
            }
            $value = get_post_meta($order_id, $name, true);
            if( !empty($value) )
            {
                if( isset($_REQUEST['param']) )
                {
                    Funciones::print_r_html($field, "field checkout name='$name', value='$value'");
                }


                $type = isset($field['type']) ? $field['type'] : false;

                if( $type === 'select' || $type === 'radio' )
                {
                    $options = isset($field['options']) ? $field['options'] : array();

                    if( isset($options[$value]) && !empty($options[$value]) )
                    {
                        $value = $options[$value];
                    }

                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html("texto para key $comuna_key='$value'");
                    }
                    return $value;
                }
            }
        }
    }

    public static function get_comuna_value($comuna_key, $pais = 'CL')
    {
        $pais = Funciones::get_pais();

        $countries_obj = new WC_Countries();
        $default_county_states = $countries_obj->get_states($pais);

        if( isset($_REQUEST['test_dte']) )
        {
            //Funciones::print_r_html($default_county_states, "get_comuna_value($comuna_key, $pais, comunas ");
        }

        $res = isset($default_county_states[$comuna_key]) ? $default_county_states[$comuna_key] : null;

        return $res;
    }

    /**
     * devuelve listado de fees (impuestos) de la order wc
     * @param type $order
     */
    public static function get_fees_order($order)
    {

        $fees_arr = $order->get_fees();
        $iva = Funciones::get_valor_iva();

        $arraux = array();

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("get_fees_order, resultado");
        }
        foreach( $fees_arr as $fee )
        {
            $name = $fee->get_name();
            $total = $fee->get_total();

            if( Funciones::is_descontar_iva_precios() )
            {
                $neto = $total / $iva;
            }
            else
            {
                $neto = $total;
            }
            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("nombre fee: '$name' $ $total");
            }

            $arraux[] = array(
                'quantity' => 1, //added by l sd
                'netUnitValue' => $neto,
                'discount' => 0,
                'comment' => $name,
                'taxId' => "[" . IMPUESTO_IVA_ID . "]",
                    //'glossCost' => $neto_envio,
            );
        }

        return $arraux;
    }

    /**
     * devuelve el stock en gramos que se debe enviar a Bsale cuando se vende 1 unidad de este
     * prodcuto en woocoommerce.
     * Ejemplo: nombre = "250 gr." funcion devuelve 250/1000 = 0.25 de stock a descontar en Bsale por cada unidad vendida
     * @param type $product_name
     * @param type $original_stock
     */
    public function get_gramaje_unidades($product_name, $original_stock, $reguex)
    {
        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("get_gramaje_unidades, reviso producto '$product_name' con stock=$original_stock, reguex=$reguex");
        }
        if( function_exists('bsale_wc_filter_reguex_gramaje') )
        {
            return bsale_wc_filter_reguex_gramaje($product_name, $original_stock, $reguex);
        }
        return $original_stock;
    }

    public static function crear_dte_bsale($order_id)
    {
        $utils = new Utils();
        $me = new WpBsale();

        $order = new WC_Order($order_id);

        if( empty($order) )
        {
            return null;
        }

        //categorias a skip de la boleta
        $categs_to_skip = null; //array( 215 );
        //prodcutos de la orden pueden venir con gramaje?
        $is_gramaje_items = Funciones::is_gramaje_productos();
        $gramaje_reguex = Funciones::get_gramaje_reguex();

        $fees_arr = self::get_fees_order($order);

        //precios tienen impuesto?
        $prices_include_tax = get_option('woocommerce_prices_include_tax');

        $prices_include_tax = $prices_include_tax === 'no' ? false : true;

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("precio incluyen impuesto? '$prices_include_tax'");
        }

        $order_number = $order->get_order_number();
        //reviso que order no haya emitido doc
        $tipo_docto_meta = get_post_meta($order_id, 'bsale_docto_tipo', true);

        //si viene test dte, solo es para ver, no para emitir
        if( !isset($_REQUEST['test_dte']) )
        {
            //ya se ha emitido dte para esta orden
            if( $tipo_docto_meta === 'boleta' || $tipo_docto_meta === 'factura' )
            {
                return false;
            }
        }
        //INCLUIR DAtos de webpay en dtes?
        $incluir_webpay = defined('WC_INCLUIR_WEBPAY_PAGO') ? WC_INCLUIR_WEBPAY_PAGO : false;

        if( $incluir_webpay )
        {
            $webpay_transaction_id = get_post_meta($order_id, 'webpay_transaction_id', true);
            $cardNumber = get_post_meta($order_id, 'cardNumber', true);

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("debo incluir datos para webpay. Transacc id: '$webpay_transaction_id', tarjeta: '$cardNumber'");
            }
        }
        else
        {
            $webpay_transaction_id = $cardNumber = null;
        }

        //Return the order statuses without wc- internal prefix.
        $estado_orden = $order->get_status();

        //cliente id
        $myuser_id = (int) $order->get_user_id(); //user_id;
        //toda las info de billing como texto formateado
        //  $billing_address = $order->get_billing_address();
        //info de billing por separado
        $billing_first_name = get_post_meta($order_id, '_billing_first_name', true);
        $billing_last_name = get_post_meta($order_id, '_billing_last_name', true);
        $billing_company = get_post_meta($order_id, '_billing_company', true);
        //en caso de que no se pueda usar 
        $billing_company = empty($billing_company) ? get_post_meta($order_id, '_billing_company2', true) : $billing_company;

        $billing_address = get_post_meta($order_id, '_billing_address_1', true);
        $billing_address2 = get_post_meta($order_id, '_billing_address_2', true);
        $billing_city = get_post_meta($order_id, '_billing_city', true);
        $billing_city = $billing_city === '---' ? '' : $billing_city;
        $billing_comuna = get_post_meta($order_id, '_billing_state', true);
        $billing_comuna = empty($billing_comuna) ? get_post_meta($order_id, 'comuna', true) : $billing_comuna;

        $billing_comuna_value = get_post_meta($order_id, '_billing_state', true);
        $shipping_comuna = get_post_meta($order_id, '_shipping_state', true);

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("city: $billing_city, comuna $billing_comuna");
        }

        //billing comuna value
        $comuna_value = self::get_comuna_value($billing_comuna);

        if( empty($comuna_value) )
        {
            $comuna_value = self::get_comuna_value_checkout_field($order_id, 'comuna');
        }

        $billing_comuna = !empty($comuna_value) ? $comuna_value : $billing_comuna;


        if( empty($billing_city) )
        {
            $billing_city = get_post_meta($order_id, 'billing_localidad', true);
        }
        if( empty($billing_city) )
        {
            $billing_city = $billing_comuna;
        }

        $billing_municip = get_post_meta($order_id, '_billing_state', true);

        $billing_postcode = get_post_meta($order_id, '_billing_postcode', true);
        $billing_country = get_post_meta($order_id, '_billing_country', true);
        //esta no se usa, contiene la región. Bsale no tiene campo para la región:
        $billing_state = get_post_meta($order_id, '_billing_state', true);
        $billing_email = get_post_meta($order_id, '_billing_email', true);
        $billing_phone = get_post_meta($order_id, '_billing_phone', true);
        $billing_paymethod = get_post_meta($order_id, '_payment_method', true);
        $billing_paymethod_title = get_post_meta($order_id, '_payment_method_title', true);




        //tipo docto que requiere el comprador: boleta, factura
        $tipo_documento = get_post_meta($order_id, '_billing_tipo_documento', true);
        $tipo_documento = empty($tipo_documento) ? get_post_meta($order_id, 'billing_tipo_documento', true) : $tipo_documento;

        $tipo_documento = strtolower($tipo_documento);

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("billing_tipo_documento para order $order_number: '$tipo_documento'");
        }


        $tipo_documento_original = $tipo_documento;
        //rut del comprador
        $billing_rut = get_post_meta($order_id, '_billing_rut', true);
        $billing_rut = empty($billing_rut) ? strtolower(get_post_meta($order_id, 'billing_rut', true)) : $billing_rut;

        //en caso de que rut viene con ---. no es obligatorio, se emite boleta y se deja en blanco
        $billing_rut = $billing_rut === '11111111-1' ? '' : $billing_rut;

        //en caso de que venga referencia para orden de compra (solo para facturas)
        $billing_oc_folio = get_post_meta($order_id, 'billing_oc_folio', true);
        $billing_oc_fecha = get_post_meta($order_id, 'billing_oc_fecha', true);
        $billing_oc_referencia = get_post_meta($order_id, 'billing_oc_referencia', true);

        //DIRECCION de despacho
        $shipping_address = $order->get_formatted_shipping_address();
        $shipping_address = str_replace('<br/>', '; ', $shipping_address);
        $shipping_address = str_replace('<br>', '; ', $shipping_address);


        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("direccion de despacho para order $order_number: '$shipping_address'");
        }


        if( Funciones::get_pais() === 'PE' && empty($billing_rut) )
        {
            $billing_rut = get_post_meta($order_id, '_billing_dni', true);
        }

        //giro, en  caso de factura
        $billing_giro = get_post_meta($order_id, '_billing_giro', true);
        $billing_giro = empty($billing_giro) ? strtolower(get_post_meta($order_id, 'billing_giro', true)) : $billing_giro;

        //nota que el comprador dejó en el checkout
        $nota_cliente = $order->get_customer_note();
        $nota_cliente = $utils->filter_chars($nota_cliente);

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("tipo_documento='$tipo_documento' antes (nota comprador: '$nota_cliente')");
        }

        $tipo_documento = empty($tipo_documento) ? 'boleta' : $tipo_documento;

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("tipo_documento='$tipo_documento' despues");
        }


        //medio de pago
        $billing_pago = get_post_meta($order_id, '_payment_method', true);

        //veo medio de pago, débito o crédito
        if( $billing_pago === 'Crédito' )
        {
            $tipo_pago = 'credito';
        }
        else if( $billing_pago === 'Débito' )
        {
            $tipo_pago = 'debito';
        }
        else
        {
            $tipo_pago = $billing_pago;
        }

        $is_only_prods_with_tax_class = Funciones::is_only_dte_to_products_with_tax_class();
        //$tax_class_allowed_arr
        //por si solo hay que inlcuir prodcuto con tax class 
        if( $is_only_prods_with_tax_class )
        {
            $tax_class_exentos_arr = Funciones::get_tax_class_exentos_for_dte();

            //en caso de que no haya indicado tax clasee
            if( !is_array($tax_class_exentos_arr) || count($tax_class_exentos_arr) <= 0 )
            {
                $is_only_prods_with_tax_class = false;
                if( isset($_REQUEST['param']) )
                {
                    Funciones::print_r_html($tax_class_exentos_arr, "distinguir prods afectos de exentos es true, pero "
                            . "no se ha indicado tax class para prods exentos, se omite regla");
                }
            }
            else
            {
                if( isset($_REQUEST['param']) )
                {
                    Funciones::print_r_html($tax_class_exentos_arr, "Se distinguen prods afectos de exentos, al emitir dte exenta o afecta");
                }
            }
        }
        else
        {
            $tax_class_exentos_arr = null;
        }

        //shipping
        $costo_envio = $order->get_shipping_total(); //$order->get_total_shipping();
        $impuesto_envio = $order->get_shipping_tax();
        $neto_envio = $costo_envio; // round($costo_envio - $impuesto_envio);
        //impuestos
        $iva = Funciones::get_valor_iva();

        $orden_impuestos = $order->get_total_tax();
        $order_total = $order->get_total(); //Gets order total.


        if( $orden_impuestos > 0 )
        {
            $order_neto = ($order_total / $iva);
        }
        else
        {
            $order_neto = $order_total; // / $iva;
        }

        //dte afecto o exento
        if( $is_only_prods_with_tax_class )
        {
            $order_neto = $order_total - $orden_impuestos;
        }


        // $order_neto = ($order_total - $orden_impuestos);
        // $order_neto = $order_total / $iva;


        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("wp_>crea dte bsale order neto: $ $order_neto, order impuestos: $ $orden_impuestos");
        }

        //si es cero, etonces o hay ada que enviar
        if( $order_neto <= 0 )
        {
            return;
        }


        //listado productos comprados
        $items = $order->get_items();

        //totales de la orden
        $totales = $order->get_order_item_totals();

        // $arraux = array( "$billing_address $billing_address2"/*, $billing_city, $billing_state*/ );
        //direecion
        $direccion = "$billing_address $billing_address2"; //implode(', ', $arraux);
        //datos del cliente registrado
        $fname = get_user_meta($myuser_id, 'billing_first_name', true);
        $lname = get_user_meta($myuser_id, 'billing_last_name', true);
        $empresa = get_user_meta($myuser_id, 'billing_company', true);
        $email = get_user_meta($myuser_id, 'billing_email', true);

        $address_1 = get_user_meta($myuser_id, 'billing_address_1', true);
        $address_2 = get_user_meta($myuser_id, 'billing_address_2', true);
        $city = get_user_meta($myuser_id, 'billing_city', true);
        $direccion2 = "$address_1 $address_2";

        //si no vienen en la orden, los extraigo de los datos del cliente
        $billing_first_name = empty($billing_first_name) ? $fname : $billing_first_name;
        $billing_last_name = empty($billing_last_name) ? $lname : $billing_last_name;

        $direccion = empty($direccion) ? $direccion2 : $direccion;
        $billing_city = empty($billing_city) ? $city : $billing_city;
        $billing_company = empty($billing_company) ? $empresa : $billing_company;
        $billing_giro = empty($billing_giro) ? '' : $billing_giro;

//me vuelvo a asegurar
        $direccion = empty($direccion) ? '' : $direccion;
        $billing_company = empty($billing_company) ? '' : $billing_company;

        $billing_comuna = empty($billing_comuna) ? $billing_city : $billing_comuna;



        $direccion = $utils->filter_chars($direccion);
        $billing_city = $utils->filter_chars($billing_city);
        $billing_giro = $utils->filter_chars($billing_giro);
        $billing_first_name = $utils->filter_chars($billing_first_name);
        $billing_last_name = $utils->filter_chars($billing_last_name);

        //solo facturacion a Chile
        if( $billing_country !== 'CL' )
        {
            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("pais no es CL, no se emite nada");
            }
            //return;
        }

        //si es orden valida para dte
        if( !$me->is_valid_for_dte($order) )
        {
            $note = "Este pedido no genera DTE";
            update_post_meta($order_id, 'bsale_docto_error', $note);
            // Add the note
            $order->add_order_note($note);
            //Funciones::print_r_html("$order_id en estado= {$order->get_status()} no puede generar dte");
            return false;
        }

        //segun el estado, determino si debo emitir boleta o nv
        if( $me->is_for_nota_venta($order) )
        {
            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("genero nv, para pedido $order_number");
            }
            $tipo_documento = 'nv';
        }

        //on-hold no emite boleta ni factura, pues no se ha pagado el pedido
        if( $estado_orden === 'on-hold' && $tipo_documento !== 'nv' )
        {
            //Funciones::print_r_html("on-hold y no nv, skip : $tipo_documento");
            return;
        }

        //ahora, ¿se puede emitir dte: bol o fact, para este pedido?
        if( $tipo_documento === 'boleta' || $tipo_documento === 'factura' )
        {
            if( !$me->is_for_dte($order) )
            {
                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("pedido $order_number no emite DTE (excepto en modo de pruebas)");
                }
                //test no retorna
                if( !isset($_REQUEST['test_dte']) )
                {
                    return;
                }
            }
        }


        //asigno $tipo_docto
        switch( $tipo_documento )
        {
            case 'boleta':
                $tipo_docto = 'b';
                break;
            case 'factura':
                $tipo_docto = 'f';
                break;
            case 'nv':
                $tipo_docto = 'nv';
                break;
            case 'gd':
                $tipo_docto = 'gd';
                break;
            default:
                $tipo_docto = 'b';
                break;
        }


        //default, persona
        $companyOrPerson = 0;

        //peru, facturas exigen RUC y DF
        if( Funciones::get_pais() === 'PE' && $tipo_documento_original === 'factura' )
        {
            //ruc empresa
            $billing_RUC = get_post_meta($order_id, '_billing_ruc', true);
            $billing_rut = !empty($billing_RUC) ? $billing_RUC : '';

            //direccion fiscal empresa
            $billing_df = get_post_meta($order_id, '_billing_direccion_fiscal', true);
            $direccion = !empty($billing_df) ? $billing_df : '';

            if( empty($billing_RUC) || empty($direccion) )
            {
                $error_msg = "Falta RUC o dirección fiscal";
                $str_note = "Factura ERROR: $error_msg";

                update_post_meta($order_id, 'bsale_docto_error', $str_note);
                //update_post_meta($order_id, 'bsale_docto_tipo', $str_note);

                $note = $str_note;
                // Add the note
                $order->add_order_note($note);

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("ERROR pedido $order_number para pais " . Funciones::get_pais() . ": $error_msg");
                }
                return false;
            }
            $companyOrPerson = 1;

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("Peru, se requiere factura: RUC = $billing_RUC, empresa= $companyOrPerson, "
                        . "tipo_docto='$tipo_docto', tipo_documento_original='$tipo_documento_original'");
            }
        }

        $billing_city = empty($billing_city) ? $billing_comuna : $billing_city;


        /* $tipo_venta = get_post_meta($order_id, '_wc_acof_2', true);

          if($tipo_venta==='ventaentienda' || $tipo_venta==='cornershop')
          {
          $billing_rut = '66666666-6';
          } */


        $datos_cliente = array(
            //'direccion' => $direccion,
            'code' => $billing_rut,
            'city' => substr($billing_comuna, 0, 30),
            'company' => $billing_company,
            'municipality' => $billing_city, //comuna
            'activity' => $billing_giro,
            'address' => $direccion,
            'email' => $billing_email,
            'phone' => $billing_phone,
            'firstName' => $billing_first_name,
            'lastName' => $billing_last_name,
            'companyOrPerson' => $companyOrPerson, //si pidió factura, se cambia a 1 
                //estos se hacen unset antes de enviarlos a Bsale
                // 'tipo_pago' => $tipo_pago,
                //'total' => $order_total,
        );

        //perú exige distrito
        if( Funciones::get_pais() === 'PE' )
        {
            $datos_cliente['district'] = $billing_comuna;
        }

        //formateo segun si es boleta o factura
        if( $tipo_documento_original === 'factura' )
        {
            $datos_cliente['companyOrPerson'] = 1;
            //empresa es nombre y apellido
            //$datos_cliente['company'] = empty($billing_company) ? "$billing_first_name $billing_last_name" : $billing_company;
            //unset($datos_cliente['firstName']);
            //unset($datos_cliente['lastName']);
        }
        else
        {
            $datos_cliente['companyOrPerson'] = 0;
            unset($datos_cliente['company']);
        }

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html($datos_cliente, "datos cliente, antes de filter cliente:");
        }
        //valido rut y otros        
        $datos_cliente = $utils->filter_client_bsale($datos_cliente);

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html($datos_cliente, "datos cliente, despues de filter cliente:");
        }

        //para guardar datos de los productos
        $datos_items = array();
        //suma de los valores de cada producto
        $total_productos = 0;

        $set_discount_from_regular_price = Funciones::set_descto_on_regular_price();

        $total_neto_calculado = 0;

        //veo si este medio de envio está asociado a una sucursal de bsale, para generar la boleta en esa sucursal
        $shipping_arr = $utils->get_array_medios_envio();
        $shipping_name_orig = $order->get_shipping_method();
        $shipping_name = $utils->filter_chars($shipping_name_orig);
        $shipping_name = strtolower($shipping_name);

        $sucursal_bsale_to_send = isset($shipping_arr[$shipping_name]) ? $shipping_arr[$shipping_name] : -1;

        //tiene retiro en tienda con tienda asociada?
        $sucursal_para_retiro_tienda = $utils->get_sucursal_retiro_tienda($order_id, $shipping_name);

        if( $sucursal_para_retiro_tienda == 9999 )
        {
            $sucursal_bsale_to_send = $sucursal_para_retiro_tienda;
        }
        else
        {
            $sucursal_bsale_to_send = isset($shipping_arr[$sucursal_para_retiro_tienda]) ? $shipping_arr[$sucursal_para_retiro_tienda] : $sucursal_bsale_to_send;
        }

        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html($shipping_arr, "array de medios de envio order enviada por '$shipping_name' (orig: '$shipping_name_orig'), suc bsale asociada a tienda de retiro '$sucursal_para_retiro_tienda'=$sucursal_bsale_to_send");
        }

        //debo emitir dte segun comuna de fact? $shipping_comuna es comuna de shipping
        $sucursal_comuna_id = $me->get_sucursal_comuna_to_send($billing_comuna);
        $sucursal_bsale_to_send = $sucursal_comuna_id > 0 ? $sucursal_comuna_id : $sucursal_bsale_to_send;

        //para prods only in bsale
        $bsale_sucursal_id = Funciones::get_matriz_bsale();

        $bsale_sucursal_id = $sucursal_bsale_to_send > 0 ? $sucursal_bsale_to_send : $bsale_sucursal_id;


        //solo para agregar peso de productos a la boleta/factura
        $peso_total = 0;
        //será true si no tgodos los prods del pedido están incluídos en el dte
        $dte_parcial = false;



        //cambiará si es que se debe emitir dte exento
        if( $is_only_prods_with_tax_class )
        {
            $is_dte_afecto = false;
        }


        foreach( $items as $item )
        {
            //iva puede ser modificado dentro del bucle, para los productos exentos y afectos
            $iva_prod = $iva;

            //$item_meta = $item['item_meta'];
            $cantidad = (int) $item['qty'];
            //default, solo aplica si $is_only_prods_with_tax_class = true
            //en caso contrario, se emite boleta afecta o exenta según constantes
            $is_prod_afecto = true;

            //peso para este producto
            $weight = 0;

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html($item, "item:");
            }

            //compatibilidad con distintas vewrsiones de WC
            if( is_a($item, 'WC_Order_Item_Product') )
            {
                $product_id = $item->get_product_id();
                $product_variation_id = $item->get_variation_id();
                //Funciones::print_r_html("item es 'WC_Order_Item_Product':$product_id, $product_variation_id");
            }
            else
            {
                $product_id = $item['product_id'];
                $product_variation_id = $item['variation_id'];
            }

            //categs to skip de la boleta
            if( isset($categs_to_skip) && is_array($categs_to_skip) )
            {
                if( $_REQUEST['param'] )
                {
                    Funciones::print_r_html($categs_to_skip, "categs to skip");
                }

                //$categs_producto = get_the_category($product_id);
                $categs_producto = wp_get_post_terms($product_id, 'product_cat', array( 'fields' => 'ids' ));


                if( $_REQUEST['param'] )
                {
                    Funciones::print_r_html($categs_producto, "categs producto #$product_id");
                }

                $skip_prod = false;
                //alguna de las categs de este producto está en las categs to skip?
                foreach( $categs_producto as $cat_prod_id )
                {
                    $cat_prod_id = (int) $cat_prod_id;

                    if( in_array($cat_prod_id, $categs_to_skip) )
                    {
                        if( $_REQUEST['param'] )
                        {
                            Funciones::print_r_html("prod id=$product_id pertenece a categ to skip '$cat_prod_id'. Se omite");
                        }
                        $skip_prod = true;
                        break;
                    }
                }

                if( $skip_prod )
                {
                    if( $_REQUEST['param'] )
                    {
                        Funciones::print_r_html("prod id=$product_id pertenece a categ to skip '$cat_prod_id'. Se omite");
                    }
                    break;
                }
            }
            //en cvaso de que el producto no exista
            $product = new WC_Product($product_id);
            if( !$product )
            {
                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html($item, "no encotrado, se omite:");
                }
                continue;
            }

            //solo se incluyen prodcuto con cierto tax class
            if( $is_only_prods_with_tax_class )
            {
                $tax_class_product = $product->get_tax_class();

                if( isset($_REQUEST['param']) )
                {
                    Funciones::print_r_html("tax class producto: '$tax_class_product'");
                }

                if( is_array($tax_class_exentos_arr) && in_array($tax_class_product, $tax_class_exentos_arr) )
                {
                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html(" producto con tax class '$tax_class_product' EXENTO, se emitirá dte exento");
                    }
                    // $is_dte_afecto = false;
                    $is_prod_afecto = false;
                    $iva_prod = 1;
                }
                else
                {
                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html(" producto con tax class '$tax_class_product' afecto");
                    }
                    $is_dte_afecto = true;
                }
            }
            //fin solo se incluyen prodcuto con cierto tax class
            //
            //precio original, en caso de que en la order venga con precio=$0
            $product_original_price = $product->get_regular_price();

            $discount = 0; //porcentaje de descto, solo cambiará si orecio es $0 en la orden
            //sku del producto
            $sku = $product->get_sku();

            $product_variation = null;
            $variation_name = null;
            // Check if product has variation, para extraer el sku desde allí
            if( $product_variation_id )
            {
                $product_variation = new WC_Product_Variation($product_variation_id);

                if( $product_variation )
                {
                    $variation_name = current($product_variation->get_variation_attributes());
                    $skuvar = $product_variation->get_sku();

                    $sku = !empty($skuvar) ? $skuvar : $sku;

                    $product_original_price = $product_variation->get_regular_price();
                    //peso variacion
                    // $weight = $product_variation->get_weight() * $cantidad;
                    $auxpeso = (float) $product_variation->get_weight();
                    $weight = $auxpeso * $cantidad;
                }
                else
                {
                    $variation_name = null;
                }
                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("var name para sku='$sku': desde current(product_variation->get_variation_attributes(: '$variation_name'");
                }
            }
            else
            {
                //peso prod simple
                $auxpeso = (float) $product->get_weight();
                $weight = $auxpeso * $cantidad;
            }

            $nombre = $item['name'];
            if( !empty($variation_name) )
            {
                $nombre .= " $variation_name";
            }

            //agrego nombre de variante
            if( !empty($product_variation) )
            {
                $nombre .= ' ' . $product_variation->get_name();

                $variation_name = $product_variation->get_name();

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("var name para sku='$sku': desde product_variation->get_name():" . $product_variation->get_name());
                }
            }

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("var name para sku='$sku': '$variation_name'");
            }


            if( $cantidad <= 0 )
            {
                continue;
            }
            //producto viene sin precio, busco precio original y lo dejo con descto de 100%
            if( $item['line_total'] <= 0 /* && $tipo_docto !== 'nv' */ )
            {
                $discount = 100; //porcentaje
                //en caso de que este prod no tuviese precio en el producto, lo dejo en un default para
                //incluirlo en la orden
                $product_original_price = ($product_original_price > 0) ? $product_original_price : 9999;

                //este producto va con 100% de descto, busco precio original
                $item['line_total'] = $product_original_price * $cantidad;

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("producto precio $0 en la orden, "
                            . "busco precio regular: $ $$product_original_price, descto de % $discount :");
                }

                // continue;
            }

            //si debo mostrar el descto en base al precio regular del producto
            if( /* isset($_REQUEST['test_dte']) && */ $set_discount_from_regular_price && $product_original_price > 0 )
            {
                $precio_totalaux = $item['line_total'];
                //precio unitario del pedido
                $precio_netoaux = $precio_totalaux / $cantidad;

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("set descto en base a precio regular, precio unitario regular: $ $$product_original_price, precio uitario order: $ $precio_netoaux ");
                }

                //solo si precio regular es mayor a precio de orden
                if( $product_original_price > $precio_netoaux )
                {
                    //caclulo descto
                    $percent = $precio_netoaux * 100 / $product_original_price;
                    $discount = 100 - $percent;

                    if( $discount > 0 )
                    {
                        //set precio original como precio de item en la orden
                        $item['line_total'] = $product_original_price * $cantidad;
                    }
                    else
                    {
                        $discount = 0;
                    }


                    if( isset($_REQUEST['test_dte']) )
                    {
                        Funciones::print_r_html("set descto en base a precio regular, "
                                . "precio unitario regular: $ $$product_original_price, precio uitario order: $ $precio_netoaux, "
                                . "descto $discount");
                    }
                }
            }//fin set discount

            $precio_total = $item['line_total'];

            //precio que se pagó al comprar, necesario para sumar los totales
            if( $discount > 0 )
            {
                $precio_total_descto = $precio_total - ($precio_total * $discount / 100);

                $precio_total_descto = $precio_total_descto < 0 ? 0 : $precio_total_descto;
            }
            else
            {
                $precio_total_descto = $precio_total;
            }

            //este producto debe ser incluido en la boleta?
            if( Funciones::is_only_prods_bsale() /* && isset($_REQUEST['test_dte']) */ )
            {
                //veo si sku existe en bsale
                $res = true;

                $stock_bsale = $me->get_product_stock($sku, $bsale_sucursal_id);

                //producto no está en Bsale, se omite
                if( $stock_bsale <= 0 )
                {
                    //descuento prod del total de la orden
                    $order_neto -= $precio_total_descto;
                    //$total_neto_calculado -= $precio_total_descto;

                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html("prod sku='$sku' no está en Bsale, se omite del $tipo_docto. Precio prod: $ $precio_total_descto, "
                                . "order neto queda en $order_neto");
                    }
                    $dte_parcial = true;
                    continue;
                }
            }

            $impuesto = ($item['line_tax']);

            $precio_neto = $precio_total / $cantidad;

            if( WP_ORDER_COMPLETED_TEST )
            {
                Funciones::print_r_html("precios: neto $ $precio_neto = ( precio total $ $precio_total / cantidad $cantidad )");
            }

            //si es true, al eto debo sacarle el iva, pq en woocommerce este neto está
            //con iva
            //if( defined('BSALE_DESCONTAR_IVA_MANUAL') && BSALE_DESCONTAR_IVA_MANUAL === true )
            if( Funciones::is_descontar_iva_precios() )
            {
                $precio_neto = ( $precio_neto / $iva_prod );
            }
            else
            {
                //cuando precio viene sin iva, viene sin decimales
                //$precio_neto = (int)$precio_neto;
            }


            //ultima validacion de precio
            $precio_neto = $precio_neto < 0 ? 0 : $precio_neto;

            //$precio_neto = number_format($precio_neto, 4, ',', '');
            $arrauxitems = array(
                'quantity' => $cantidad,
                'netUnitValue' => $precio_neto,
                'taxId' => "[" . IMPUESTO_IVA_ID . "]",
                'discount' => $discount,
                'comment' => $nombre );

            //si envio el sku/barcode a bsale
            if( Funciones::is_send_sku() == true )
            {
                if( BSALE_IDENTIFICADOR_PRODUCTO === 'sku' && !empty($sku) )
                {
                    $arrauxitems['code'] = $sku;
                    unset($arrauxitems['comment']);
                }
                else if( !empty($sku) )
                {
                    $arrauxitems['barCode'] = $sku;
                    unset($arrauxitems['comment']);
                }

                //Transferencia a título gratuíto, solo Perú
                if( Funciones::get_pais() === 'PE' && $precio_neto <= 0 )
                {
                    $arrauxitems['comment'] = 'Transferencia a título gratuíto';
                }
            }
            if( defined('SKIP_IMPUESTO_IVA_ID') && SKIP_IMPUESTO_IVA_ID == true )
            {
                unset($arrauxitems['taxId']);
            }
            //dte afecto o exento, segun tax de productos
            if( $is_only_prods_with_tax_class && $is_prod_afecto == false )
            {
                unset($arrauxitems['taxId']);

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("producto exento, se quita el impuesto");
                }
            }

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html($arrauxitems, "wp_>crea dte bsale:item:");
            }

            $total_neto_calculado += ($precio_neto * $cantidad) - ( ($precio_neto * $cantidad) * $discount / 100);

            //es gramaje?
            if( $is_gramaje_items )
            {
                //$nombre
                $nombre_reguex = !empty($variation_name) ? $variation_name : $nombre;

                $new_cantidad_grs = $me->get_gramaje_unidades($nombre_reguex, $cantidad, $gramaje_reguex);


                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("wp_>crea dte bsale, es gramaje activado. Veo si  producto '$nombre' $cantidad unids. se vende por gramos o no.");
                }

                if( $new_cantidad_grs > 0 && $new_cantidad_grs != $cantidad )
                {
                    $quantity_old = $arrauxitems['quantity'];
                    $arrauxitems['quantity'] = $new_cantidad_grs;
                    //recalculo precio unitario                   
                    $precio_neto_unidad = ($precio_neto / $new_cantidad_grs) * $quantity_old;
                    $arrauxitems['netUnitValue'] = $precio_neto_unidad;

                    if( isset($_REQUEST['test_dte']) )
                    {
                        Funciones::print_r_html("wp_>crea dte bsale, producto sku='$sku' '$nombre' sí se vende por gramos."
                                . "cantidad original: $cantidad a $ $precio_neto la unidad. Cantidad por gramos: $new_cantidad_grs "
                                . "a $ $precio_neto_unidad el kilo");
                    }
                }
            }

            $datos_items[] = $arrauxitems;

            //sumo precios, si descto es de 100%, no sumo nada
            if( $discount < 100 )
            {
                $total_productos += $precio_total_descto;

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("total productos $ $total_productos  (+ $precio_total_descto)");
                }
            }

            //sumo peso 
            $peso_total += $weight;

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("peso producto sku='$sku': $weight");
            }
        }//fin foreach
        //si algun fee es negativo, no se debe agregar al dte, sino descontar su valor de entre los productos
        $desctos_neto = 0;


        //agrego fees
        $iva_fee = ($is_only_prods_with_tax_class && $is_dte_afecto == false) ? 1 : $iva;

        foreach( $fees_arr as $fee )
        {
            //solo fees positivos
            if( $fee['netUnitValue'] > 0 )
            {
                $datos_items[] = $fee;

                $total_productos += $fee['netUnitValue'] * $iva_fee;
                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html($fee, "agrego fee con iva de $" . $fee['netUnitValue'] * $iva_fee);
                }
            }
            else
            {
                $desctos_neto += $fee['netUnitValue']; // / $iva;
                // $total_productos -= $fee['netUnitValue'] * $iva;
                //$total_productos += $fee['netUnitValue'] * $iva;
                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html($fee, "fee negativo, agrego a desctos: " . $fee['netUnitValue']);
                }

                if( Funciones::is_descontar_iva_precios() )
                {
                    //sumo solo el impuesto del fee
                    $impuesto_fee = $fee['netUnitValue'] - ($fee['netUnitValue'] * $iva_fee);
                    $total_productos += $impuesto_fee;
                }
            }
        }

        if( $desctos_neto != 0 && isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("desctos neto a distribuir en el dte: $desctos_neto");
        }


        //agrego costo del envio
        $shipping_name_orig = $order->get_shipping_method();


        //veo si este medio de envio está asociado a una sucursal de bsale, para generar la boleta en esa sucursal
        // $shipping_arr = $utils->get_array_medios_envio();



        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html($shipping_name, "crea dte bsale: order->get_shipping_method()");
            //Funciones::print_r_html($shipping_data_arr, "crea dte bsale: get_order_shipping_method() data");
        }

        $envio_arr = null;
        $skip_shipping = !Funciones::is_add_shipping_in_dte();

        $iva_shipping = ($is_only_prods_with_tax_class && $is_dte_afecto == false) ? 1 : $iva;

        //si viene envio y no debo omitirlo en la boleta
        if( $neto_envio > 0 && !$skip_shipping )
        {
            if( Funciones::is_descontar_iva_precios() )
            {
                $neto_envio = ( $neto_envio / $iva_shipping );
            }
            elseif( defined('BSALE_DESCONTAR_IVA_MANUAL_ENVIO') && BSALE_DESCONTAR_IVA_MANUAL_ENVIO === true )
            {
                $neto_envio = ( $neto_envio / $iva_shipping );
            }


            //$neto_envio = number_format ($neto_envio, 6, ',', '');

            $envio_arr = array(
                'quantity' => 1, //added by l sd
                'netUnitValue' => $neto_envio,
                'discount' => 0,
                'comment' => $shipping_name_orig,
                'taxId' => "[" . IMPUESTO_IVA_ID . "]",
                'glossCost' => $neto_envio,
            );

            if( !Funciones::is_include_gloss_cost() )
            {
                unset($envio_arr['glossCost']);
            }

            //agrego sku de envío
            $envio_arr = $me->set_sku_envio($envio_arr, $tipo_docto);

            if( defined('SKIP_IMPUESTO_IVA_ID') && SKIP_IMPUESTO_IVA_ID == true )
            {
                unset($envio_arr['taxId']);
            }

            //dte afecto o exento, segun tax de productos
            if( $is_only_prods_with_tax_class && $is_dte_afecto == false )
            {
                unset($arrauxitems['taxId']);
            }

            if( isset($_REQUEST['test_dte']) )
            {
                $costo_envio_aux = $order->get_shipping_total();
                $impuesto_envio_aux = $order->get_shipping_tax();
                Funciones::print_r_html($envio_arr, "crea dte bsale: envio: total: $costo_envio_aux, impuesto $impuesto_envio_aux");
            }

            $total_neto_calculado += $neto_envio;
            $datos_items[] = $envio_arr;
            //sumo precios
            if( Funciones::is_descontar_iva_precios() )
            {
                $total_productos += $neto_envio * 1 * $iva_shipping; //antes estaba sin $iva
            }
            else
            {
                $total_productos += $neto_envio * 1; //antes estaba sin $iva
            }


            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("total productos $ $total_productos  (+ $neto_envio x $iva )");
            }
        }
        //si viene neto y debo omitirlo, entonces debo ajustar el total de la order
        elseif( $neto_envio > 0 && $skip_shipping )
        {
            $order_neto -= $neto_envio;
            //$total_neto_calculado -= $neto_envio;

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("se omite en $ de envio para orden $order_number: $ $neto_envio. Nuevo order neto: $ $order_neto");
            }
        }

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("total neto calculado: $ $total_neto_calculado, con iva: $ " . ($total_neto_calculado * $iva));
        }

        //en este caso, es posible que el total de la orden sea mayor, en caso 
        //de que tambien se hayan incluído prods con impuesto
        if( $is_only_prods_with_tax_class )
        {
            
        }

        $iva_desctos = ($is_only_prods_with_tax_class && $is_dte_afecto == false) ? 1 : $iva;

        //veo si hay desctos o ono
        if( (int) $total_productos != (int) $order_neto )
        {
            $total_descto_pesos = $total_productos - $order_neto;

            //le saco el iva a l diferencia
            //xxx a veces no se debe sacar iva, pues ya viene sin iva
            $total_descto_pesos = ($total_descto_pesos > 0) ? $total_descto_pesos / $iva_desctos : $total_descto_pesos;
            $total_descto_pesos = (int) $total_descto_pesos;

            if( $total_descto_pesos > 0 )
            {
                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html($datos_items, "wp_>crea dte bsale:prods antes de descto hay desctos total"
                            . " $total_productos != neto $order_neto = $ $total_descto_pesos a descontar:");
                }

                $datos_items = self::descontar_de_productos2($datos_items, $total_descto_pesos);

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html($datos_items, "wp_>crea dte bsale:prods DESPUES de descto, despues de ajuste de desctos $ $total_descto_pesos, orden: $order_neto ");
                }
            }
            else
            {
                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html($datos_items, "wp_>crea dte bsale: descuento es menor que cero, se omite ");
                }
            }
        }
        //cupones de descto
        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("cupones:");
            foreach( $order->get_coupon_codes() as $coupon_code )
            {
                Funciones::print_r_html($coupon_code, "cupon de esta orden:");
            }
        }

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("Voy a generar docto $tipo_documento");
        }

        //solo genero boleta si hay productos. Como es posible que se hayan omitido productos
        //entonces, debo asegurarme
        if( count($datos_items) <= 0 )
        {
            $str_note = "Este pedido #$order_number no emite boleta, pues no tiene  productos";

            if( Funciones::is_only_prods_bsale() )
            {
                $str_note = "Pedido #$order_number no emite documento, pues los productos no tienen stock en Bsale.";
            }

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html($str_note);
            }

            update_post_meta($order_id, 'bsale_docto_error', $str_note); //limpio error

            $note = $str_note;
            // Add the note
            $order->add_order_note($note);

            return true;
        }

        /* if( $dte_parcial )
          {
          update_post_meta($order_id, 'bsale_docto_error', "$tipo_docto parcial"); //limpio error
          } */


        $old_timezone = date_default_timezone_get();

        if( Funciones::get_pais() === 'PE' )
        {
            $timezone = 'America/Lima';
        }
        else
        {
            $timezone = 'America/Santiago';
        }

        date_default_timezone_set($timezone);
        ini_set("date.timezone", $timezone);


        $hoy = date('Y-m-d');
        $gmt_date = strtotime($hoy);
        $gmt_date_expiracion = $gmt_date;
        $hoy_from_timestamp = date('Y-m-d', $gmt_date);

        //referencias a oc, solo factura
        $references = array();

        //si viene folio o referencia
        if( !empty($billing_oc_folio) || !empty($billing_oc_referencia) )
        {
            $billing_oc_folio = empty($billing_oc_folio) ? '000' : $billing_oc_folio;
            $billing_oc_referencia = empty($billing_oc_referencia) ? $billing_oc_folio : $billing_oc_referencia;
            $billing_oc_referencia .= "(fecha: $billing_oc_fecha)";
            $billing_oc_fecha = strtotime($billing_oc_fecha);

            $references[] = array(
                'number' => $billing_oc_folio,
                'referenceDate' => $billing_oc_fecha,
                'reason' => $billing_oc_referencia,
                'codeSii' => 801, //801=orden de compra
            );
        }




        date_default_timezone_set($old_timezone);
        ini_set("date.timezone", $old_timezone);

        //solo usada si is_only_prods_bsale is true
        $new_order_total = $order_neto / Funciones::get_valor_iva();
        $modo_pago_arr = $me->get_modo_pago($order_id, $billing_pago, $gmt_date, $tipo_docto, $new_order_total);

        $tienda_nombre = '(WC)';

        $peso_total = $peso_total > 0 ? "$peso_total kg." : $peso_total;

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("peso total productos de ls order $order_number: $peso_total");
        }

        $arr_datos = array(
            'tipo_docto' => $tipo_docto,
            'tienda_nombre' => $tienda_nombre,
            'order_number' => $order_number,
            'order_id' => $order_id,
            'gmt_date' => $gmt_date,
            'gmt_date_expiracion' => $gmt_date_expiracion,
            'array_cliente' => $datos_cliente,
            'productos_arr' => $datos_items,
            'modo_pago_arr' => $modo_pago_arr,
            'fecha_hoy' => $hoy,
            'timestamp' => $gmt_date,
            'fecha_from_timestamp' => $hoy_from_timestamp,
            'sucursal_to_send' => $sucursal_bsale_to_send,
            'references' => $references,
            'peso_total' => $peso_total,
            'shipping_address' => $shipping_address,
            'shipping_name' => $shipping_name_orig, //$shipping_name,
            'customer_note' => $nota_cliente,
            'webpay_transaction_id' => $webpay_transaction_id,
            'cardNumber' => $cardNumber,
            'dte_afecto' => isset($is_dte_afecto) ? $is_dte_afecto : true,
            'seller_id' => Funciones::get_seller_id(),
        );

        $bsale_dte = new BsaleDTE();

        if( isset($_REQUEST['test_dte']) )
        {
            $totales_arr = $bsale_dte->get_totales($arr_datos);
            Funciones::print_r_html($arr_datos, "WpBsale->crear_dte_bsale, datos a enviar:");
            Funciones::print_r_html($totales_arr, "WpBsale->crear_dte_bsale, totales:");
        }

        $result = null;
        $result = $bsale_dte->enviar_dte_a_bsale($arr_datos);

        if( isset($_REQUEST['test_dte']) )
        {
            return;
        }

        $tipo_docto_nombre = $utils->get_tipo_docto_nombre($tipo_docto);

        //si hay algo en el meta,agrego lo de ahora
        $url_docto_anterior = get_post_meta($order_id, 'bsale_docto_url', true);

        //msge de exito
        if( isset($result['urlPublicView']) )
        {
            $str_note = "ver <a href='{$result['urlPublicView']}' target='_blank'>"
                    . "$tipo_docto_nombre #{$result['number']}</a>";

            update_post_meta($order_id, 'bsale_docto_folio', $result['number']);
            update_post_meta($order_id, 'bsale_docto_url', $result['urlPublicView'] . ' ' . $url_docto_anterior);
            update_post_meta($order_id, 'bsale_docto_tipo', $tipo_documento);
            //así puedo obtener el id de la nv asociada a esta orden

            update_post_meta($order_id, "bsale_docto_id_$tipo_documento", $result['id']); //id doc en Bsale
            update_post_meta($order_id, "bsale_docto_id_{$tipo_documento}_url", $result['urlPublicView']); //url
            update_post_meta($order_id, "bsale_docto_folio_$tipo_documento", $result['number']); //folio
            update_post_meta($order_id, 'bsale_docto_error', ''); //limpio error

            if( $dte_parcial )
            {
                update_post_meta($order_id, 'bsale_docto_error', "$tipo_docto parcial #{$result['number']}"); //limpio error
            }

            $note = $str_note;
            // Add the note
            $order->add_order_note($note);
        }
        else
        {
            $error_msg = isset($result['error']) ? $result['error'] : print_r($result, true);
            $str_note = "$tipo_docto_nombre ERROR: $error_msg";

            update_post_meta($order_id, 'bsale_docto_error', $str_note);
            //update_post_meta($order_id, 'bsale_docto_tipo', $str_note);

            $note = $str_note;
            // Add the note
            $order->add_order_note($note);
        }
        return $result;
    }

    /**
     * suvursal de la comuna de facturac donde debe emitirse el dte
     * @param type $billing_comuna
     */
    public function get_sucursal_comuna_to_send($billing_comuna)
    {
        //debo emitr boleta segun comuna de fact?
        if( !Funciones::is_emitir_dte_segun_comuna() )
        {
            return 0;
        }
        $utils = new Utils();

        $comunas_sucursal_id_arr = Funciones::get_comunas_sucursales_dte();

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html($comunas_sucursal_id_arr, "get_sucursal_comuna_to_send($billing_comuna), listado de comunas=sucursal id");
        }
        //$billing_comuna es la comuna de facturacion
        $billing_comuna_send = strtolower($billing_comuna);
        $billing_comuna_send = $utils->filter_chars($billing_comuna_send);

        $sucursal_comuna_id = isset($comunas_sucursal_id_arr[$billing_comuna_send]) ? $comunas_sucursal_id_arr[$billing_comuna_send] : 0;

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html("get_sucursal_comuna_to_send($billing_comuna), sucursal bsale donde emitir dte: $sucursal_comuna_id");
        }

        return $sucursal_comuna_id;
    }

    /**
     * devuelve arrayd id, title deshipping method usado en la order
     * @param type $order
     * @param type $order_id
     */
    public function get_order_shipping_method($order, $order_id = 0)
    {
        $arraux = array();

        if( empty($order) && $order_id > 0 )
        {
            $order = new WC_Order($order_id);
        }

        if( empty($order) )
        {
            return $arraux;
        }

        // Iterating through order shipping items
        foreach( $order->get_items('shipping') as $item_id => $shipping_item_obj )
        {
            // Get the data in an unprotected array
            $shipping_item_data = $shipping_item_obj->get_data();

            return $shipping_item_data;

            /* $shipping_data_id = $shipping_data['id'];
              $shipping_data_order_id = $shipping_data['order_id'];
              $shipping_data_name = $shipping_data['name'];
              $shipping_data_method_title = $shipping_data['method_title'];
              $shipping_data_method_id = $shipping_data['method_id'];
              $shipping_data_instance_id = $shipping_data['instance_id'];
              $shipping_data_total = $shipping_data['total'];
              $shipping_data_total_tax = $shipping_data['total_tax'];
              $shipping_data_taxes = $shipping_data['taxes']; */
        }
    }

    /**
     * coloca el sku del envio, en caso de que sea necesario
     * @param type $arraux
     * @param type $tipo_docto
     */
    public function set_sku_envio($arraux, $tipo_docto)
    {
        //sku general
        if( defined('SKU_ENVIO') && !empty(SKU_ENVIO) )
        {
            $arraux['code'] = SKU_ENVIO;
            //unset($arraux['comment']);
        }

        //sku por tipo dte
        if( $tipo_docto === 'b' )
        {
            //agrego sku de envío
            if( defined('SKU_ENVIO_BOLETA') && !empty(SKU_ENVIO_BOLETA) )
            {
                $arraux['code'] = SKU_ENVIO_BOLETA;
            }
        }
        elseif( $tipo_docto === 'f' )
        {
            //agrego sku de envío
            if( defined('SKU_ENVIO_FACTURA') && !empty(SKU_ENVIO_FACTURA) )
            {
                $arraux['code'] = SKU_ENVIO_FACTURA;
            }
        }
        return $arraux;
    }

    /**
     * 
     * @param type $order_id
     * @param type $tipo_pago
     * @param type $gmt_date
     * @param type $tipo_docto
     * @param type $total_neto_calculado total order, solo usado si Funciones::is_only_prods_bsale() is true
     * @return type
     */
    public function get_modo_pago($order_id, $tipo_pago, $gmt_date, $tipo_docto, $total_neto_calculado)
    {
        $utils = new Utils();

        return $utils->get_modo_pago_wp($order_id, $tipo_pago, $gmt_date, $tipo_docto, $total_neto_calculado);
    }

    /**
     * 29-06-2019, para usar con nuevas funci8o9nes de dte
     * @param type $datos_items
     * @param type $total_descto_pesos
     * @return type
     */
    public static function descontar_de_productos2($datos_items, $total_descto_pesos)
    {
        if( $total_descto_pesos <= 0 )
        {
            return $datos_items;
        }

        $arraux = array();
        foreach( $datos_items as $item )
        {
            //si ya he aplicado todos el descto o el prod ya tien descto de 100
            if( $item['discount'] >= 100 || $total_descto_pesos <= 0 )
            {
                //Transferencia a título gratuíto, descto 100%, solo Perú
                if( Funciones::get_pais() === 'PE' && $item['discount'] >= 100 )
                {
                    //$item['comment'] = 'Transferencia a título gratuíto';
                }
                $arraux[] = $item;
                continue;
            }

            $cantidad = $item['quantity'];
            $precio_unitario = $item['netUnitValue'];
            //total de este producto
            $total_producto = $cantidad * $precio_unitario;

            if( $total_descto_pesos >= $total_producto )
            {
                //dejo todos estos prodcutos a $1
                $valor_descto = $total_producto - $cantidad;
            }
            else
            {
                $valor_descto = $total_descto_pesos;
            }
            //obtengo cant de descto unitario
            $valor_descto_unidad = ($valor_descto / $cantidad);

            //calculo % de descto
            $porcent_descto_unidad = (100 * $valor_descto_unidad) / $precio_unitario;
            $item['discount'] = $porcent_descto_unidad;

            //Transferencia a título gratuíto, descto 100%, solo Perú
            if( Funciones::get_pais() === 'PE' && $porcent_descto_unidad >= 100 )
            {
                $item['comment'] = 'Transferencia a título gratuíto';
            }

            //resto descto aplicado
            $total_descto_pesos -= $valor_descto;

            //   Funciones::print_r_html( $item, "descuentos $porcent_descto_unidad = ($precio_unitario * $valor_descto_unidad)/100" );

            $arraux[] = $item;
        }
        return $arraux;
    }

    public static function get_total_productos($datos_items)
    {
        $total = 0;
        foreach( $datos_items as $item )
        {
            $cantidad = $item['cant_ordenada'];
            $precio_unitario = $item['price'];
            $descto_porcent = $item['discount'];

            if( $descto_porcent > 0 )
            {
                $precio_unitario -= ($precio_unitario * $descto_porcent / 100);
            }

            $total += $precio_unitario * $cantidad;
        }
        return $total;
    }

    public function is_user_role($user, $user_id = 0, $role_str = '')
    {
        //si user es null, lo obtiene del id
        if( empty($user) && $user_id > 0 )
        {
            $user = get_user_by('ID', $user_id);
        }


        $roles_arr = $this->get_user_roles($user);

        if( !$roles_arr )
        {
            return false;
        }

        foreach( $roles_arr as $rol )
        {
            if( strcasecmp($role_str, $rol) == 0 )
            {
                return true;
            }
        }
        return false;
    }

    /**
     * devuelve listado de user roles para el user como param, para el current user
     * @param type $user
     * @return type
     */
    public function get_user_roles($user)
    {
        //si no viene user, uso el current user
        if( !$user )
        {
            $user = wp_get_current_user();
            if( !$user )
            {
                return null;
            }
        }

        $roles = (array) $user->roles;
        return $roles; // This returns an array
        // Use this to return a single value
        // return $roles[0];
    }

    /**
     * cambia el texto del precio a mostrar
     * si es mayorista, agrega el texto (más iva)
     * @param string $price
     * @return string
     */
    public static function change_product_price_display($price)
    {
        $me = new WpBsale();

        $is_mayorista = $me->is_user_role(null, 0, 'mayoristas');

        if( $is_mayorista )
        {
            $price .= '<span class="plus_iva"> + IVA</span>';
        }
        /* else
          {
          $price .= '<span class="plus_iva">IVA inc</span>';
          } */
        return $price;
    }

    public static function save_quote($post_id, $post, $is_updating)
    {
        //solo en el update se puede preguntar por los datos meta
        if( !$is_updating )
        {
            return true;
        }

        $bsale_docto_folio_quote = get_post_meta($post_id, 'bsale_docto_folio_quote', true);

        //si contiene folio, ha se ha emitido nv para esta quote
        if( !isset($_REQUEST['test_dte']) && !empty($bsale_docto_folio_quote) )
        {
            return true;
        }
        //productos
        $products_arr = get_post_meta($post_id, 'products_json', true);
        //plazo de pago
        $porcent_descto = get_post_meta($post_id, 'porcent_descto', true);
        //comuna en afrfq_field3_field
        $billing_comuna = get_post_meta($post_id, 'afrfq_field3_field', true);
        $billing_giro = get_post_meta($post_id, 'afrfq_field2_field', true); //afrfq_field2_field
        $billing_rut = get_post_meta($post_id, 'afrfq_field1_field', true); //afrfq_field1_field
        //separo dias-descto
        $arraux_descto = explode('-', $porcent_descto);

        $dias = isset($arraux_descto[0]) ? $arraux_descto[0] : 0;
        $descto = isset($arraux_descto[1]) ? $arraux_descto[1] : 0;

        // Funciones::print_r_html($post, "save_quote($post_id, is update=$is_updating");
        // Funciones::print_r_html($products_arr, "save_quote($post_id, descto $descto%  productos");
        //cliente
        $myuser_id = get_post_field('post_author', $post_id);

        //datos del cliente registrado
        $billing_first_name = get_user_meta($myuser_id, 'billing_first_name', true);
        $billing_last_name = get_user_meta($myuser_id, 'billing_last_name', true);
        $billing_company = get_user_meta($myuser_id, 'billing_company', true);
        $billing_email = get_user_meta($myuser_id, 'billing_email', true);

        $address_1 = get_user_meta($myuser_id, 'billing_address_1', true);
        $address_2 = get_user_meta($myuser_id, 'billing_address_2', true);

        $billing_city = get_user_meta($myuser_id, 'billing_city', true);

        $direccion = "$address_1 $address_2 $billing_comuna  $billing_city";
        $direccion = trim($direccion);
        $direccion = empty($direccion) ? 'sin datos' : $direccion;



        $utils = new Utils();

        $direccion = $utils->filter_chars($direccion);
        $billing_city = $utils->filter_chars($billing_city);
        $billing_giro = $utils->filter_chars($billing_giro);
        $billing_first_name = $utils->filter_chars($billing_first_name);
        $billing_last_name = $utils->filter_chars($billing_last_name);

        //billing comuna value
        $comuna_value = self::get_comuna_value($billing_comuna);
        $billing_comuna = !empty($comuna_value) ? $comuna_value : $billing_comuna;

        $datos_cliente = array(
            //'direccion' => $direccion,
            'code' => $billing_rut,
            'city' => substr($billing_city, 0, 30),
            'company' => $billing_company,
            'municipality' => $billing_comuna, //$billing_city, //comuna
            'activity' => $billing_giro,
            'address' => $direccion,
            'email' => $billing_email,
            'phone' => '',
            'firstName' => $billing_first_name,
            'lastName' => $billing_last_name,
            'companyOrPerson' => 1, //cotizaciones solo para empresas
        );

        //productos
        $datos_items = array();

        //Funciones::print_r_html($products_arr, "prods arr");
        //recorro productos
        foreach( $products_arr as $item )
        {
            $prod_id = $item['pid'];
            $precio_neto_unidad = $item['price'];
            $cantidad = (int) $item['quantity'];
            $variacion_id = isset($item['vari_id']) ? $item['vari_id'] : 0;

            $product = wc_get_product($prod_id);

//            Funciones::print_r_html("prod id: $prod_id");
//            print_r($product);

            if( !$product )
            {
                Funciones::print_r_html("save_quote($post_id), producto $prod_id no encontrado, se omite");
                continue;
            }

            $nombre = $product->get_name();
            $sku = $product->get_sku();

            //¿es una variacion?
            if( $variacion_id > 0 )
            {
                $product_variation_id = $variacion_id;
                $product_variation = new WC_Product_Variation($product_variation_id);
            }
            else
            {
                $product_variation = null;
            }

            //Funciones::print_r_html("var id: $product_variation_id");
            //print_r($product_variation);
            //return true;

            if( $product_variation )
            {
                $var_attr = $product_variation->get_variation_attributes();
                $variation_name = isset($var_attr[0]) ? $var_attr : '';
                $sku = $product_variation->get_sku();
            }
            else
            {
                $variation_name = null;
            }



            if( !empty($variation_name) )
            {
                $nombre .= " $variation_name";
            }

            //agrego nombre de variante
            if( !empty($product_variation) )
            {
                $nombre .= ' ' . $product_variation->get_name();
            }

            $precio_neto = $precio_neto_unidad;



            //$precio_neto = number_format($precio_neto, 4, ',', '');
            $arrauxitems = array(
                'quantity' => $cantidad,
                'netUnitValue' => $precio_neto,
                'taxId' => "[" . IMPUESTO_IVA_ID . "]",
                'discount' => $descto,
                'comment' => $nombre );

            //si envio el sku/barcode a bsale
            if( Funciones::is_send_sku() == true )
            {
                if( BSALE_IDENTIFICADOR_PRODUCTO === 'sku' && !empty($sku) )
                {
                    $arrauxitems['code'] = $sku;
                    unset($arrauxitems['comment']);
                }
                else if( !empty($sku) )
                {
                    $arrauxitems['barCode'] = $sku;
                    unset($arrauxitems['comment']);
                }
            }
            if( defined('SKIP_IMPUESTO_IVA_ID') && SKIP_IMPUESTO_IVA_ID == true )
            {
                unset($arrauxitems['taxId']);
            }

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html($arrauxitems, "wp_>save quote bsale:item:");
            }


            $datos_items[] = $arrauxitems;
        }//fin recorrer items



        $old_timezone = date_default_timezone_get();
        date_default_timezone_set("America/Santiago");
        ini_set("date.timezone", "America/Santiago");

        $hoy = date('Y-m-d');
        $gmt_date = strtotime($hoy);
        $gmt_date_expiracion = $gmt_date;
        $hoy_from_timestamp = date('Y-m-d', $gmt_date);

        date_default_timezone_set($old_timezone);
        ini_set("date.timezone", $old_timezone);

        $modo_pago_arr = null;
        $tienda_nombre = '(WC)';
        $tipo_docto = $tipo_documento = 'nv';

        $arr_datos = array(
            'tipo_docto' => $tipo_docto,
            'tienda_nombre' => $tienda_nombre,
            'order_number' => "COTIZ $post_id",
            'gmt_date' => $gmt_date,
            'gmt_date_expiracion' => $gmt_date_expiracion,
            'array_cliente' => $datos_cliente,
            'productos_arr' => $datos_items,
            'modo_pago_arr' => $modo_pago_arr,
            'fecha_hoy' => $hoy,
            'timestamp' => $gmt_date,
            'fecha_from_timestamp' => $hoy_from_timestamp,
        );

        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html($arr_datos, "WpBsale->save_quote, datos a enviar:");
            return $arr_datos;
        }


        //Funciones::print_r_html($arr_datos, "WpBsale->save_quote, datos a enviar:");
        //return true;

        $bsale_dte = new BsaleDTE();

        $result = null;
        $result = $bsale_dte->enviar_dte_a_bsale($arr_datos);

        $tipo_docto_nombre = $utils->get_tipo_docto_nombre($tipo_docto);

        //si hay algo en el meta,agrego lo de ahora
        $url_docto_anterior = get_post_meta($post_id, 'bsale_docto_url', true);



        //msge de exito
        if( isset($result['urlPublicView']) )
        {
            $str_note = "ver <a href='{$result['urlPublicView']}' target='_blank'>"
                    . "$tipo_docto_nombre #{$result['number']}</a>";

            update_post_meta($post_id, 'bsale_docto_folio_quote', $result['number']);
            update_post_meta($post_id, 'bsale_docto_url_quote', $result['urlPublicView'] . ' ' . $url_docto_anterior);
            update_post_meta($post_id, 'bsale_docto_tipo_quote', $tipo_documento);
            //así puedo obtener el id de la nv asociada a esta orden
            update_post_meta($post_id, "bsale_docto_id_{$tipo_documento}_quote", $result['id']);
            update_post_meta($post_id, "bsale_docto_id_{$tipo_documento}_url_quote", $result['urlPublicView']);
            update_post_meta($post_id, 'bsale_docto_error_quote', '');
        }
        else
        {
            $error_msg = isset($result['error']) ? $result['error'] : print_r($result, true);
            $str_note = "$tipo_docto_nombre ERROR: $error_msg";

            update_post_meta($post_id, 'bsale_docto_error_quote', $str_note);
            //update_post_meta($order_id, 'bsale_docto_tipo', $str_note);
        }
        return $result;
    }

    /**
     * resync stock y precio de este producto
     * @param type $product_id
     */
    public static function product_update($meta_id, $object_id, $meta_key, $_meta_value)
    {
        if( !is_admin() )
        {
            return;
        }
        if( $meta_key === '_sku' && !empty($_meta_value) )
        {
            //die("product_update($meta_id, $object_id, $meta_key, $_meta_value)");
            self::product_sync($object_id);
        }
    }

    public static function product_variation_update($product_id)
    {

        self::product_sync($product_id);
    }

    /**
     * avisos de Bsale cuando un sku no existe en Bsale
     * @global type $post
     * @return type
     */
    public static function post_edit_info()
    {
        $screen = get_current_screen();
        if( /* $screen->post_type !== 'product' || */ $screen->id !== 'product' )
        {
            return;
        }

        global $post;
        $post_id = $post->ID;

        $str = ''; //"test post id=$post_id";

        $bsale_info = get_post_meta($post_id, 'bsale_info', true);
        $bsale_info_variacion = get_post_meta($post_id, 'bsale_info_variacion', true);

        if( !empty($bsale_info) )
        {
            $str .= "<p>Integración Bsale: <strong class='bsale_info' style='color: #dc3232'>$bsale_info</strong></p>";
        }
        if( !empty($bsale_info_variacion) )
        {
            $str .= "<p>Integración Bsale: <strong class='bsale_info' style='color: #dc3232'>$bsale_info_variacion</strong></p>";
        }

        $class = 'notice-error ';

        if( !empty($str) )
        {
            ?>
            <div class="notice <?php echo $class; ?>">
                <p><?php echo $str; ?></p>
            </div>
            <?php
        }
    }

    /*
      public static function product_variation_save($product_id, $i)
      {
      Funciones::print_r_html("product_variation_save($product_id, $i)");
      self::product_sync($product_id);
      } */

    public static function product_sync($product_id)
    {
        if( !is_admin() )
        {
            return;
        }
        //get sku
        $sku = get_post_meta($product_id, '_sku', true);
        $post_id = $product_id;

        if( empty($sku) )
        {
            return false;
            /* $product = wc_get_product($product_id); //wc_get_product

              if( !$product )
              {
              return false;
              }
              $parent_id = $product->get_parent_id();

              if( $parent_id <= 0 )
              {
              $msg = "Producto no tiene sku";
              update_post_meta($post_id, 'bsale_info', $msg);
              }
              else
              {
              $parent_id = $product->get_parent_id();

              if( $parent_id > 0 )
              {
              $msg = "Variacion #$product_id no tiene sku";
              $post_id = $parent_id;
              update_post_meta($post_id, 'bsale_info_variacion', $msg);
              }
              }

              return false; */
        }

        $product = wc_get_product($product_id);

        if( !$product )
        {
            return false;
        }

        $parent_id = $product->get_parent_id();

        //envio file .json para actualizar
        //obtengo datos de varian a partir de sku
        $vars = new VariantesProductoBsale();

        $variacion_resp = $vars->get_variacion_by_sku($sku);

        if( !isset($variacion_resp['id']) )
        {
            if( $parent_id <= 0 )
            {
                $msg = "Sku '$sku' no está en Bsale.";
                update_post_meta($post_id, 'bsale_info', $msg);
            }
            else
            {
                $msg = "$parent_id: sku '$sku' de variacion #$product_id no está en Bsale.";
                update_post_meta($parent_id, 'bsale_info_variacion', $msg);
            }

            return false;
        }

        $variacion_id = $variacion_resp['id'];

        //arreglo
        $post_vars = '{"cpnId":10615,"resource":"/v2/variants/' . $variacion_id . '.json","resourceId":"' . $variacion_id . '","topic":"variant","action":"put","send":1553289004}';
        //json
        $post_vars_array = json_decode($post_vars, true);

        $topic = $post_vars_array['topic'];
        $post_vars = trim($post_vars);

        $hoy = date('Y-m-d');
        //dokan archivos deben llevar: {client_id}_{$hoy}_{$topic}_{$resourceId}
        $fichero = dirname(__FILE__) . "/../../webhooks/notificaciones/{$hoy}_autoupdate_{$topic}_{$variacion_id}.json";

        //guardo json
        file_put_contents($fichero, $post_vars);

        //limpio avisos de error
        if( $parent_id > 0 )
        {
            $post_id = $parent_id;
        }

        update_post_meta($post_id, 'bsale_info', '');
        update_post_meta($post_id, 'bsale_info_variacion', '');

        //update_post_meta($post_id, 'bsale_info', $fichero);
        // die();
    }

    /**
     * sincroniza stock y sky del prodcuto y sus variacioens
     * @param type $product_id
     * @return boolean
     */
    public static function product_sync_from_bsale($product_id, $contains = null)
    {
        $arraux = array();

        //si contains es string, lo paso a array
        if( $contains != null && !is_array($contains) )
        {
            $contains = array( $contains );
        }

        $str_error = '';

        $post_id = $product_id;
        $arraux['product_id'] = $product_id;

        $product = wc_get_product($product_id);

        if( !$product )
        {
            $str_error .= "no se ha encontrado prodcuto con id=$product_id.";

            $arraux['error'] = $str_error;
            $arraux['result'] = false;
            return $arraux;
        }

        //get sku
        $sku = get_post_meta($product_id, '_sku', true);

        //reviso si este producto em,pieza con los prefijos de sku o no
        if( !empty($contains) && !empty($sku) )
        {
            foreach( $contains as $c )
            {
                $c = trim($c);

                if( !empty($c) && stripos($sku, $c) === false )
                {
                    if( isset($_REQUEST['param']) )
                    {
                        Funciones::print_r_html("sku '$sku' no contiene '$c', se omite");
                        $str_error .= "sku '$sku' no contiene '$c', se omite";

                        $arraux['error'] = $str_error;
                        $arraux['result'] = false;
                        return $arraux;
                    }
                }
                elseif( isset($_REQUEST['param']) && !empty($c) )
                {
                    Funciones::print_r_html("sku '$sku' sí contiene '$c', se actualiza");
                }
            }
        }


        $arraux['product_sku'] = $sku;
        $arraux['product_name'] = $product->get_name();
        $arraux['product_stock'] = $product->get_stock_quantity();
        $arraux['product_stock_status'] = $product->get_stock_status();
        $arraux['product_normal_price'] = $product->get_price();

        //skus a actualizar
        $skus_arr = array();

        if( !empty($sku) )
        {
            $skus_arr[$product_id] = $sku;
        }

        $variations = $product->get_children();

        if( is_array($variations) )
        {
            foreach( $variations as $variacion_id )
            {
                $sku = get_post_meta($variacion_id, '_sku', true);

                //agrego a los skus a actualizar
                if( !empty($sku) )
                {
                    $skus_arr[$variacion_id] = $sku;
                    //Funciones::print_r_html("variacion #$variacion_id, sku=$sku");
                }
            }
        }

        $arraux['list_skus'] = $skus_arr;

        $bsale = new Bsale();
        $vars = new VariantesProductoBsale();

        //limpio metas
        update_post_meta($post_id, 'bsale_info', '');
        update_post_meta($post_id, 'bsale_info_variacion', '');

        $str_post_meta = '';
        $str_post_meta_variacion = '';
        //Funciones::print_r_html($skus_arr, "skus_arr");
        //ahora recorro arrays de sku a actualizar y actualizo
        foreach( $skus_arr as $var_id => $sku_to_update )
        {

            if( empty($sku_to_update) )
            {

                $str_error .= "sku en blanco, por lo que sus datos no se actualizaron.";

                //agrego avisos de error en campos meta
                if( $var_id == $post_id )
                {
                    
                }
                else
                {
                    //sku de variaciones
                    $str_post_meta_variacion .= "variacion #$var_id no tiene sku, no se actualizó.<br/>";
                }
                continue;
            }
            //Funciones::print_r_html("variacion $id => $sku_to_update");
            $variacion_resp = $vars->get_variacion_by_sku($sku_to_update);

            if( !isset($variacion_resp['id']) )
            {
                $str_error .= "sku '$sku_to_update' no pertenece a ningún producto de Bsale. Sus datos no se pueden sincronizar.";

                //agrego avisos de error en campos meta
                if( $var_id == $post_id )
                {
                    //sku del producto
                    $str_post_meta .= "Sku '$sku_to_update' no pertenece a ningún producto de Bsale.<br/>";
                }
                else
                {
                    //sku de variaciones
                    $str_post_meta_variacion .= "sku '$sku_to_update' de variacion #$var_id no pertenece a ningún producto de Bsale.<br/>";
                }
                continue;
            }


            $variante_id = $variacion_resp['id'];
            //proceso variacion
            $post_vars_array = array( 'cpnId' => $variante_id,
                'resource' => "/v2/variants/$variante_id.json", 'resourceId' => $variante_id,
                'topic' => 'variant', 'action' => 'put',
                'send' => '1553289004', );

            $bsale->do_variant($post_vars_array, true, true);
        }

        //coloco avisos, si es que hay      
        update_post_meta($post_id, 'bsale_info', $str_post_meta);
        update_post_meta($post_id, 'bsale_info_variacion', $str_post_meta_variacion);

        if( !empty($str_post_meta) || !empty($str_post_meta_variacion) )
        {
            //producto con al menos un sku que no está en Bsale
            update_post_meta($post_id, 'bsale_missed', 1);
        }
        else
        {
            //sku está en bsale, se borra mensaje
            delete_post_meta($post_id, 'bsale_missed');
        }


        // update_post_meta($post_id, 'bsale_info', "from sync.");

        $arraux['error'] = $str_error;
        $arraux['result'] = empty($str_error) ? true : false;
        return $arraux;
    }

    /**
     * devuelve el stock disponible para un prodcuto de bsale
     * @param type $sku
     * @param type $bsale_sucursal_id
     */
    public function get_product_stock($sku, $bsale_sucursal_id)
    {
        $prod_bsale = new ProductoBsale();

        $stock_disponible_sucursal = $prod_bsale->get_stock_producto($sku, $bsale_sucursal_id);

        return $stock_disponible_sucursal;
    }

    /**
     * devuelve el arreglo $shippings_arr de esta manera: titulo shipping method wc=>true|false (mostrar o no en checkout)
     * @param type $shippings_arr: titulo shipping method wc->id sucursal bslae
     * @param type $productos_arr sku=>cantidad en el carro
     */
    public function get_shipping_sucursal_stock($shippings_arr, $productos_arr)
    {
        if( count($shippings_arr) <= 0 )
        {
            return $shippings_arr;
        }

        $shippings_to_display_arr = $shippings_arr;

        $prod_bsale = new ProductoBsale();
        //recorro sucursales, preguntando por el stock de todos los productos del carro
        foreach( $shippings_arr as $ship_title => $sucursal_id )
        {
            $display_ship = true;
            //por default, shipping method se muestra
            $shippings_to_display_arr[$ship_title] = $display_ship;

            if( isset($_REQUEST['test_dte']) )
            {
                // Funciones::print_r_html("get_shipping_sucursal_stock, recorro shipping method '$ship_title'=> sucursal bsal e#$sucursal_id, buscando stocks");
            }

            //recorro todos los productos y veo si hay stock en esta sucursal
            foreach( $productos_arr as $sku => $cantidad )
            {
                if( isset($_REQUEST['test_dte']) )
                {
                    // Funciones::print_r_html("----get_shipping_sucursal_stock, busco stock de sku='$sku', cantidad= $cantidad");
                }
                $stock_disponible_sucursal = $prod_bsale->get_stock_producto($sku, $sucursal_id);

                //si no hay stock suficiente, no se debe mostrar este medio de envio en el checkout de wc
                if( $stock_disponible_sucursal < $cantidad )
                {
                    $display_ship = false;
                    $shippings_to_display_arr[$ship_title] = $display_ship;

                    if( isset($_REQUEST['test_dte']) )
                    {
                        Funciones::print_r_html("----get_shipping_sucursal_stock '$ship_title', sku='$sku', no tiene stock suficiente (disponible: $stock_disponible_sucursal, se oculta");
                    }
                    break;
                }

                if( isset($_REQUEST['test_dte']) )
                {
                    Funciones::print_r_html("----get_shipping_sucursal_stock '$ship_title', sku='$sku', SÍ tiene stock suficiente (disponible: $stock_disponible_sucursal, se muestra");
                }
            }
        }


        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html($shippings_to_display_arr, "get_shipping_sucursal_stock, sucursales a mostrar:");
        }

        return $shippings_to_display_arr;
    }

    /**
     * devuelve arreglo: titulo shipping method wc=>state:true|false (mostrar o no en checkout)
     *  shipping method wc=>prods_stock[sku=>stock en bsale]
     * 
     * @param type $shippings_arr
     * @param type $productos_arr
     * @return boolean
     */
    public function get_shipping_sucursal_stock2($shippings_arr, $productos_arr)
    {
        if( count($shippings_arr) <= 0 )
        {
            return $shippings_arr;
        }

        $shippings_to_display_arr = $shippings_arr;

        $prod_bsale = new ProductoBsale();
        //recorro sucursales, preguntando por el stock de todos los productos del carro
        foreach( $shippings_arr as $ship_title => $sucursal_id )
        {
            $display_ship = true;
            $shippings_to_display_arr[$ship_title] = array();
            //por default, shipping method se muestra
            $shippings_to_display_arr[$ship_title]['state'] = $display_ship;
            //prods con stock
            $shippings_to_display_arr[$ship_title]['prods_con_stock'] = array();
            //prods sin stock
            $shippings_to_display_arr[$ship_title]['prods_sin_stock'] = array();

            if( isset($_REQUEST['test_dte']) )
            {
                // Funciones::print_r_html("get_shipping_sucursal_stock, recorro shipping method '$ship_title'=> sucursal bsal e#$sucursal_id, buscando stocks");
            }

            //recorro todos los productos y veo si hay stock en esta sucursal
            foreach( $productos_arr as $sku => $cantidad )
            {
                if( isset($_REQUEST['test_dte']) )
                {
                    // Funciones::print_r_html("----get_shipping_sucursal_stock, busco stock de sku='$sku', cantidad= $cantidad");
                }
                $stock_disponible_sucursal = $prod_bsale->get_stock_producto($sku, $sucursal_id);

                //si no hay stock suficiente, no se debe mostrar este medio de envio en el checkout de wc
                if( $stock_disponible_sucursal < $cantidad )
                {
                    $display_ship = false;
                    //no se debe mostrar, pues falta al menos un prod del carro en esta sucursal de bsale
                    $shippings_to_display_arr[$ship_title]['state'] = $display_ship;

                    $shippings_to_display_arr[$ship_title]['prods_sin_stock'][] = array( 'sku' => $sku, 'stock' => $stock_disponible_sucursal );

                    if( isset($_REQUEST['test_dte']) )
                    {
                        Funciones::print_r_html("----get_shipping_sucursal_stock '$ship_title', sku='$sku', no tiene stock suficiente (disponible: $stock_disponible_sucursal, se oculta");
                    }
                }
                else
                {
                    $shippings_to_display_arr[$ship_title]['prods_con_stock'][] = array( 'sku' => $sku, 'stock' => $stock_disponible_sucursal );
                }
            }
        }


        if( isset($_REQUEST['test_dte']) )
        {
            Funciones::print_r_html($shippings_to_display_arr, "get_shipping_sucursal_stock, sucursales a mostrar:");
        }

        return $shippings_to_display_arr;
    }

    /**
     * filtra los medios de de envio colocados en la configuración del plugin y que fueron asociados 
     * a sucursales de Bsale. Si el medio de envio no tiene stock en la sucursal de Bsale asociada, no se muestra
     * 
     * @param type $rates
     * @param type $package
     * @return type
     */
    public static function filter_shipping_sucursales($rates, $package)
    {
        $utils = new Utils();
        //arreglo: titulo medio envio wc=>id sucursal bsale
        $shipings_arr = $utils->get_array_medios_envio();

        //sino hay envios, no se hace nada
        if( !is_array($shipings_arr) || count($shipings_arr) <= 0 )
        {
            return $rates;
        }
        //arreglo con productos del carro: sku=>cantidad
        $prods_arr = array();

        // Loop through cart items Checking for the defined shipping method
        foreach( $package['contents'] as $cart_item )
        {
            $product_id = $cart_item['product_id'];
            $variation_id = $cart_item['variation_id'];
            $quantity = $cart_item['quantity'];
            $sku = $cart_item['data']->get_sku();

            //solo prods con sku y cantidad > 0
            if( empty($sku) || $quantity < 0 )
            {
                continue;
            }

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("filter_shipping_sucursales cart item pid=$product_id, varid= $variation_id, sku= '$sku', cantidad: $quantity");
            }

            //si ya está este sku, sumo la cantidad. Else, la agrego
            if( isset($prods_arr[$sku]) )
            {
                $prods_arr[$sku] += $quantity;
            }
            else
            {
                $prods_arr[$sku] = $quantity;
            }
        }

        //las sucursales e Bsale tienen stock para todos los productos del carro?
        $wpbsale = new WpBsale();
        $shipings_to_display_arr = $wpbsale->get_shipping_sucursal_stock($shipings_arr, $prods_arr);


        $rates_new = array();
        // Loop through shipping methods
        foreach( $rates as $rate_key => $rate )
        {
            $display = true;
            $label = $utils->filter_chars($rate->label);
            $label = strtolower($label);

            if( isset($_REQUEST['test_dte']) )
            {
                Funciones::print_r_html("filter_shipping_sucursales rate para key '$rate_key' name = '$label'");
            }

            if( isset($shipings_to_display_arr[$label]) )
            {
                $display = $shipings_to_display_arr[$label];

                if( isset($_REQUEST['test_dte']) )
                {
                    $displaystr = ($display) ? 'SÍ' : 'NO';
                    Funciones::print_r_html("filter_shipping_sucursales name = '$label' se muestra en checkout: $displaystr");
                }
            }

            //se debe mostrar este shipping method en el checkout?
            if( $display !== false )
            {
                $rates_new[$rate_key] = $rate;
            }
        }

        return $rates_new;
    }

    public static function required_chosen_shipping_methods()
    {
        $chosen_shipping_methods = WC()->session->get('chosen_shipping_methods');

        if( is_array($chosen_shipping_methods) && count($chosen_shipping_methods) <= 0 )
        {
            // Display an error message
            wc_add_notice(__("Se debe elegir un medio de envío antes de ir al checkout."), 'error');
        }
    }

    public static function disable_checkout_button_no_shipping()
    {

        $chosen_shipping_methods = WC()->session->get('chosen_shipping_methods');

        // remove button if there is no chosen shipping method
        if( empty($chosen_shipping_methods) )
        {
            remove_action('woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20);
        }
    }

}

function bsale_display_stock_product_page($price)
{
    global $woocommerce_loop;
    global $product;

    if( is_product() && !$woocommerce_loop['name'] == 'related' && $product->is_in_stock() )
    {
        $stock = $product->get_stock_quantity();
        // $sku = $product->get_sku() ;
        $texto_after_precio = "<span class='product_stock'>Internet: <strong class='stock_q'>$stock</strong></span>";

        return $price . $texto_after_precio;
    }
    else
    {
        return $price;
    }
}

/**
 * Fire on the initialization of WordPress.
 */
function wooc_bsale_action_init()
{
    //para precios mayoristas, si debo agregar el texto "más iva"
    if( defined('PRECIOS_MATORISTA_ADD_TAX') && PRECIOS_MATORISTA_ADD_TAX )
    {
        // die('PRECIOS_MATORISTA_ADD_TAX');
        add_filter('woocommerce_get_price_html', 'WpBsale::change_product_price_display', 9999, 1);

        //variaciones
        add_filter('woocommerce_variation_price_html', 'WpBsale::change_product_price_display', 10, 1);
        add_filter('woocommerce_variation_sale_price_html', 'WpBsale::change_product_price_display', 10, 1);
        //cart
        add_filter('woocommerce_cart_item_price', 'WpBsale::change_product_price_display', 10, 1);
    }

    //emitir nv al crear una cotizacion
    if( defined('WC_EMITIR_NV_IN_QUOTE_CREATE') && WC_EMITIR_NV_IN_QUOTE_CREATE == true )
    {
        add_action('save_post_addify_quote', 'WpBsale::save_quote', 10, 3);

        //cols en cotizaciones
        add_filter('manage_edit-addify_quote_columns', 'WpUtils::bsale_add_factura_number_column_quote', 999);
        add_action('manage_addify_quote_posts_custom_column', 'WpUtils::bsale_add_factura_number_column_data_quote', 2, 2);
    }

    //mostrar puntos de Bsale en el dashboard de Wc?
    if( defined('WC_MOSTRAR_PUNTOS_BSALE_CUSTOMER') && WC_MOSTRAR_PUNTOS_BSALE_CUSTOMER == true )
    {
        //echo('woocommerce_before_account_navigation');
        add_action('woocommerce_account_navigation', 'WpUtils::display_customer_points', 10, 0);
    }

    //integracion de facturacion (aunque diga "inventario")
    if( Funciones::is_enabled_integ_facturacion() == true )
    {
        $is_add_campos_checkout_boleta = Funciones::is_add_campos_checkout_boleta();
        $is_add_campos_checkout_factura = Funciones::is_add_campos_checkout_factura();
        $is_editar_campos_fact = Funciones::is_edit_facturacion_data();

        if( $is_add_campos_checkout_boleta && !$is_add_campos_checkout_factura )
        {
            add_filter('woocommerce_billing_fields', 'WpUtils::add_campos_boleta', 9999, 1);
        }
        elseif( $is_add_campos_checkout_factura )
        {
            add_filter('woocommerce_billing_fields', 'WpUtils::add_campos_factura', 9999, 1);
        }

        //valido datos requeridos
        if( $is_add_campos_checkout_boleta || $is_add_campos_checkout_factura )
        {
            add_action('woocommerce_after_checkout_validation', 'WpUtils::validate_checkout_fields', 9999, 2);

            //guardo campos en order
            add_action('woocommerce_checkout_update_order_meta', 'WpUtils::save_campos_checkout_in_order', 9999, 1);

            //muestro campos checkout in order edit
            add_action('woocommerce_admin_order_data_after_billing_address', 'WpUtils::display_campos_checkout_in_order', 90, 1);
        }

        //editar campos de facturacion en order edit?
        if( $is_editar_campos_fact )
        {
            //agregar boxes con html
            add_action('add_meta_boxes', 'WpUtils::edit_campos_facturacion_custom_box');
            //save meta data de datos fact
            add_action('save_post', 'WpUtils::edit_campos_facturacion_save_data');
        }

        //muestro campos en emails
        add_filter('woocommerce_email_order_meta_keys', 'WpUtils::display_campos_checkout_in_email', 90, 1);

        //hooks para los estados en que se emiten dtes
        $estados = Funciones::get_estados_enabled_arr();

        foreach( $estados as $estado )
        {
            add_action('woocommerce_order_status_' . $estado, 'WpBsale::crear_dte_bsale', 10, 1);
        }

        //anular dtes on order cancelled?
        if( Funciones::is_anular_dtes_on_order_cancelled() )
        {
            $estado_cancelled = Funciones::get_estado_dte_cancelled();
            add_action('woocommerce_order_status_' . $estado_cancelled, 'WpBsale::anular_dte_bsale', 10, 1); //
        }

        //mostrar solo medios de envio con stock
        if( Funciones::is_enabled_shipping_filter_stock() )
        {
            add_filter('woocommerce_package_rates', 'WpBsale::filter_shipping_sucursales', 20, 2);
            add_action('woocommerce_check_cart_items', 'WpBsale::required_chosen_shipping_methods', 999);
            //validar que hay stock de todos los productos, después de presionar "finalizar compra"
            add_action('woocommerce_after_checkout_validation', 'WpUtils::validar_stock_checkout_sucursales', 10, 2);
            // add_action( 'woocommerce_proceed_to_checkout', 'WpBsale::disable_checkout_button_no_shipping', 1 );
        }
        //instrucciones en el correo
        // add_action('woocommerce_email_before_order_table', 'WpBsale::add_order_email_instructions', 10, 2);
        //cols en admin de pedidos
        add_filter('manage_edit-shop_order_columns', 'WpUtils::bsale_add_factura_number_column', 999);
        add_action('manage_shop_order_posts_custom_column', 'WpUtils::bsale_add_factura_number_column_data', 2);

        //seccion e edit pedido con datos de facturacion
        //add post meta de enviam a order details
        add_action('woocommerce_admin_order_data_after_order_details', 'WpUtils::order_meta_add_info');

        //prefill campos checkout
        add_action('woocommerce_thankyou', 'WpUtils::save_billing_data', 10, 1);
        add_filter('woocommerce_billing_fields', 'WpUtils::prefill_billing_fields', 99999);
        
        //agrego filtros para ver pedidos con boleta, factura, nv y nc
          //agregar filtro: mostrar prods que no estan en bsale
        add_action( 'restrict_manage_posts', 'WpUtils::bsale_orders_filter' );
        add_action( 'pre_get_posts', 'WpUtils::apply_my_custom_orders_filters' );
    }

    if( Funciones::is_enabled_integ_inventario() == true )
    {
        $is_use_rest = defined('BSALE_USE_REST_API') ? BSALE_USE_REST_API : false;

        if( $is_use_rest )
        {
            //rest api init WPBsaleRest class
            require_once dirname(__FILE__) . '/WPBsaleRest.class.php';

            add_action('rest_api_init', 'bsale_codifica_init_api_rest');

            if( function_exists('bsale_codifica_init_api_rest') )
            {
                // echo("exists");
            }
            else
            {
                // echo("NO exists");
            }

            $rest = new WPBsaleRest();
        }
        
        //agregar filtro: mostrar prods que no estan en bsale
        add_action( 'restrict_manage_posts', 'WpUtils::bsale_product_exists_filter' );
        add_action( 'pre_get_posts', 'WpUtils::apply_my_custom_product_filters' );


        //mostrar stock al lado de precio producto
        //add_action('woocommerce_get_price_html', 'bsale_display_stock_product_page');
        //mostrar stock sucursal en pag de producto
        if( Funciones::is_mostrar_stock_sucursal() )
        {
            $action_wc = Funciones::get_mostrar_stock_sucursal_place();

            if( !empty($action_wc) )
            {
                add_action($action_wc, 'WpUtils::wc_bsale_stock_por_sucursal', 15);
            }
        }
        if( Funciones::is_mostrar_stock_sucursal_backend() )
        {
            add_action('add_meta_boxes', 'WpUtils::stock_sucursales_product_edit');
        }
        //autoupdate de precios y stock on save product o variation
        // add_action('woocommerce_update_product', 'WpBsale::product_update', 10, 1);
        //  add_action('woocommerce_update_product_variation', 'WpBsale::product_variation_update', 10, 1);
        //cuando se cambia sku, se revisa si existe en Bsale
        add_action('updated_post_meta', 'WpBsale::product_update', 10, 4);

        // add_action('woocommerce_save_product_variation', 'WpBsale::product_variation_save', 10, 2);
        //mensaje en columnas de producto
        // add_filter('manage_edit-product_columns', 'WpBsale::bsale_product_column', 999);
        //muestra infor en pantalla de post edit
        add_action('admin_notices', 'WpBsale::post_edit_info');

        //link para sync prodcut from Bsale 
        add_action('post_submitbox_misc_actions', 'WpUtils::post_edit_bsale_block');

        //muestra mensaje de skus con errors arriba del nombre del producto
        add_action('manage_product_posts_custom_column', 'WpUtils::bsale_product_column_data', 2, 2);
    }
}

add_action('init', 'wooc_bsale_action_init');

//llama por curl a la url del webhook
//add_action('wp_loaded', 'bsale_integ_call_wh_curl');

add_action('cronjob_webhook_action', 'bsale_integ_call_wh_curl');

//llama por curl a la url del webhook
function bsale_integ_call_wh_curl()
{
    $url = defined('BSALE_CURL_WEBHOOK') ? BSALE_CURL_WEBHOOK : '';

    if( empty($url) )
    {
        return '';
    }
    $cliente = curl_init();
    curl_setopt($cliente, CURLOPT_URL, $url);
    curl_setopt($cliente, CURLOPT_HEADER, 0);
    curl_setopt($cliente, CURLOPT_RETURNTRANSFER, true);

    $contenido = curl_exec($cliente);
    curl_close($cliente);

    return $contenido;
}

/* function mysite_pending( $order_id )
  {
  error_log( "$order_id set to PENDING", 0 );
  }

  function mysite_failed( $order_id )
  {
  error_log( "$order_id set to FAILED", 0 );
  }

  function mysite_hold( $order_id )
  {
  error_log( "$order_id set to ON HOLD", 0 );
  }

  function mysite_processing( $order_id )
  {
  error_log( "$order_id set to PROCESSING", 0 );
  }

  function mysite_completed( $order_id )
  {
  error_log( "$order_id set to COMPLETED", 0 );
  }

  function mysite_refunded( $order_id )
  {
  error_log( "$order_id set to REFUNDED", 0 );
  }

  function mysite_cancelled( $order_id )
  {
  error_log( "$order_id set to CANCELLED", 0 );
  } */



//add_action( 'woocommerce_order_status_pending', 'mysite_pending' );
//add_action( 'woocommerce_order_status_failed', 'mysite_failed' );
//add_action( 'woocommerce_order_status_on-hold', 'mysite_hold' );
// Note that it's woocommerce_order_status_on-hold, not on_hold.
//add_action( 'woocommerce_order_status_processing', 'mysite_processing' );
//add_action( 'woocommerce_order_status_refunded', 'mysite_refunded' );
//add_action( 'woocommerce_order_status_cancelled', 'mysite_cancelled' );