<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Bsale
 *
 * @author Lex
 */
class Bsale
{

    /**
      {
      "cpnId":2,
      "resource":"/v2/products/952.json",
      "resourceId":"952",
      "topic":"product",
      "action":"post",  Identifica el tipo de acción en este caso son posible sólo acciones POST=add y PUT=update
      "send":1503500856
      }
     * @param type $data
     */
    public function do_product($data, $get_variants = true, $show = false, $send_to_do_variant = false)
    {
        $empresa = isset($data['cpnId']) ? $data['cpnId'] : null;
        $resource = isset($data['resource']) ? $data['resource'] : null;
        $resourceId = isset($data['resourceId']) ? $data['resourceId'] : null;
        $topic = isset($data['topic']) ? $data['topic'] : null;
        $action = isset($data['action']) ? $data['action'] : null;
        $send = isset($data['send']) ? $data['send'] : null;

        $prod = new ProductoBsale();
        //datos de producto, variante, precio y stock
        $producto_full_data = array();

        $producto_data = $prod->get_producto($resourceId);
        $product_type_id = isset($producto_data['product_type']['id']) ? (int) $producto_data['product_type']['id'] : -1;

        //estado 1 = deshabilitado
        if( !isset($producto_data['state']) || $producto_data['state'] == 1 )
        {
            return false;
        }

        //prodcuto tiene el tipo permitido?
        $product_types_arr = Funciones::get_bsale_product_type_allowed();

        //si solo se deben sinc stok para ciertos tipos de productos y este no está dentro de los permitidos, se omite
        if( is_array($product_types_arr) && count($product_types_arr) > 0 && !in_array($product_type_id, $product_types_arr) )
        {
            if( isset($_REQUEST['param']) )
            {
                Funciones::print_r_html($product_types_arr, "producto id=$resourceId es de tipo '$product_type_id', no está entre los tipos permitidos, se omite");
            }
            return false;
        }

        $producto_full_data['id'] = $resourceId;
        $producto_full_data['name'] = ($producto_data['name']);
        $producto_full_data['description'] = /* utf8_encode */($producto_data['description']);
        $producto_full_data['pack_details'] = isset($producto_data['pack_details']) ? $producto_data['pack_details'] : null;
        //indica la clase del producto 0 es producto, 1 es servicio y 3 si es un pack o promocion(Integer).
        $producto_full_data['classification'] = isset($producto_data['classification']) ? (int) $producto_data['classification'] : 0;

        if( $producto_full_data['classification'] == 1 )
        {
            if( isset($_REQUEST['param']) )
            {
                Funciones::print_r_html("producto id=$resourceId es servicio, se omite");
            }
            return false;
        }


        if( isset($producto_data['pack_details']) )
        {
            Funciones::print_r_html("producto id=$resourceId es pack");
        }
        //agrego tipo prod como vendor?
        if( defined('INCLUDE_TIPO_PRODUCTO_AS_VENDOR') && INCLUDE_TIPO_PRODUCTO_AS_VENDOR == true )
        {
            //get el type id de este producto
            $type_producto_id = isset($producto_data['product_type']['id']) ? $producto_data['product_type']['id'] : 0;

            if( $type_producto_id > 0 )
            {
                $type_data = $prod->get_producto_type_from_table($type_producto_id);
                //si viene tipo o no
                $type_name = isset($type_data['name']) ? $type_data['name'] : '';
                //"sin tipo", no se escribe 
                if( strcasecmp($type_name, 'sin tipo') == 0 )
                {
                    $type_name = '';
                }
                $producto_full_data['vendor'] = $type_name;
                //append al nombre del prod
                //$producto_full_data['name'] = $type_name . ' ' . $producto_full_data['name'];

                Funciones::print_r_html("add product type como vendor: tipo= '$type_name' para prod id=$resourceId, "
                        . $producto_full_data['name']);
            }
            else
            {
                $producto_full_data['vendor'] = null;
            }
        }
        //INCLUDE_NOMBRE_PRODUCTO_AS_VENDOR
        //agrego nombre prod como vendor?
        if( defined('INCLUDE_NOMBRE_PRODUCTO_AS_VENDOR') && INCLUDE_NOMBRE_PRODUCTO_AS_VENDOR == true )
        {
            $producto_full_data['vendor'] = $producto_full_data['name'];
            Funciones::print_r_html("agrego nombre producto como vendor: " . $producto_full_data['vendor']);
        }

        if( $get_variants )
        {
            //variantes del producto
            $variantes_prod = $prod->get_variantes_producto($resourceId);

            $variantes = array();
            //recorro las variantes y las voy guardando en un array
            foreach( $variantes_prod as $v )
            {
                $aux = array();
                $aux['id'] = $v['id'];
                $aux['description'] = ($v['description']);
                $aux['code'] = $v['code'];
                $aux['barcode'] = $v['barCode'];

                $arraux = array( 'resourceId' => $v['id'], 'cpnId' => $data['cpnId'],
                    'topic' => 'variant', 'action' => 'get', 'send' => $data['send'], 'resource' => '' );
                //full data variant
                $full_variant = $this->do_variant($arraux, true, false);

                $variantes[] = $full_variant;
            }
            $producto_full_data['variants'] = $variantes;
        }

        if( $show )
        {
            //Funciones::print_r_html($producto_data, "do_product from Bsale $resourceId");
            //Funciones::print_r_html($variantes, "do_product, variantes $resourceId");

            Funciones::print_r_html($producto_full_data, "do_product, full data");
        }
        //enviar a do variant
        if( $send_to_do_variant )
        {
            foreach( $producto_full_data['variants'] as $v )
            {
                $data = array();
                $data['cpnId'] = $empresa;
                $data['resourceId'] = $v['variant_id'];
                $data['resource'] = '/v2/variants/' . $data['resourceId'];
                $data['topic'] = 'variant';
                $data['action'] = $action;
                $data['send'] = $send;

                $this->do_variant($data, true, true);
            }
            return true;
        }

        return $producto_full_data;
    }

    public function do_document($data, $get_variants = true, $show = false)
    {
        $empresa = isset($data['cpnId']) ? $data['cpnId'] : null;
        $resource = isset($data['resource']) ? $data['resource'] : null;
        $resourceId = isset($data['resourceId']) ? $data['resourceId'] : null;
        $topic = isset($data['topic']) ? $data['topic'] : null;
        $action = isset($data['action']) ? $data['action'] : null;
        $send = isset($data['send']) ? $data['send'] : null;

        $doc = new Documento();
        //obtengo variaciones
        $result = $doc->getDetailsIdDocto($resourceId);

        Funciones::print_r_html($result, "do_document id=$resourceId");
        //recorro las variaciones y obtengo su id
        //$var = new VariantesProductoBsale();
        $data2 = $data;

        $data2['topic'] = 'variant';

        foreach( $result as $v )
        {
            if( empty($v['sku']) || empty($v['variant_id']) )
            {
                Funciones::print_r_html($v, "do_document id=$resourceId, variant no existe o no tiene datos, se omite");
                continue;
            }
            $sku = $v['sku'];
            $variant_id = $v['variant_id'];
            /*
              $variacion = $var->get_variacion_by_sku($sku);

              Funciones::print_r_html($variacion, "get_variacion_by_sku($sku)");

              if( !isset($variacion['id']) )
              {
              continue;
              }

              $data2['resourceId'] = $variacion['id']; */

            $data2['resourceId'] = $variant_id;
            //envio aviso para actualizar variacion
            $this->do_variant($data2, true, true);
            sleep(1);
        }
        return $result;
    }

    /**
      {
      "cpnId":2,
      "resource":"/v2/variants/7079.json",
      "resourceId":"7079",
      "topic":"variant",
      "action":"post", Identifica el tipo de acción en este caso son posible sólo acciones POST=add y PUT=update
      "send":1503500856
      }
     * @param type $data
     */
    public function do_variant($data, $get_product = true, $show = false)
    {


        $empresa = $data['cpnId'];
        $resource = $data['resource'];
        $resourceId = $data['resourceId'];
        $topic = $data['topic'];
        $action = $data['action'];
        $send = $data['send'];

        //datos de producto, variante, precio y stock
        $producto_full_data = array();

        $prod = new ProductoBsale();

        $include_cost = defined('BSALE_INCLUDE_VARIANT_COST') ? BSALE_INCLUDE_VARIANT_COST : false;

        $variante_data = $prod->get_variante($resourceId, $include_cost);

        //state=1 es deshabilitado
        if( !isset($variante_data['code']) || $variante_data['state'] == 1 )
        {
            Funciones::print_r_html("do_variant, variante id=$resourceId no tiene sku "
                    . "o está deshabilitada ({$variante_data['state']}), se omite.");
            return false;
        }
        //tiene sku to skip?
        $skus_to_skip = defined('SKUS_SKIP_INTEGRACION_STOCK') ? SKUS_SKIP_INTEGRACION_STOCK : null;

        if( !empty($skus_to_skip) && $skus_to_skip != null && stripos($variante_data['code'], $skus_to_skip) !== false )
        {
            Funciones::print_r_html("do_variant, variante id=$resourceId sku=({$variante_data['code']}) "
                    . "tiene sku a omitir. Se omite.");
            return false;
        }

        //datos de la variante
        $producto_full_data['variant_id'] = $resourceId;
        $producto_full_data['variant_description'] = $variante_data['description'];
        //empty($variante_data['description']) ? $resourceId : $variante_data['description'];
        $producto_full_data['variant_code'] = trim($variante_data['code']);
        $producto_full_data['variant_barcode'] = trim($variante_data['barCode']);

        $producto_full_data['variant_description'] = /* utf8_encode */($producto_full_data['variant_description']);

        //get stock de variante en cada sucursal
        $sku = $variante_data['code'];

        //costo promedio de la variacion
        $producto_full_data['variant_average_cost'] = isset($variante_data['costs_variation']['averageCost']) ? 
                $variante_data['costs_variation']['averageCost'] * Funciones::get_valor_iva() : -1;
		 $producto_full_data['variant_average_cost'] = (int) $producto_full_data['variant_average_cost'];

        $arraux = array( 'resourceId' => $resourceId, 'code' => $sku );
        $variant_stock = $this->do_stock($arraux, false, false);

        $producto_full_data['variant_stock'] = $variant_stock;

        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html($variante_data, "do variant, datos variacion");
        }

        //unlimitedStock, indica si la variante posee stock ilimitado No(0) o Si (1) (Boolean).
        if(
                (isset($variante_data['unlimitedStock']) && $variante_data['unlimitedStock'] == 1 ) 
               /* ||
                (isset($variante_data['allowNegativeStock']) && $variante_data['allowNegativeStock'] == 1 )*/
        )
        {
            //en este caso, se le asigna un stock muy alto
            $producto_full_data['variant_stock']['variant_total_stock'] = 999999;

            if( isset($_REQUEST['param']) )
            {
                Funciones::print_r_html("do variant sku='$sku', se deja con stock ilimitado");
            }
        }
        //precio de la variante
        $variante_precio = $this->do_price($arraux, false, false);

        $producto_full_data['variant_price'] = $variante_precio;

        //busco datos del producto
        if( $get_product && isset($variante_data['product']['id']) )
        {
            $producto_id = $variante_data['product']['id'];

            $arraux_data = array( 'resourceId' => $producto_id );
            $producto_data = $this->do_product($arraux_data, false, false);

            if( $producto_data === false )
            {
                if( $_REQUEST['param'] )
                {
                    Funciones::print_r_html("producto es false, se omite variant");
                }
                return false;
            }
            $producto_full_data['product'] = $producto_data;

            //veo si el prodcuto padre es un pack para ajustar el stock de la variante, en caso de que sea cero
            //variante tiene stock=0?
            if( !empty($producto_full_data['product']['pack_details']) /* $producto_full_data['variant_stock']['variant_total_stock'] <= 0 */ )
            {
                Funciones::print_r_html("prod id=$producto_id producto_full_data['product']['pack_details'] es pack, voy a buscar stock");
                $stock_pack = $this->get_stock_pack($producto_full_data['product']);

                if( $stock_pack !== false )
                {
                    $producto_full_data['variant_stock']['variant_total_stock'] = $stock_pack;
                    //marco que esta variante es de un producto pack y que su stock es de pack
                    $producto_full_data['variant_stock']['variant_es_pack'] = 1;
                }
            }
        }

        //productos "despacho" no se envian
        if( strcasecmp($producto_full_data['variant_description'], 'despacho') == 0 || strcasecmp($producto_full_data['product']['name'], 'despacho') == 0 )
        {
            if( isset($_REQUEST['param']) && $_REQUEST['param'] === 'yes' )
            {
                Funciones::print_r_html($producto_full_data, "do_variant, full data para " . INTEGRACION_SISTEMA . " es despacho, se omite");
            }
            return false;
        }


        if( $show )
        {
            //Funciones::print_r_html($variante_data, "do_variant $resourceId");
            //Funciones::print_r_html($producto_data, "do_variant, producto padre: $producto_id");
            Funciones::print_r_html($producto_full_data, "do_variant, full data para " . INTEGRACION_SISTEMA);
        }

        if( Funciones::is_enabled_integ_inventario() != true )
        {
            Funciones::print_r_html('do_variant, inventario not enabled');
            return false;
        }

        // return $producto_full_data;
        //según la constante, veo donde actualizar
        switch( INTEGRACION_SISTEMA )
        {
            case 'jumpseller':
                $shop = new Shopify();

                //tienda 3 de shopify, veca cueros
                if( defined('SHOPIFY_API_KEY3') && !empty(SHOPIFY_API_KEY3) )
                {
                    $access_array = array( 'KEY' => SHOPIFY_API_KEY3,
                        'PASSWORD' => SHOPIFY_PASSWORD3,
                        'URL' => SHOPIFY_BASEURL3,
                    );

                    $shop = new Shopify();
                    $result = $shop->sync_variacion_shopify($producto_full_data, $access_array);
                    //tienda 5
                    Funciones::print_r_html($result, "do_variant $resourceId, hacia tienda 6 de shop: " . INTEGRACION_SISTEMA);
                }

                $result = $shop->sync_variacion_shopify($producto_full_data);
                //tienda 4
                Funciones::print_r_html($result, "do_variant $resourceId, hacia " . INTEGRACION_SISTEMA);

                //tienda 2 de shopify
                if( defined('SHOPIFY_API_KEY2') && !empty(SHOPIFY_API_KEY2) )
                {
                    $access_array = array( 'KEY' => SHOPIFY_API_KEY2,
                        'PASSWORD' => SHOPIFY_PASSWORD2,
                        'URL' => SHOPIFY_BASEURL2,
                    );

                    $shop = new Shopify();
                    $result = $shop->sync_variacion_shopify($producto_full_data, $access_array);
                    //tienda 5
                    Funciones::print_r_html($result, "do_variant $resourceId, hacia tienda 5 de shop: " . INTEGRACION_SISTEMA);
                }



                $result = $prod->update_variant_js($producto_full_data);
                //tienda 1
                Funciones::print_r_html($result, "do_variant $resourceId, hacia " . INTEGRACION_SISTEMA);

                //tienda 2
                if( defined('TOKEN_JUMPSELLER2') && !empty(TOKEN_JUMPSELLER2) )
                {
                    $access_array = array( 'LOGIN' => LOGIN_JUMPSELLER2,
                        'TOKEN' => TOKEN_JUMPSELLER2,
                        'CATEG' => JUMPSELLER_CATEGORIA_RECIEN_LLEGADOS2,
                    );

                    $result2 = $prod->update_variant_js($producto_full_data, $access_array);
                    Funciones::print_r_html($result2, "do_variant $resourceId, hacia " . INTEGRACION_SISTEMA . ' tienda 2');
                }
                //tienda 3
                if( defined('TOKEN_JUMPSELLER3') && !empty(TOKEN_JUMPSELLER3) )
                {
                    $access_array = array( 'LOGIN' => LOGIN_JUMPSELLER3,
                        'TOKEN' => TOKEN_JUMPSELLER3,
                        'CATEG' => JUMPSELLER_CATEGORIA_RECIEN_LLEGADOS3,
                    );

                    $result2 = $prod->update_variant_js($producto_full_data, $access_array);
                    Funciones::print_r_html($result2, "do_variant $resourceId, hacia " . INTEGRACION_SISTEMA . ' tienda 3');
                }



                break;
            case 'shopify':

                $shop = new Shopify();
                $result = $shop->sync_variacion_shopify($producto_full_data);

                Funciones::print_r_html($result, "do_variant $resourceId, hacia " . INTEGRACION_SISTEMA);
                break;
            case 'woocommerce':

                $wc = new WoocommerceBsale();
                $result = $wc->sync_variacion_wc($producto_full_data);

                Funciones::print_r_html($result, "do_variant '$resourceId', hacia " . INTEGRACION_SISTEMA);
                break;

            case 'linio':
                $linio_bsale = new LinioBsale();

                $result = $linio_bsale->sync_variacion_linio($producto_full_data);

                $producto_full_data['result'] = $result;

                Funciones::print_r_html($result, "do_variant '$resourceId', hacia " . INTEGRACION_SISTEMA);
                break;
            case 'magento':
                $linio_bsale = new MagentoProduct();

                $result = $linio_bsale->sync_producto_magento($producto_full_data);
                Funciones::print_r_html($result, "do_variant '$resourceId', hacia " . INTEGRACION_SISTEMA);
                break;
            case 'magento2':
                $linio_bsale = new Magento2Product();

                $result = $linio_bsale->sync_producto_magento($producto_full_data);
                Funciones::print_r_html($result, "do_variant '$resourceId', hacia " . INTEGRACION_SISTEMA);
                break;
            case 'opencart':

                $shop = new Opencart3();
                $result = $shop->sync_variacion_oc($producto_full_data);

                Funciones::print_r_html($result, "do_variant $resourceId, hacia " . INTEGRACION_SISTEMA);
                break;

            case 'prestashop':

                $shop = new Prestashop();
                $result = $shop->sync_variacion_ps($producto_full_data);

                Funciones::print_r_html($result, "do_variant $resourceId, hacia " . INTEGRACION_SISTEMA);
                break;
            default :
                Funciones::print_r_html($result, "do_variant $resourceId, ERROR: '" . INTEGRACION_SISTEMA . "' no se reconoce. No se hace nada.");
                return null;
        }

        return $producto_full_data;
    }

    /**
     * {
      "cpnId":2,
      "resource":"/v2/price_lists/2/details.json?variant=7079",
      "resourceId":"7079",
      "topic":"price",
      "action":"put", este caso sólo existen notificaciones de actualizaciones de precio, por lo que la única acción notificada será PUT
      "officeId":"2",
      "send":1503500856
      }
     * @param type $data
     * @param type $show
     */
    public function do_price($data, $get_variant = true, $show = false)
    {
        //$empresa = $data['cpnId'];
        //$resource = $data['resource'];
        $resourceId = $data['resourceId'];
        //$topic = $data['topic'];
        //$action = $data['action'];
        // $send = $data['send'];
        $sku = isset($data['code']) ? $data['code'] : null;

        //busco datos de la variante 
        $prod = new ProductoBsale();
        //si no viene sku en los parametros, debo obtenerlo
        if( $get_variant || empty($sku) )
        {
            $variante_data = $prod->get_variante($resourceId, false, false);
            $sku = isset($variante_data['code']) ? $variante_data['code'] : null;
        }
        //si no se encontró sku para esta variante
        if( empty($sku) )
        {
            return null;
        }
        //precio normal
        $variante_precio = $prod->get_precio_producto($sku, null, $resourceId);
        $variante_precio_descto1 = 0;
        $variante_precio_descto2 = $variante_precio_descto3 = 0;

        //Funciones::print_r_html($data, "do price");
        //precio descto
        $lp_oferta_id = Funciones::get_lp_oferta_bsale();
        if( $lp_oferta_id > 0 )
        {
            $variante_precio_descto1 = $prod->get_precio_producto($sku, $lp_oferta_id, $resourceId);
        }

        //precio descto 2 (precio normal mayorista)
        if( BSALE_LISTA_PRECIOS_ESPECIALES_2 > 0 )
        {
            $variante_precio_descto2 = $prod->get_precio_producto($sku, BSALE_LISTA_PRECIOS_ESPECIALES_2, $resourceId);
        }

        //precio descto 2 (precio descto mayorista)
        if( BSALE_LISTA_PRECIOS_ESPECIALES_3 > 0 )
        {
            $variante_precio_descto3 = $prod->get_precio_producto($sku, BSALE_LISTA_PRECIOS_ESPECIALES_3, $resourceId);
        }

        $arr = array();
        $arr['price'] = $variante_precio;
        $arr['price_desc'] = $variante_precio_descto1;
        $arr['price_desc2'] = $variante_precio_descto2;
        $arr['price_desc3'] = $variante_precio_descto3;

        //debo agregar impuesto a los precios mayorista?
        /* $add_tax = defined('PRECIOS_MATORISTA_ADD_TAX') ? PRECIOS_MATORISTA_ADD_TAX : false;

          //si es true, mayoristas vienen sin iva y debo agregarlo
          if( $add_tax )
          {
          Funciones::print_r_html("precios mayoristas: precio coom viene de Bsale $variante_precio_descto2 y $variante_precio_descto3");
          $iva = Funciones::get_valor_iva();
          $variante_precio_descto2 = round($variante_precio_descto2 * $iva);
          $variante_precio_descto3 = round($variante_precio_descto3 * $iva);

          $arr['price_desc2'] = $variante_precio_descto2;
          $arr['price_desc3'] = $variante_precio_descto3;

          Funciones::print_r_html("precios mayoristas: precios con iva $variante_precio_descto2 y $variante_precio_descto3");
          } */

        if( $get_variant )
        {
            $arr['variant'] = $variante_data;
        }

        if( $show )
        {
            Funciones::print_r_html($arr, "do_price, full data, variante $resourceId");
        }

        return $arr;
    }

    /**
     * {
      "cpnId":2,
      "resource":"/v2/stocks.json?variant=7079&office=1",
      "resourceId":"7079",
      "topic":"stock",
      "action":"put",en este caso sólo existen notificaciones de actualizaciones de Stock, por lo que la única acción notificada será PUT
      "officeId":"1",
      "send":1503500856
      }
     * @param type $data
     * @param type $show
     */
    public function do_stock($data, $get_variant = true, $show = false)
    {
        //$empresa = $data['cpnId'];
        //$resource = $data['resource'];
        $resourceId = $data['resourceId'];
        //$topic = $data['topic'];
        //$action = $data['action'];
        // $send = $data['send'];
        $sku = isset($data['code']) ? trim($data['code']) : null;

        //busco datos de la variante 
        $prod = new ProductoBsale();
        //si no viene sku en los parametros, debo obtenerlo
        if( $get_variant || empty($sku) )
        {
            $variante_data = $prod->get_variante($resourceId, false, false);
            $sku = isset($variante_data['code']) ? $variante_data['code'] : null;
        }
        //si no se encontró sku para esta variante
        if( empty($sku) )
        {
            return null;
        }
        $total_stock = 0;

        //obtengo datos del stock
        //listado de sucursales, la primera es la matriz
        $otras_sucursales = explode(',', Funciones::get_sucursales_bsale());

        $sucursales_array = array_merge(array( Funciones::get_matriz_bsale() ), $otras_sucursales);

        Funciones::print_r_html("busco stock desde sucursales. " . Funciones::get_matriz_bsale() . ", " . Funciones::get_sucursales_bsale());
        //stock de otras sucursales
        $variante_stock = array();
        $sucursales_stock = array();

        foreach( $sucursales_array as $sucursal_id )
        {
            if( empty($sucursal_id) )
            {
                continue;
            }
            $stock_sucursal = $prod->get_stock_producto($sku, $sucursal_id, $resourceId);

            //colocar en wc solo un porcentaje del stock de bsale
            if( defined('BSALE_WC_PERCENT_STOCK') )
            {
                $porcent = (int) BSALE_WC_PERCENT_STOCK;
                //si es un valor, 
                $porcent_dec = ($porcent > 0 && $porcent < 100) ? $porcent / 100 : 1;

                $stock_sucursal_new = (int) ($stock_sucursal * $porcent_dec);

                if( isset($_REQUEST['param']) )
                {
                    Funciones::print_r_html("get_stock_sucursal_html, sku='$sku', dejar % de stock. Stock orig: $stock_sucursal "
                            . "porcent a dejar: %$porcent, nuevo stock $stock_sucursal_new");
                }
                $stock_sucursal = $stock_sucursal_new;
            }

            $sucursales_stock[$sucursal_id] = $stock_sucursal;

            if( isset($_REQUEST['param']) )
            {
                Funciones::print_r_html("get_stock_sucursal_html, sku='$sku', sucursal bsale='$sucursal_id', stock='$stock_sucursal' ");
            }
            //sumo total stock 
            $total_stock += $stock_sucursal;
        }

        //$total_stock = ($total_stock < 0) ? 0 : $total_stock;

        $variante_stock['variant_total_stock'] = $total_stock;
        $variante_stock['variant_stock_sucursal'] = $sucursales_stock;

        if( $get_variant )
        {
            $variante_stock['variant'] = $variante_data;
        }

        if( $show )
        {
            Funciones::print_r_html($variante_stock, "do_stock, full data, variante $resourceId");
        }

        return $variante_stock;
    }

    /**
     * devuelve un arreglo con stock de todas las sucursales
     * @param type $sku
     */
    public function get_stock_por_sucursal($sku, $all_sucursales = false)
    {
        $sucursales = new SucursalesBsale();
        $prod_obj = new ProductoBsale();

        $arr = array();

        $sucursales_arr = $sucursales->get_all_sucursales();

        if( empty($sucursales_arr) )
        {
            return $arr;
        }

        if( !$all_sucursales && BSALE_SUCURSAL_ALL_SUCURSALES_ID == false )
        {
            //solo stock de sucursales indicadas
            $otras_sucursales = explode(',', Funciones::get_sucursales_bsale());

            $sucursales_array = array_merge(array( Funciones::get_matriz_bsale() ), $otras_sucursales);
        }
        else
        {
            //stock de todas las sucursales
            $sucursales_array = null;
        }

        //recorro sucursales
        foreach( $sucursales_arr as $s )
        {
            $suc_id = $s['id'];
            $suc_name = $s['name'];

            if( $sucursales_array && !in_array($suc_id, $sucursales_array) )
            {
                continue;
            }

            $stock = $prod_obj->get_stock_producto($sku, $suc_id);

            $arraux = array( 'sucursal_id' => $suc_id, 'sucursal_nombre' => $suc_name, 'sku' => $sku, 'stock' => $stock );
            $arr[] = $arraux;
        }

        return $arr;
    }

    /**
     * recorre el arreglo pack_details d, obtiene el stock de cada variante y 
     * devuelve el menor stock hallado
     * @param type $product_data
     */
    public function get_stock_pack($product_data)
    {
        //viene pack?
        if( !isset($product_data['pack_details']) )
        {
            return false;
        }

        $prod = new ProductoBsale();

        //recorro variantes, obtengo el stock de cada una en Bsale y asigno el menor al pack
        //array con el stock de cada variante que forma el pack
        $arr_stocks_variante = array();

        if( isset($_REQUEST['param']) && $_REQUEST['param'] === 'yes' )
        {
            Funciones::print_r_html($product_data['pack_details'], "get_stock_pack: busco stock para variaciones del pack");
        }
        foreach( $product_data['pack_details'] as $v )
        {
            $quantity = $v['quantity'];
            if( $quantity <= 0 )
            {
                if( isset($_REQUEST['param']) && $_REQUEST['param'] === 'yes' )
                {
                    Funciones::print_r_html($v, "get_stock_pack: busco stock para variantid='$variant_id' stock= $quantity <=0, se omite ");
                }
                continue;
            }
            $variant_id = isset($v['variant']['id']) ? $v['variant']['id'] : 0;

            if( $variant_id <= 0 )
            {
                if( isset($_REQUEST['param']) && $_REQUEST['param'] === 'yes' )
                {
                    Funciones::print_r_html($v, "get_stock_pack: busco stock para variantid='$variant_id' <=0, se omite ");
                }
                continue;
            }
            //array con stocks por sucursal
            $stock_variante_bsale_arr = $prod->get_stock_producto_sucursales(null, $variant_id);

            //sumo los stock de todas las sucursales
            $stock_variante_bsale = $this->get_suma_stocks($stock_variante_bsale_arr);

            Funciones::print_r_html("get_stock_pack: busco stock para variantid='$variant_id', stock en el pack=$quantity " .
                    "Stock disponible en Bsale=$stock_variante_bsale");

            //si no hay stock de al menos uina variante, el pack completo no lo tendrá
            if( $stock_variante_bsale <= 0 )
            {
                Funciones::print_r_html("No hay stock de la variacion $variant_id para el pack. Elpack queda en stock cero.");
                return 0;
            }
            //si mi pack tiene 2 unid y en stock hay 40, el máximo de stock del pack
            //es de 40/2= 20 unidades del pack
            $stock_variante = $stock_variante_bsale / $quantity;

            //el stock debe ser, al menos, igual a la cantidad de esa variante que contiene el pack
            if( $stock_variante <= 0 )
            {
                $stock_variante = 0;
            }

            Funciones::print_r_html("Divido el stock de la variacion $variant_id para el pack. "
                    . "stock bsale= $stock_variante_bsale / cantidad= $quantity = stcok vpara este pack=$stock_variante");
            //guardo en listado de stocks de variantes
            $arr_stocks_variante[] = $stock_variante;
        }

        $total_stock_pack = 0;
        //en $arr_stocks_variante están los stock, por separado, de cada variante que conforma el 
        //pack. Extraigo el menor etock y lo devuelvo
        if( count($arr_stocks_variante) > 0 )
        {
            $total_stock_pack = min($arr_stocks_variante);
        }
        Funciones::print_r_html($arr_stocks_variante, "get_stock_pack(), menor stock= $total_stock_pack");

        unset($arr_stocks_variante);

        return floor($total_stock_pack);
    }

    /**
     * recibe un arreglo sucursal id=>stock y devuelve la sum de esos stocks
     * @param type $arr
     */
    public function get_suma_stocks($arr)
    {
        $total = 0;

        if( !$arr || count($arr) <= 0 )
        {
            return $total;
        }

        foreach( $arr as $k => $v )
        {
            $total += (int) $v;
        }
        return $total;
    }

    public function sync_variaciones()
    {
        //si no hay variaciones en la tabla, las cargo dede Bsale
        if( $this->procesar_variaciones() <= 0 )
        {
            $this->load_variaciones_from_bsale();
        }
        //si hay, las leo una a una y llamo al webhook
    }

    public function load_variaciones_from_bsale()
    {
        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html("load_variaciones_from_bsale(), cargo variaciones dede Bsale");
        }
        //cargo sku de cada producto
        $variantes_db = new VariantesProductoBsale();
        //guarda datos de variaciones en otra tabla
        $load_in_new_table = true;
        $variantes_db->get_all_sku_productos($load_in_new_table);
    }

    /**
     * recorre variaciones desde la tabla y las procesa de a una
     */
    public function procesar_variaciones()
    {
        //variable global con nombre de archivo en proceso
        global $global_file_update_product;
        $global_file_update_product = 'sync_stores';

        Funciones::print_r_html("procesar_variaciones(), veo si hay filas para update precio/stock...");
        $count_procesados = 0;
        $load_in_new_table = true;


        $tabla = new SkuProductosTable();

        $var = new ProductosStockBsale();
        $limit = defined('SYNC_STORES_LIMIT') ? SYNC_STORES_LIMIT : 60;
        $variaciones = $var->get_all(null, null, $limit, $load_in_new_table);

        if( isset($_REQUEST['param']) )
        {
           // Funciones::print_r_html($variaciones, "procesar_variaciones, variaciones limit=$limit, cantidad: " . count($variaciones));
        }
      

        foreach( $variaciones as $v )
        {
            $count_procesados++;


            $sku = $v['sku'];
            $variante_id = $v['variante_id'];

            //proceso variacion
            $post_vars_array = array( 'cpnId' => $variante_id,
                'resource' => "/v2/variants/$variante_id.json", 'resourceId' => $variante_id,
                'topic' => 'variant', 'action' => 'put',
                'send' => '1553289004', );

            Funciones::print_r_html("procesar_variaciones(), procesando variante id=$variante_id, sku='$sku'...");

            $this->do_variant($post_vars_array, true, true);
            //la borro de la tabla
            $tabla->delete($variante_id, $load_in_new_table);
            //sleep(1);
        }
        Funciones::print_r_html("procesar_variaciones(), total variaciones procesadas: $count_procesados");

        return $count_procesados;
    }

    /**
     * devielve un string html con el stock por sucursal
     * @param type $data
     */
    public function get_stock_sucursal_html($sku, $es_pack = false, $stock_pack = null, $all_sucursales = false)
    {

        $bsale = new Bsale();

        $arr_stock = $bsale->get_stock_por_sucursal($sku, $all_sucursales);


        //transformo a html
        $arr_html = array();
        $desp_domicilio = false;

        foreach( $arr_stock as $s )
        {
            $sucursal_id = $s['sucursal_id'];
            $sucursal_nombre = trim($s['sucursal_nombre']);
            $sku = $s['sku'];
            $stock = (int) $s['stock'];


            if( $stock > 0 && $es_pack )
            {
                $stock = $stock_pack;
            }

            $sucursal_nombre = bsale_filter_sucursal_name($sucursal_nombre);


            if( $stock < 0 )
            {
                $stock = 0;
            }

            //html de info
            $disp = '';
            $disp = $stock > 3 ? '<span class="disp_stock yes_disp">Hay unidades disponibles</span>' : '<span class="disp_stock no_disp">Solo quedan ' . $stock . ' unidades</span>';

            if( $stock <= 0 )
            {
                $disp = '<span class="disp_stock no_disp">Agotado</span>';
            }
            $straux = "<li id='suc_{$sucursal_id}'><span class='sucursal_name'>$sucursal_nombre:</span> <b class='stock'>$stock</b> $disp</li>";

            $arr_html[] = $straux;

            /*   if( stripos("Apoquindo", $sucursal_nombre) !== false )
              {
              $disp = $stock > 0 ? '<span class="disp_stock yes_disp">disponible</span>' : '<span class="disp_stock no_disp">no disponible</span>';
              $straux = "<li id='suc_888'><span>Vitacura:</span> <b>$stock</b> $disp</li>";
              $arr_html[] = $straux;
              }
             */
            /* if( !$desp_domicilio && stripos("Mac iver", $sucursal_nombre) !== false && $stock > 0 )
              {
              $disp = $stock > 0 ? '<span class="disp_stock yes_disp">disponible</span>' : '<span class="disp_stock no_disp">no disponible</span>';
              $straux = "<li id='suc_999'><span>Despacho a domicilio:</span> <b>$stock</b> $disp</li>";
              array_unshift($arr_html, $straux);
              $desp_domicilio = true;
              //[] = ;
              }
              else if( !$desp_domicilio && stripos("Bodegal", $sucursal_nombre) !== false && $stock > 0 )
              {
              $disp = $stock > 0 ? '<span class="disp_stock yes_disp">disponible</span>' : '<span class="disp_stock no_disp">no disponible</span>';
              $straux = "<li id='suc_999'><span>Despacho a domicilio:</span> <b>$stock</b> $disp</li>";
              array_unshift($arr_html, $straux);
              $desp_domicilio = true;
              //[] = ;
              } */
        }

        //si no se ha colocado despacho a domic, es que stock a domic =0
        /* if( !$desp_domicilio && count($arr_html) > 0 )
          {
          $stock = 0;
          $disp = $stock > 0 ? '<span class="disp_stock yes_disp">disponible</span>' : '<span class="disp_stock no_disp">no disponible</span>';
          $straux = "<li id='suc_999'><span>Despacho a domicilio:</span> <b>$stock</b> $disp</li>";
          array_unshift($arr_html, $straux);
          $desp_domicilio = true;
          } */

        if( count($arr_html) > 0 )
        {
            //paso a string
            $str_html = implode('', $arr_html);
            $str_html .= '<li><span class="stock_info">*Stock desfasado en 10 minutos*</span></li>';
        }
        else
        {
            $str_html = '<li><span class="stock_info no_stock">SIN STOCK</span></li>';
        }


        $str_html = '<div class="bsale_stock_sucursal sku_' . $sku . '">'
                . '<p class="titulo">Stock disponible <span>sku=' . $sku . '</span></p>'
                . '<ul class="stock_list">' . $str_html . '</ul></div>';

        //  Funciones::print_r_html($str_html, "get_stock_sucursal_html($sku)");
        return $str_html;
    }

}
