<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of TipoProductosBsale
 *
 * @author angelorum
 */
class TipoProductosBsale extends DocumentoAbstracto
{

    public function count()
    {
        $url = BSALE_PRODUCTO_TYPE_COUNT_URL;
        $response_array = $this->get($url);

        //  Funciones::print_r_html($response_array, "TipoProductosBsale->count(): $url");

        return isset($response_array['count']) ? $response_array['count'] : -1;
    }

    public function get_all_tipo_productos()
    {
        $tabla = new TipoProductosTable();
        $tabla->clear_all();

        $limit = 50;
        $offset = 0;
        $total = $this->count();

        if( $total <= 0 )
        {
            Funciones::print_r_html("get_all_tipo_productos: No hay");
            return;
        }
        Funciones::print_r_html("get_all_tipo_productos: descargando $total tipos...");

        for(; $total > 0; $total -= $limit )
        {
            $url = BSALE_PRODUCTO_TYPE_GET_URL . "?limit=$limit&offset=$offset";

            $response_array = $this->get($url);
            Funciones::print_r_html($response_array, "get_all_tipo_productos: url='$url', respuesta");

            if( isset($response_array['items']) )
            {
                $response_array = $response_array['items'];
            }
            $len = count($response_array);

            for( $i = 0; $i < $len; $i++ )
            {
                $v = $response_array[$i];

                $id = $v['id'];
                $name = $v['name'];
                $state = $v['state'];

                $array_datos = array();
                $array_datos['id'] = $id;
                $array_datos['name'] = $name;

                $tabla->add($array_datos);
            }
            $offset += $limit;
            unset($response_array);
        }
        return true;
    }

    public function get_tipos_producto()
    {

        $limit = 50;
        $offset = 0;
        $total = $this->count();
        $arr = array();

        if( $total <= 0 )
        {
            //Funciones::print_r_html("get_all_tipo_productos: No hay");
            return $arr;
        }
        if( isset($_REQUEST['param']) )
        {
            Funciones::print_r_html("get_all_tipo_productos: descargando $total tipos...");
        }


        for(; $total > 0; $total -= $limit )
        {
            $url = BSALE_PRODUCTO_TYPE_GET_URL . "?limit=$limit&offset=$offset";

            $response_array = $this->get($url);
            
            if( isset($_REQUEST['param']) )
            {
                Funciones::print_r_html($response_array, "get_all_tipo_productos: url='$url', respuesta");
            }

            if( isset($response_array['items']) )
            {
                $response_array = $response_array['items'];
            }
            $len = count($response_array);

            for( $i = 0; $i < $len; $i++ )
            {
                $v = $response_array[$i];

//                $id = $v['id'];
//                $name = $v['name'];
//                $state = $v['state'];
                $arr[]=$v;
            }
            $offset += $limit;
            unset($response_array);
        }
        return $arr;
    }

}
