<?php
/**
 * Plugin Name: Woocommerce Bsale V2
 * Plugin URI: http://codificando.cl
 * Description: Conecta Woocommerce con BSale
 * Version: 6.6.9
 * Author: Jason Matamala Gajardo
 * Author URI: http://codificando.cl
 * License: GPL2
 * 
 * WC requires at least: 3.0
 * WC tested up to: 6.2.1
 */
//no direct access allowed
defined('ABSPATH') or die('No script kiddies please!');
define('BSALE_OPTIONS_GROUP', 'bsaleoption-group');
define('BSALE_WOOC_URL', plugin_dir_url(__FILE__));



//versin de la tabla de la db
global $woo_bsale_db_version;
$woo_bsale_db_version = '2.0';

global $woo_bsale_db_url;
$woo_bsale_db_url = plugin_dir_url(__FILE__);

global $woo_bsale_db_path;
$woo_bsale_db_path = plugin_dir_path(__FILE__);

/**
 * crea tablas
 * @global <type> $wpdb
 * @global string $woo_bsale_db_version
 */
function woo_bsale_install($delete_old_table = false)
{
    global $woo_bsale_db_version;
    add_option('woo_bsale_db_version', $woo_bsale_db_version);

    require_once dirname(__FILE__) . '/lib/Autoload.php';
    require_once dirname(__FILE__) . '/lib/db/OCDB.class.php';
    $OCDB = new OCDB();

    $OCDB->setupTables();
}

//hooks  para que se llamen las funciones al activar el plugin
register_activation_hook(__FILE__, 'woo_bsale_install');
//register_activation_hook( __FILE__, 'woo_bsale_sample_data' );

/**
 * para saber si hay que upgradear la db
 * @global <type> $jal_db_version
 */
function woo_bsale_update_db_check()
{
    global $woo_bsale_db_version;
    // if( get_site_option('woo_bsale_db_version') != $woo_bsale_db_version )
    //  {
    woo_bsale_install(true);
    //  }
}

//add_action('plugins_loaded', 'woo_bsale_update_db_check');
//actualización de plugin
add_action('upgrader_process_complete', 'woo_bsale_upgrade_function', 10, 2);

function woo_bsale_upgrade_function($upgrader_object, $options)
{
    $current_plugin_path_name = plugin_basename(__FILE__);

    if( $options['action'] == 'update' && $options['type'] == 'plugin' )
    {
        foreach( $options['plugins'] as $each_plugin )
        {
            if( $each_plugin == $current_plugin_path_name )
            {
                woo_bsale_install();
            }
        }
    }
}

/* * *
 * creo admin page para importar los miembros del partido
 *
 *
 */

add_action('admin_menu', 'woo_bsale_admin_menu');

/** Step 1. */
function woo_bsale_admin_menu()
{
    if( is_admin() )
    { // admin actions
        // Add the new admin menu and page and save the returned hook suffix
        $hook_suffix = add_management_page('Woocommerce Bsale', 'Woocommerce Bsale', 'publish_posts', 'woo_bsale-admin-menu', 'woo_bsale_admin_options');

        add_action('admin_init', 'bsale_register_mysettings');
    }
    else
    {
        // non-admin enqueues, actions, and filters
    }
}

function bsale_register_mysettings()
{ // whitelist options
    //register_setting(BSALE_OPTIONS_GROUP, 'bsale_categorias_id', 'bsale_sanitize');
    register_setting(BSALE_OPTIONS_GROUP, 'bsale_limit_stock', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_token');

    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_valor_iva');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_pais');

    //skus to skip
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_skus_prefix_to_skip');

    //estados para nv
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_estados_nv');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_estados_dte');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_payments_nv');

    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_stock_por_sucursal', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_stock_por_sucursal_place');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_declare_sii', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_edit_facturac_data', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_only_prods_bsale', 'intval');
    //checkout fields
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_add_campos_boleta', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_add_campos_factura', 'intval');

    //inventario
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_create_prods', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_update_stock', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_update_price', 'intval');

    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_incluir_despacho_en_dte', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_descontar_iva_precios', 'intval');
    //anular dtes    
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_anular_dtes_cancelled', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_estado_dte_cancelled');

    //emitir boleta segun comuna de facturacion?
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_comuna_sucursal_option', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_comuna_sucursal_listado');

    //enable integraciones
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_enable_inventario', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_enable_facturacion', 'intval');

    //casa ma triz y lista de precios
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_casa_matriz_id', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_lista_precios_id', 'intval');
    //seller id    
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_seller_id', 'intval');

    //lp oferta
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_sync_precios_oferta', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_lista_precios_oferta_id', 'intval');

    //despachos
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_despachar_boleta', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_despachar_factura', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_despachar_gd', 'intval');

    //facturacion
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_send_email', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_send_sku', 'intval');
    //atrib dinamicos
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_dinam_attr_boleta', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_dinam_attr_factura', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_dinam_attr_nv', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_dinam_attr_gd', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_dinam_attr_nc', 'intval');

    //customer notes d.trr
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_dattr_boleta_customer_notes', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_dattr_factura_customer_notes', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_dattr_nv_customer_notes', 'intval');

    //id docs
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_boleta_id', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_factura_id', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_nv_id', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_gd_id', 'intval');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_nc_id', 'intval');

    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_gramaje_prods', 'intval');
    //
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_gramaje_reguex');

    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_stock_por_sucursal_back');

    $args = array(
        'type' => 'array',
        'sanitize_callback' => 'bsale_sanitize_bsale_sucursales_stock',
        'default' => NULL,
    );
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_sucursales_stock', $args);

    $args2 = array(
        'type' => 'array',
        'sanitize_callback' => 'bsale_sanitize_wc_bsale_product_types_stock',
        'default' => NULL,
    );
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_product_types_stock', $args2);

    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_estados_enabled');
    //pagos wc->pagos bsale
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_pagos_bsale');

    //bsale redirects urls
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_redirect_url');

    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_shipping_bsale');
    register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_shipping_filter_stock');

    //mayoristas, request a quote
    if( defined('WC_MAYORISTAS_QUOTES') && WC_MAYORISTAS_QUOTES == true )
    {
        register_setting(BSALE_OPTIONS_GROUP, 'wc_bsale_desctos_plazos_pago');
    }
}

function bsale_sanitize_bsale_sucursales_stock($input)
{
    if( !is_array($input) )
    {
        return null;
    }
    //print_r($input);

    $str = implode(',', $input);
    //die($str); 
    return $str;
}

function bsale_sanitize_wc_bsale_product_types_stock($input)
{
    if( !is_array($input) )
    {
        return null;
    }

    $str = implode(',', $input);
    //die($str); 
    return $str;
}

/**
 * sanitixa valores antes de guardarlos en option
 * @param type $input
 * @return type
 */
function bsale_sanitize($input)
{
    $new_input = array();
    $arraux = explode(',', $input);

    //solo acepto un array de numeros 
    foreach( $arraux as $a )
    {
        $n = trim($a);
        if( empty($n) )
        {
            continue;
        }
        $n = intval($n);
        if( $n == 0 )
        {
            continue;
        }

        $new_input[] = $n;
    }
    //saco duplicados
    $new_input = array_unique($new_input);

    $str = implode(',', $new_input);
    return $str;
}

/** Step 3. */
function woo_bsale_admin_options()
{
    //manage_options
    if( !current_user_can('publish_posts') )
    {
        wp_die(__('You do not have sufficient permissions to access this page.'));
    }
    // return;
    require_once dirname(__FILE__) . '/lib/wp/WpBsale.class.php';

    $order_id = isset($_REQUEST['order_id']) ? $_REQUEST['order_id'] : -1;

    if( $order_id > 0 )
    {
        $status = isset($_REQUEST['ost']) ? $_REQUEST['ost'] : 'completed';
        if( $status === 'completed' )
        {
            do_action('woocommerce_order_status_completed', $order_id);
        }
        else if( $status === 'hold' )
        {
            do_action('woocommerce_order_status_on-hold', $order_id);
        }
    }

    if( isset($_GET['settings-updated']) )
    {
        $msg = '<div id="message" class="updated fade"><p><strong>Los cambios se han guardado correctamente.</strong></p></div>';
    }
    else
    {
        $msg = '';
    }

    require_once dirname(__FILE__) . '/wc_tabs/css.php';

    $tab_to_display = isset($_GET['bsale_tab']) ? $_GET['bsale_tab'] : 'bsale_config';
    ?>

    <div class="wrap bsale_wooc">
        <ul class="bsale_tabs">
            <li class="<?php echo($tab_to_display === 'bsale_config' ? 'sel_tab' : '' ); ?>"><a href="tools.php?page=woo_bsale-admin-menu&bsale_tab=bsale_config">Configurar</a></li> 
            <?php if( Funciones::is_enabled_integ_inventario() ): ?>
                <li class="<?php echo($tab_to_display === 'bsale_sync' ? 'sel_tab' : '' ); ?>"><a href="tools.php?page=woo_bsale-admin-menu&bsale_tab=bsale_sync">Sincronizar productos</a></li>
            <?php endif; ?>
            <?php if( $tab_to_display === 'test' ): ?>
                <li class="<?php echo($tab_to_display === 'test' ? 'sel_tab' : '' ); ?>"><a href="tools.php?page=woo_bsale-admin-menu&bsale_tab=test">Test</a></li>
            <?php endif; ?>
            <!--            <li><a href="tools.php?page=woo_bsale-admin-menu&bsale_tab=bsale_help">Ayuda</a></li>-->
        </ul>
        <?php echo $msg; ?>
        <?php
        if( empty($tab_to_display) || $tab_to_display === 'bsale_config' )
        {
            $file = dirname(__FILE__) . '/wc_tabs/config.php';
        }
        elseif( $tab_to_display === 'bsale_sync' )
        {
            $file = dirname(__FILE__) . '/wc_tabs/sync_prods.php';
        }
        elseif( $tab_to_display === 'bsale_sync' )
        {
            $file = dirname(__FILE__) . '/wc_tabs/bsale_help.php';
        }
        elseif( $tab_to_display === 'test' )
        {
            $file = dirname(__FILE__) . '/wc_tabs/test_page.php';
        }

        if( !empty($file) )
        {
            require_once($file );
        }
        ?>
    </div>

    <?php
}

/**
 * carga scripts para validar
 * @param type $hook
 */
function woo_bsale_my_load_scripts()
{
    global $wp;
    $include = /* is_cart() || */ is_checkout();

    if( Funciones::is_enabled_integ_facturacion() == true && $include )
    {
        wp_enqueue_script('jquery');

        if( Funciones::get_pais() === 'CL' )
        {
            wp_enqueue_script('jquery-rut', plugins_url('js/jquery.Rut.js', __FILE__), array( 'jquery' ), '0.1.1');
            wp_enqueue_script('valida-rut', plugins_url('js/valida_rut.js', __FILE__), array( 'jquery' ), '0.5.1');
            //wp_enqueue_script('datable', plugins_url('js/datable.js', __FILE__), array( 'jquery' ), '0.5');
        }
        elseif( Funciones::get_pais() === 'PE' )
        {
            wp_enqueue_script('valida-dni', plugins_url('js/valida_dni.js', __FILE__), array( 'jquery' ), '0.4.1');
        }
    }
    if( Funciones::is_enabled_integ_inventario() && Funciones::is_mostrar_stock_sucursal() )
    {
        //css con diseño para stock sucursales in page prod
        wp_enqueue_style('bsale-stock', plugins_url('css/bsale_front.css', __FILE__), false, '1.2.1', 'all');
        wp_enqueue_script('bsale-front', plugins_url('js/bsale_front.js', __FILE__), array( 'jquery' ), '0.8.1');
    }

    //wp_register_style('my_css', plugins_url('style.css', __FILE__), false, $my_css_ver);
    // wp_enqueue_style('my_css');
}

add_action('wp_enqueue_scripts', 'woo_bsale_my_load_scripts');

function woo_bsale_my_load_scripts_admin($hook)
{
    if( Funciones::is_enabled_integ_inventario() )
    {
        wp_enqueue_script('jquery-bsale_admin', plugins_url('js/bsale_admin.js', __FILE__), array( 'jquery' ), '1.8.1', true);
    }
}

add_action('admin_enqueue_scripts', 'woo_bsale_my_load_scripts_admin');

/**
 * limipia tabla de miembros
 */
function woo_bsale_clear_data()
{
    //limpio datos de la tabla
    global $wpdb;
    //   $table_name = $wpdb->prefix . JASON_MIEMBROS_TABLE;
    //  $sql = "TRUNCATE TABLE $table_name;";
    //   $e = $wpdb->query( $sql );
}

/* add_filter('woocommerce_billing_fields', 'bsale_require_checkout_fields', 999);

  function bsale_require_checkout_fields($fields)
  {
  //echo("loading...");
  $fields['billing_company']['required'] = true;
  if( isset($fields['billing_ruc']['required']) )
  {
  $fields['billing_ruc']['required'] = true;
  }
  return $fields;
  } */

/**
 * shortcodes
 */
//[foobar]
function woo_bsale_shortcode($atts)
{
    
}

add_shortcode('woo_bsale', 'woo_bsale_shortcode');

require_once dirname(__FILE__) . '/lib/Autoload.php';
include_once dirname(__FILE__) . '/lib/wp/WpBsale.class.php';

function woocommerce_bsale_checkout_fields_function($checkout_fields)
{
    $p = 2999;
    $checkout_fields['billing']['billing_tipo_documento']['priority'] = $p++;
    $checkout_fields['billing']['billing_rut']['priority'] = $p++;
    $checkout_fields['billing']['billing_company']['label'] = 'Nombre de la empresa';
    $checkout_fields['billing']['billing_company']['required'] = true;
    $checkout_fields['billing']['billing_company']['priority'] = $p++;
    $checkout_fields['billing']['billing_giro']['priority'] = $p++;
    return $checkout_fields;
}

if( Funciones::is_add_campos_checkout_factura() )
{
    //para reordenar fields
    add_filter('woocommerce_checkout_fields', 'woocommerce_bsale_checkout_fields_function', 9999999);
}

/**
 * para cronjob con wp cron
 */
function bsale_action_cronjob_webhook_function()
{
    $url = get_site_url() . '/wp-content/plugins/woocommerce-bsalev2/webhooks/bsale_product_wh_procesar.php?param=yes';
    wp_remote_get($url);

    return true;



    // Inicia cURL
    $session = curl_init($url);


    // Indica a cURL que retorne data
    curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 400);
    curl_setopt($session, CURLOPT_TIMEOUT, 400); //timeout in seconds
    // Configura cabeceras
    $headers = array(
    );
    curl_setopt($session, CURLOPT_HTTPHEADER, $headers);
    //Tell cURL that it should only spend 10 seconds
    //trying to connect to the URL in question.
    curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 300);

    //A given cURL operation should only take
    //30 seconds max.
    curl_setopt($session, CURLOPT_TIMEOUT, 300);

    // Ejecuta cURL
    $response = curl_exec($session);
    $code = curl_getinfo($session, CURLINFO_HTTP_CODE);

    // Cierra la sesión cURL
    curl_close($session);
}

add_action('bsale_action_cronjob_webhook', 'bsale_action_cronjob_webhook_function');

/**
 * para cronjob con wp cron resend webhook messages
 */
function bsale_action_cronjob_resend_function()
{
    $url = get_site_url() . '/wp-content/plugins/woocommerce-bsalev2/webhooks/bsale_product_resend_single.php?param=yes';
    wp_remote_get($url);

    return true;



    // Inicia cURL
    $session = curl_init($url);


    // Indica a cURL que retorne data
    curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 400);
    curl_setopt($session, CURLOPT_TIMEOUT, 400); //timeout in seconds
    // Configura cabeceras
    $headers = array(
    );
    curl_setopt($session, CURLOPT_HTTPHEADER, $headers);
    //Tell cURL that it should only spend 10 seconds
    //trying to connect to the URL in question.
    curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 300);

    //A given cURL operation should only take
    //30 seconds max.
    curl_setopt($session, CURLOPT_TIMEOUT, 300);

    // Ejecuta cURL
    $response = curl_exec($session);
    $code = curl_getinfo($session, CURLINFO_HTTP_CODE);

    // Cierra la sesión cURL
    curl_close($session);
}

add_action('bsale_action_cronjob_resend', 'bsale_action_cronjob_resend_function');

function bsale_codificacl_general_admin_notice()
{
    global $pagenow;
//    if ( $pagenow == 'options-general.php' ) {
//       
//    }

    if( !is_admin() )
    {
        return;
    }

    WpUtils::get_bsale_last_error_notice();
}

add_action('admin_notices', 'bsale_codificacl_general_admin_notice');

function bsale_ajax_sync_prod_action()
{
    //global $wpdb; // this is how you get access to the database
    //echo("en ajax!");
    include_once dirname(__FILE__) . '/sync/product_sync_bsale.php';
    wp_die(); // this is required to terminate immediately and return a proper response
}

//ajax para sync prods
add_action('wp_ajax_bsale_ajax_sync_prod_action', 'bsale_ajax_sync_prod_action');


/**
 * agrega id de transsaccion en los emails
 */
/*add_filter('woocommerce_email_order_meta_fields', 'custom_woocommerce_email_order_meta_fields', 10, 3);

function custom_woocommerce_email_order_meta_fields($fields, $sent_to_admin, $order)
{
    $tid = get_post_meta($order->id, 'webpay_transaction_id', true);
    $cn = get_post_meta($order->id, 'cardNumber', true);

    if( !empty($tid) )
    {
        $fields['webpay_transaction_id'] = array(
            'label' => __('Id de transaccion Wepay'),
            'value' => $tid,
        );
    }
    if( !empty($cn) )
    {
        $fields['cardNumber'] = array(
            'label' => __('Tarjeta'),
            'value' => "***$cn",
        );
    }

    return $fields;
}*/

/*add_action( 'wp_footer', 'bsale_add_jscript_checkout', 9999 );
 
function bsale_add_jscript_checkout() {
   global $wp;
   if ( is_checkout() && empty( $wp->query_vars['order-pay'] ) && ! isset( $wp->query_vars['order-received'] ) ) 
   {
      include_once dirname(__FILE__) . '/valida.php';
   }
}*/
