<?php

require_once dirname(__FILE__) . '/../Autoload.php';
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SucursalesBsale
 *
 * @author angelorum
 */
class SucursalesBsale extends DocumentoAbstracto
{

    public function count()
    {

        $url = BSALE_SUCURSALES_URL . '?limit=1&offset=0';
        $response_array = $this->get($url);

        //  Funciones::print_r_html($response_array, "StockProductosBsale->count(): $url");

        return isset($response_array['count']) ? $response_array['count'] : -1;
    }

    public function get_all_sucursales_array()
    {
        $sucursales = $this->get_all_sucursales(false);

        $arraux = array();

        if( !is_array($sucursales) )
        {
            return $arraux;
        }

        foreach( $sucursales as $s )
        {
            $suc_id = $s['id'];
            $suc_name = $s['name'];

            $arraux[$suc_id] = $suc_name;
        }

        return $arraux;
    }

    /**
     * indices: id, name, etc
     * @return type
     */
    public function get_all_sucursales($save_in_table = false)
    {

        $limit = 50;
        $offset = 0;
        $total = $this->count();

        $table = new SucursalesTable();
        //borro sucursales guardadas
        if( $save_in_table )
        {
            $table->clear_all();
        }

        if( $total <= 0 )
        {
            //Funciones::print_r_html("No hay lista de sucursales");
            return array();
        }
        //Funciones::print_r_html("get_all_sucursales: descargando $total sucursales...");
        //  $total = 300;
        //recorro y voy guardando en la db temporal
        for(; $total > 0; $total -= $limit )
        {
            $url = BSALE_SUCURSALES_URL . "?limit=$limit&offset=$offset";

            //  Funciones::print_r_html("get_all_stock_productos: $url");

            $response_array = $this->get($url);
            if( isset($response_array['items']) )
            {
                $response_array = $response_array['items'];
            }
//devuelvo un array con con [producto_id]=>sku
            $arraux = array();
            $len = count($response_array);
            for( $i = 0; $i < $len; $i++ )
            {
                $v = $response_array[$i];

                //si debo guardar en tabla de db o no
                if( $save_in_table )
                {
                    $array_datos = array( 'sucursal_id' => $v['id'],
                        'nombre' => utf8_encode($v['name']) );
                    $table->add($array_datos);
                }
            }


            $offset += $limit;

            // unset( $response_array );
        }
        return $response_array;
    }

    /**
     * devuelve un array con los ids de todas las sucursales 
     */
    public function get_all_sucursales_ids()
    {
        $arr = $this->get_all_sucursales();
        $array_sucursales = array();

        foreach( $arr as $value )
        {
            $array_sucursales[] = $value['id'];
        }
        return $array_sucursales;
    }

}
